// Generated by gmmproc 2.55.1 -- DO NOT MODIFY!
#ifndef _GDKMM_EVENT_H
#define _GDKMM_EVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 1998-2002 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <glibmm/refptr.h>
#include <glibmm/value.h>

/* Shadow DELETE macro (from winnt.h).
 * It interferes with Gdk::Event::Type::DELETE.
 */
#if defined(DELETE) && !defined(GTKMM_MACRO_SHADOW_DELETE)
enum { GTKMM_MACRO_DEFINITION_DELETE = DELETE };
#undef DELETE
enum { DELETE = GTKMM_MACRO_DEFINITION_DELETE };
#define DELETE DELETE
#define GTKMM_MACRO_SHADOW_DELETE 1
#endif

#ifndef DOXYGEN_SHOULD_SKIP_THIS
extern "C" { typedef union _GdkEvent GdkEvent; }
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gdk
{
class Screen;
class Seat;
class Window;

/** Represents an event.
 */
class Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Event;
  using BaseObjectType = GdkEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  /// Get the GType for this class, for use with the underlying GObject type system.
  static GType get_type() G_GNUC_CONST;

  /** Creates an invalid event object.
   * Calling any member functions other than operator bool() is undefined behavior.
   * An invalid event object can be used in a function call, if the underlying
   * C function expects a NULL GdkEvent pointer.
   */
  Event();

  /** Wraps a C event instance.
   * This constructor either acquires ownership of @a gobject, or copies it.
   *
   * @param gobject %Event to wrap.
   * @param make_a_copy If @c false, the ownership of @a gobject is acquired,
   *        otherwise a copy is made.
   */
  explicit Event(GdkEvent* gobject, bool make_a_copy = false);

  Event(const Event& other);
  Event& operator=(const Event& other);

  Event(Event&& other) noexcept;
  Event& operator=(Event&& other) noexcept;

  ~Event() noexcept;

  void swap(Event& other) noexcept;

  /// Provides access to the underlying C instance.
  GdkEvent* gobj() noexcept { return gobject_; }

  /// Provides access to the underlying C instance.
  const GdkEvent* gobj() const noexcept { return gobject_; }

  /** Provides access to the underlying C instance.
   * The caller is responsible for freeing it with gdk_event_free().
   * Use when directly setting fields in structs.
   */
  GdkEvent* gobj_copy() const;

private:
  GdkEvent* gobject_;

  
public:

  /** @addtogroup gdkmmEnums gdkmm Enums and Flags */

  /** 
   *  @var Type NOTHING
   * A special code to indicate a null event.
   * 
   *  @var Type DELETE
   * The window manager has requested that the toplevel window be
   * hidden or destroyed, usually when the user clicks on a special icon in the
   * title bar.
   * 
   *  @var Type DESTROY
   * The window has been destroyed.
   * 
   *  @var Type EXPOSE
   * All or part of the window has become visible and needs to be
   * redrawn.
   * 
   *  @var Type MOTION_NOTIFY
   * The pointer (usually a mouse) has moved.
   * 
   *  @var Type BUTTON_PRESS
   * A mouse button has been pressed.
   * 
   *  @var Type DOUBLE_BUTTON_PRESS
   * A mouse button has been double-clicked (clicked twice
   * within a short period of time). Note that each click also generates a
   * Gdk::Event::Type::BUTTON_PRESS event.
   * 
   *  @var Type TRIPLE_BUTTON_PRESS
   * A mouse button has been clicked 3 times in a short period
   * of time. Note that each click also generates a Gdk::Event::Type::BUTTON_PRESS event.
   * 
   *  @var Type BUTTON_RELEASE
   * A mouse button has been released.
   * 
   *  @var Type KEY_PRESS
   * A key has been pressed.
   * 
   *  @var Type KEY_RELEASE
   * A key has been released.
   * 
   *  @var Type ENTER_NOTIFY
   * The pointer has entered the window.
   * 
   *  @var Type LEAVE_NOTIFY
   * The pointer has left the window.
   * 
   *  @var Type FOCUS_CHANGE
   * The keyboard focus has entered or left the window.
   * 
   *  @var Type CONFIGURE
   * The size, position or stacking order of the window has changed.
   * Note that GTK+ discards these events for Gdk::Window::Type::CHILD windows.
   * 
   *  @var Type MAP
   * The window has been mapped.
   * 
   *  @var Type UNMAP
   * The window has been unmapped.
   * 
   *  @var Type PROPERTY_NOTIFY
   * A property on the window has been changed or deleted.
   * 
   *  @var Type SELECTION_CLEAR
   * The application has lost ownership of a selection.
   * 
   *  @var Type SELECTION_REQUEST
   * Another application has requested a selection.
   * 
   *  @var Type SELECTION_NOTIFY
   * A selection has been received.
   * 
   *  @var Type PROXIMITY_IN
   * An input device has moved into contact with a sensing
   * surface (e.g. a touchscreen or graphics tablet).
   * 
   *  @var Type PROXIMITY_OUT
   * An input device has moved out of contact with a sensing
   * surface.
   * 
   *  @var Type DRAG_ENTER
   * The mouse has entered the window while a drag is in progress.
   * 
   *  @var Type DRAG_LEAVE
   * The mouse has left the window while a drag is in progress.
   * 
   *  @var Type DRAG_MOTION
   * The mouse has moved in the window while a drag is in
   * progress.
   * 
   *  @var Type DRAG_STATUS
   * The status of the drag operation initiated by the window
   * has changed.
   * 
   *  @var Type DROP_START
   * A drop operation onto the window has started.
   * 
   *  @var Type DROP_FINISHED
   * The drop operation initiated by the window has completed.
   * 
   *  @var Type CLIENT_EVENT
   * A message has been received from another application.
   * 
   *  @var Type VISIBILITY_NOTIFY
   * The window visibility status has changed.
   * 
   *  @var Type SCROLL
   * The scroll wheel was turned.
   * 
   *  @var Type WINDOW_STATE
   * The state of a window has changed. See Gdk::Window::State
   * for the possible window states.
   * 
   *  @var Type SETTING
   * A setting has been modified.
   * 
   *  @var Type OWNER_CHANGE
   * The owner of a selection has changed. This event type
   * was added in 2.6.
   * 
   *  @var Type GRAB_BROKEN
   * A pointer or keyboard grab was broken. This event type
   * was added in 2.8.
   * 
   *  @var Type DAMAGE
   * The content of the window has been changed. This event type
   * was added in 2.14.
   * 
   *  @var Type TOUCH_BEGIN
   * A new touch event sequence has just started. This event
   * type was added in 3.4.
   * 
   *  @var Type TOUCH_UPDATE
   * A touch event sequence has been updated. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCH_END
   * A touch event sequence has finished. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCH_CANCEL
   * A touch event sequence has been canceled. This event type
   * was added in 3.4.
   * 
   *  @var Type TOUCHPAD_SWIPE
   * A touchpad swipe gesture event, the current state
   * is determined by its phase field. This event type was added in 3.18.
   * 
   *  @var Type TOUCHPAD_PINCH
   * A touchpad pinch gesture event, the current state
   * is determined by its phase field. This event type was added in 3.18.
   * 
   *  @var Type PAD_BUTTON_PRESS
   * A tablet pad button press event. This event type
   * was added in 3.22.
   * 
   *  @var Type PAD_BUTTON_RELEASE
   * A tablet pad button release event. This event type
   * was added in 3.22.
   * 
   *  @var Type PAD_RING
   * A tablet pad axis event from a "ring". This event type was
   * added in 3.22.
   * 
   *  @var Type PAD_STRIP
   * A tablet pad axis event from a "strip". This event type was
   * added in 3.22.
   * 
   *  @var Type PAD_GROUP_MODE
   * A tablet pad group mode change. This event type was
   * added in 3.22.
   * 
   *  @var Type EVENT_LAST
   * Marks the end of the GdkEventType enumeration. Added in 2.18.
   * 
   *  @enum Type
   * 
   * Specifies the type of the event.
   * 
   * Do not confuse these events with the signals that GTK+ widgets emit.
   * Although many of these events result in corresponding signals being emitted,
   * the events are often transformed or filtered along the way.
   * 
   * In some language bindings, the values Gdk::Event::Type::2BUTTON_PRESS and
   * Gdk::Event::Type::3BUTTON_PRESS would translate into something syntactically
   * invalid (eg `Gdk.EventType.2ButtonPress`, where a
   * symbol is not allowed to start with a number). In that case, the
   * aliases Gdk::Event::Type::DOUBLE_BUTTON_PRESS and Gdk::Event::Type::TRIPLE_BUTTON_PRESS can
   * be used instead.
   *
   * @ingroup gdkmmEnums
   */
  enum class Type
  {
    NOTHING = -1,
    DELETE = 0,
    DESTROY = 1,
    EXPOSE = 2,
    MOTION_NOTIFY = 3,
    BUTTON_PRESS = 4,
    DOUBLE_BUTTON_PRESS = 5,
    TRIPLE_BUTTON_PRESS = 6,
    BUTTON_RELEASE = 7,
    KEY_PRESS = 8,
    KEY_RELEASE = 9,
    ENTER_NOTIFY = 10,
    LEAVE_NOTIFY = 11,
    FOCUS_CHANGE = 12,
    CONFIGURE = 13,
    MAP = 14,
    UNMAP = 15,
    PROPERTY_NOTIFY = 16,
    SELECTION_CLEAR = 17,
    SELECTION_REQUEST = 18,
    SELECTION_NOTIFY = 19,
    PROXIMITY_IN = 20,
    PROXIMITY_OUT = 21,
    DRAG_ENTER = 22,
    DRAG_LEAVE = 23,
    DRAG_MOTION = 24,
    DRAG_STATUS = 25,
    DROP_START = 26,
    DROP_FINISHED = 27,
    CLIENT_EVENT = 28,
    VISIBILITY_NOTIFY = 29,
    SCROLL = 31,
    WINDOW_STATE = 32,
    SETTING = 33,
    OWNER_CHANGE = 34,
    GRAB_BROKEN = 35,
    DAMAGE = 36,
    TOUCH_BEGIN = 37,
    TOUCH_UPDATE = 38,
    TOUCH_END = 39,
    TOUCH_CANCEL = 40,
    TOUCHPAD_SWIPE = 41,
    TOUCHPAD_PINCH = 42,
    PAD_BUTTON_PRESS = 43,
    PAD_BUTTON_RELEASE = 44,
    PAD_RING = 45,
    PAD_STRIP = 46,
    PAD_GROUP_MODE = 47,
    EVENT_LAST = 48
  };


  /** Discover whether the event is valid.
   * For instance,
   * @code
   * if (event)
   *   do_something();
   * @endcode
   *
   * @newin{3,92}
   */
  explicit operator bool() const noexcept;

  
  /** Retrieves the type of the event.
   * 
   * @newin{3,10}
   * 
   * @return A Gdk::Event::Type.
   */
  Event::Type get_event_type() const;

  /**
   * Returns the window which received the event
   */
  Glib::RefPtr<Gdk::Window> get_window();
  Glib::RefPtr<const Gdk::Window> get_window() const;
  

  /**
   * Returns @c true if the event was sent explicitly (e.g. using @c XSendEvent)
   */
  bool is_send_event() const;

  //_WRAP_METHOD(void	gdk_event_handler_set(GdkEventFunc func, gpointer data, GDestroyNotify  notify), gdk_event_handler_set)

  
  /** Sets whether a trace of received events is output.
   * Note that GTK+ must be compiled with debugging (that is,
   * configured using the `--enable-debug` option)
   * to use this option.
   * 
   * @param show_events <tt>true</tt> to output event debugging information.
   */
  static void set_show_events(bool show_events);
  
  /** Gets whether event debugging output is enabled.
   * 
   * @return <tt>true</tt> if event debugging output is enabled.
   */
  static bool get_show_events();

   //deprecated
  
  /** Returns the screen for the event. The screen is
   * typically the screen for `event->any.window`, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which `event->motion.x_root` and
   * `event->motion.y_root` are relative.
   * 
   * @newin{2,2}
   * 
   * @return The screen for the event.
   */
  Glib::RefPtr<Screen> get_screen();
  
  /** Returns the screen for the event. The screen is
   * typically the screen for `event->any.window`, but
   * for events such as mouse events, it is the screen
   * where the pointer was when the event occurs -
   * that is, the screen which has the root window 
   * to which `event->motion.x_root` and
   * `event->motion.y_root` are relative.
   * 
   * @newin{2,2}
   * 
   * @return The screen for the event.
   */
  Glib::RefPtr<const Screen> get_screen() const;

  
  /** Returns the Gdk::Seat this event was generated for.
   * 
   * @newin{3,90}
   * 
   * @return The Gdk::Seat of this event.
   */
  Glib::RefPtr<Seat> get_seat();
  
  /** Returns the Gdk::Seat this event was generated for.
   * 
   * @newin{3,90}
   * 
   * @return The Gdk::Seat of this event.
   */
  Glib::RefPtr<const Seat> get_seat() const;

  
  /** Checks all open displays for a Gdk::Event to process,to be processed
   * on, fetching events from the windowing system if necessary.
   * See Gdk::Display::get_event().
   * 
   * @return The next Gdk::Event to be processed, or <tt>nullptr</tt>
   * if no events are pending. The returned Gdk::Event should be freed
   * with free().
   */
  static Event get();
  
  /** If there is an event waiting in the event queue of some open
   * display, returns a copy of it. See Gdk::Display::peek_event().
   * 
   * @return A copy of the first Gdk::Event on some event
   * queue, or <tt>nullptr</tt> if no events are in any queues. The returned
   * Gdk::Event should be freed with free().
   */
  static Event peek();
  
  /** Appends a copy of the given event onto the front of the event
   * queue for event->any.window’s display, or the default event
   * queue if event->any.window is <tt>nullptr</tt>. See Gdk::Display::put_event().
   */
  void put();
  
  /** Checks if any events are ready to be processed for any display.
   * 
   * @return <tt>true</tt> if any events are pending.
   */
  static bool events_pending();

  //TODO: If GdkDeviceTool is wrapped in gtkmm, wrap gdk_event_get_device_tool().
   // "Should be rarely used"

  // Belong to subclasses:
  

};

} // namespace Gdk


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gdk::Event::Type> : public Glib::Value_Enum<Gdk::Event::Type>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdk
{

/**
 * @param lhs The left-hand side
 * @param rhs The right-hand side
 *
 * @relates Gdk::Event
 */
inline void swap(Event& lhs, Event& rhs) noexcept
  { lhs.swap(rhs); }

/** Wraps a C event instance without making unnecessary copy when the ownership
 * can not be acquired.
 *
 * The @a event pointer must not be deleted until last usage of the returned
 * instance. Note, that this requirement applies to the pointer itself, in
 * addition to the object it is pointing to.
 *
 * @relates Gdk::Event
 */
const Event& wrap_event(const GdkEvent*& event);

/** See wrap_event(const GdkEvent*& event).
 *
 * @relates Gdk::Event
 */
Event& wrap_event(GdkEvent*& event);

} // namespace Gdk

namespace Glib
{

/** A Glib::wrap() method for this object.
 *
 * @param object The C instance.
 * @param take_copy @c false if the result should take ownership of the C instance,
 *        @c true if it should take a new copy.
 * @result A C++ instance that wraps this C instance.
 *
 * @relates Gdk::Event
 */
Gdk::Event wrap(GdkEvent* object, bool take_copy = false);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
template <>
class Value<Gdk::Event> : public Glib::Value_Boxed<Gdk::Event>
{};
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

} // namespace Glib


#endif /* _GDKMM_EVENT_H */

