/* signal-manager.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from signal-manager.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
typedef struct _FolksInspectSignalManagerPrivate FolksInspectSignalManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_closure_unref0(var) ((var == NULL) ? NULL : (var = (g_closure_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

struct _FolksInspectSignalManager {
	GObject parent_instance;
	FolksInspectSignalManagerPrivate * priv;
};

struct _FolksInspectSignalManagerClass {
	GObjectClass parent_class;
};

struct _FolksInspectSignalManagerPrivate {
	GeeHashMap* signals_by_class_type;
	GeeHashMap* signals_by_class_instance;
};


static gpointer folks_inspect_signal_manager_parent_class = NULL;

GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerPrivate))
enum  {
	FOLKS_INSPECT_SIGNAL_MANAGER_DUMMY_PROPERTY
};
FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_indent (void);
static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map);
void folks_inspect_utils_unindent (void);
void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string);
static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags);
guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string);
static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string);
guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string);
static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id);
static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id);
static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue** return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data);
static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data);
static void _vala_GValue_free (GValue* self);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1);
static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self);
static void folks_inspect_signal_manager_finalize (GObject* obj);


FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type) {
	FolksInspectSignalManager * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	self = (FolksInspectSignalManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_GTYPE, NULL, NULL, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_type);
	self->priv->signals_by_class_type = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	self->priv->signals_by_class_instance = _tmp1_;
	return self;
}


FolksInspectSignalManager* folks_inspect_signal_manager_new (void) {
	return folks_inspect_signal_manager_construct (FOLKS_INSPECT_TYPE_SIGNAL_MANAGER);
}


void folks_inspect_signal_manager_list_signals (FolksInspectSignalManager* self, GType class_type, GObject* class_instance) {
	GType _tmp0_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = class_type;
	if (_tmp0_ != G_TYPE_INVALID) {
		GeeHashMap* hook_ids = NULL;
		GeeHashMap* _tmp1_ = NULL;
		GType _tmp2_ = 0UL;
		gpointer _tmp3_ = NULL;
		GType _tmp4_ = 0UL;
		const gchar* _tmp5_ = NULL;
		GType _tmp6_ = 0UL;
		GeeHashMap* _tmp7_ = NULL;
		_tmp1_ = self->priv->signals_by_class_type;
		_tmp2_ = class_type;
		_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) _tmp2_));
		hook_ids = (GeeHashMap*) _tmp3_;
		_tmp4_ = class_type;
		_tmp5_ = g_type_name (_tmp4_);
		folks_inspect_utils_print_line ("Signals on all instances of class type '%s':", _tmp5_);
		folks_inspect_utils_indent ();
		_tmp6_ = class_type;
		_tmp7_ = hook_ids;
		folks_inspect_signal_manager_list_signals_for_type (self, _tmp6_, _tmp7_);
		folks_inspect_utils_unindent ();
		_g_object_unref0 (hook_ids);
	} else {
		GObject* _tmp8_ = NULL;
		_tmp8_ = class_instance;
		if (_tmp8_ != NULL) {
			GeeHashMap* signal_handler_ids = NULL;
			GeeHashMap* _tmp9_ = NULL;
			GObject* _tmp10_ = NULL;
			gpointer _tmp11_ = NULL;
			GObject* _tmp12_ = NULL;
			GObject* _tmp13_ = NULL;
			GType _tmp14_ = 0UL;
			const gchar* _tmp15_ = NULL;
			GObject* _tmp16_ = NULL;
			GType _tmp17_ = 0UL;
			GeeHashMap* _tmp18_ = NULL;
			_tmp9_ = self->priv->signals_by_class_instance;
			_tmp10_ = class_instance;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
			signal_handler_ids = (GeeHashMap*) _tmp11_;
			_tmp12_ = class_instance;
			_tmp13_ = class_instance;
			_tmp14_ = G_TYPE_FROM_INSTANCE (_tmp13_);
			_tmp15_ = g_type_name (_tmp14_);
			folks_inspect_utils_print_line ("Signals on instance %p of class type '%s':", _tmp12_, _tmp15_);
			folks_inspect_utils_indent ();
			_tmp16_ = class_instance;
			_tmp17_ = G_TYPE_FROM_INSTANCE (_tmp16_);
			_tmp18_ = signal_handler_ids;
			folks_inspect_signal_manager_list_signals_for_type (self, _tmp17_, _tmp18_);
			folks_inspect_utils_unindent ();
			_g_object_unref0 (signal_handler_ids);
		} else {
			GeeMapIterator* class_type_iter = NULL;
			GeeHashMap* _tmp19_ = NULL;
			GeeMapIterator* _tmp20_ = NULL;
			GeeMapIterator* class_instance_iter = NULL;
			GeeHashMap* _tmp37_ = NULL;
			GeeMapIterator* _tmp38_ = NULL;
			_tmp19_ = self->priv->signals_by_class_type;
			_tmp20_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp19_);
			class_type_iter = _tmp20_;
			folks_inspect_utils_print_line ("Connected signals on all instances of classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp21_ = NULL;
				gboolean _tmp22_ = FALSE;
				GeeHashMap* hook_ids = NULL;
				GeeMapIterator* _tmp23_ = NULL;
				gpointer _tmp24_ = NULL;
				GeeMapIterator* hook_iter = NULL;
				GeeHashMap* _tmp25_ = NULL;
				GeeMapIterator* _tmp26_ = NULL;
				gchar* class_name = NULL;
				GeeMapIterator* _tmp27_ = NULL;
				gpointer _tmp28_ = NULL;
				const gchar* _tmp29_ = NULL;
				gchar* _tmp30_ = NULL;
				_tmp21_ = class_type_iter;
				_tmp22_ = gee_map_iterator_next (_tmp21_);
				if (!(_tmp22_ == TRUE)) {
					break;
				}
				_tmp23_ = class_type_iter;
				_tmp24_ = gee_map_iterator_get_value (_tmp23_);
				hook_ids = (GeeHashMap*) _tmp24_;
				_tmp25_ = hook_ids;
				_tmp26_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp25_);
				hook_iter = _tmp26_;
				_tmp27_ = class_type_iter;
				_tmp28_ = gee_map_iterator_get_key (_tmp27_);
				_tmp29_ = g_type_name ((GType) ((gintptr) _tmp28_));
				_tmp30_ = g_strdup (_tmp29_);
				class_name = _tmp30_;
				while (TRUE) {
					GeeMapIterator* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					const gchar* _tmp33_ = NULL;
					GeeMapIterator* _tmp34_ = NULL;
					gpointer _tmp35_ = NULL;
					const gchar* _tmp36_ = NULL;
					_tmp31_ = hook_iter;
					_tmp32_ = gee_map_iterator_next (_tmp31_);
					if (!(_tmp32_ == TRUE)) {
						break;
					}
					_tmp33_ = class_name;
					_tmp34_ = hook_iter;
					_tmp35_ = gee_map_iterator_get_key (_tmp34_);
					_tmp36_ = g_signal_name ((guint) ((guintptr) _tmp35_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp33_, _tmp36_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (hook_iter);
				_g_object_unref0 (hook_ids);
			}
			folks_inspect_utils_unindent ();
			_tmp37_ = self->priv->signals_by_class_instance;
			_tmp38_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp37_);
			class_instance_iter = _tmp38_;
			folks_inspect_utils_print_line ("%s", "Connected signals on specific instances of " "classes:");
			folks_inspect_utils_indent ();
			while (TRUE) {
				GeeMapIterator* _tmp39_ = NULL;
				gboolean _tmp40_ = FALSE;
				GeeHashMap* signal_handler_ids = NULL;
				GeeMapIterator* _tmp41_ = NULL;
				gpointer _tmp42_ = NULL;
				GeeMapIterator* signal_handler_iter = NULL;
				GeeHashMap* _tmp43_ = NULL;
				GeeMapIterator* _tmp44_ = NULL;
				gchar* class_name = NULL;
				GeeMapIterator* _tmp45_ = NULL;
				gpointer _tmp46_ = NULL;
				GObject* _tmp47_ = NULL;
				GType _tmp48_ = 0UL;
				const gchar* _tmp49_ = NULL;
				gchar* _tmp50_ = NULL;
				gchar* _tmp51_ = NULL;
				_tmp39_ = class_instance_iter;
				_tmp40_ = gee_map_iterator_next (_tmp39_);
				if (!(_tmp40_ == TRUE)) {
					break;
				}
				_tmp41_ = class_instance_iter;
				_tmp42_ = gee_map_iterator_get_value (_tmp41_);
				signal_handler_ids = (GeeHashMap*) _tmp42_;
				_tmp43_ = signal_handler_ids;
				_tmp44_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp43_);
				signal_handler_iter = _tmp44_;
				_tmp45_ = class_instance_iter;
				_tmp46_ = gee_map_iterator_get_key (_tmp45_);
				_tmp47_ = (GObject*) _tmp46_;
				_tmp48_ = G_TYPE_FROM_INSTANCE (_tmp47_);
				_tmp49_ = g_type_name (_tmp48_);
				_tmp50_ = g_strdup (_tmp49_);
				_tmp51_ = _tmp50_;
				_g_object_unref0 (_tmp47_);
				class_name = _tmp51_;
				while (TRUE) {
					GeeMapIterator* _tmp52_ = NULL;
					gboolean _tmp53_ = FALSE;
					const gchar* _tmp54_ = NULL;
					GeeMapIterator* _tmp55_ = NULL;
					gpointer _tmp56_ = NULL;
					const gchar* _tmp57_ = NULL;
					_tmp52_ = signal_handler_iter;
					_tmp53_ = gee_map_iterator_next (_tmp52_);
					if (!(_tmp53_ == TRUE)) {
						break;
					}
					_tmp54_ = class_name;
					_tmp55_ = signal_handler_iter;
					_tmp56_ = gee_map_iterator_get_key (_tmp55_);
					_tmp57_ = g_signal_name ((guint) ((guintptr) _tmp56_));
					folks_inspect_utils_print_line ("%s::%s — connected", _tmp54_, _tmp57_);
				}
				_g_free0 (class_name);
				_g_object_unref0 (signal_handler_iter);
				_g_object_unref0 (signal_handler_ids);
			}
			folks_inspect_utils_unindent ();
			_g_object_unref0 (class_instance_iter);
			_g_object_unref0 (class_type_iter);
		}
	}
}


void folks_inspect_signal_manager_show_signal_details (FolksInspectSignalManager* self, GType class_type, const gchar* signal_name, const gchar* detail_string) {
	guint signal_id = 0U;
	const gchar* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GSignalQuery query_info = {0};
	guint _tmp7_ = 0U;
	GSignalQuery _tmp8_ = {0};
	GSignalQuery _tmp9_ = {0};
	guint _tmp10_ = 0U;
	GSignalQuery _tmp11_ = {0};
	const gchar* _tmp12_ = NULL;
	GSignalQuery _tmp13_ = {0};
	GType _tmp14_ = 0UL;
	const gchar* _tmp15_ = NULL;
	GSignalQuery _tmp16_ = {0};
	GSignalFlags _tmp17_ = 0;
	gchar* _tmp18_ = NULL;
	gchar* _tmp19_ = NULL;
	GSignalQuery _tmp20_ = {0};
	GType _tmp21_ = 0UL;
	const gchar* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = signal_name;
	_tmp1_ = class_type;
	_tmp2_ = g_signal_lookup (_tmp0_, _tmp1_);
	signal_id = _tmp2_;
	_tmp3_ = signal_id;
	if (_tmp3_ == ((guint) 0)) {
		const gchar* _tmp4_ = NULL;
		GType _tmp5_ = 0UL;
		const gchar* _tmp6_ = NULL;
		_tmp4_ = signal_name;
		_tmp5_ = class_type;
		_tmp6_ = g_type_name (_tmp5_);
		folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp4_, _tmp6_);
		return;
	}
	_tmp7_ = signal_id;
	g_signal_query (_tmp7_, &_tmp8_);
	query_info = _tmp8_;
	_tmp9_ = query_info;
	_tmp10_ = _tmp9_.signal_id;
	folks_inspect_utils_print_line ("Signal ID        %u", _tmp10_);
	_tmp11_ = query_info;
	_tmp12_ = _tmp11_.signal_name;
	folks_inspect_utils_print_line ("Signal name      %s", _tmp12_);
	_tmp13_ = query_info;
	_tmp14_ = _tmp13_.itype;
	_tmp15_ = g_type_name (_tmp14_);
	folks_inspect_utils_print_line ("Emitting type    %s", _tmp15_);
	_tmp16_ = query_info;
	_tmp17_ = _tmp16_.signal_flags;
	_tmp18_ = folks_inspect_signal_manager_signal_flags_to_string (_tmp17_);
	_tmp19_ = _tmp18_;
	folks_inspect_utils_print_line ("Signal flags     %s", _tmp19_);
	_g_free0 (_tmp19_);
	_tmp20_ = query_info;
	_tmp21_ = _tmp20_.return_type;
	_tmp22_ = g_type_name (_tmp21_);
	folks_inspect_utils_print_line ("Return type      %s", _tmp22_);
	folks_inspect_utils_print_line ("Parameter types:");
	folks_inspect_utils_indent ();
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				guint _tmp25_ = 0U;
				GSignalQuery _tmp26_ = {0};
				guint _tmp27_ = 0U;
				guint _tmp28_ = 0U;
				GSignalQuery _tmp29_ = {0};
				GType* _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				guint _tmp31_ = 0U;
				GType _tmp32_ = 0UL;
				const gchar* _tmp33_ = NULL;
				if (!_tmp23_) {
					guint _tmp24_ = 0U;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				_tmp25_ = i;
				_tmp26_ = query_info;
				_tmp27_ = _tmp26_.n_params;
				if (!(_tmp25_ < _tmp27_)) {
					break;
				}
				_tmp28_ = i;
				_tmp29_ = query_info;
				_tmp30_ = _tmp29_.param_types;
				_tmp30__length1 = -1;
				_tmp31_ = i;
				_tmp32_ = _tmp30_[_tmp31_];
				_tmp33_ = g_type_name (_tmp32_);
				folks_inspect_utils_print_line ("%-4u  %s", _tmp28_, _tmp33_);
			}
		}
	}
	folks_inspect_utils_unindent ();
}


guint folks_inspect_signal_manager_connect_to_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_ = 0UL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = class_type;
	if (_tmp1_ != G_TYPE_INVALID) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = signal_name;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint signal_id = 0U;
		const gchar* _tmp3_ = NULL;
		GType _tmp4_ = 0UL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		GType _tmp10_ = 0UL;
		guint _tmp11_ = 0U;
		const gchar* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp3_ = signal_name;
		_tmp4_ = class_type;
		_tmp5_ = g_signal_lookup (_tmp3_, _tmp4_);
		signal_id = _tmp5_;
		_tmp6_ = signal_id;
		if (_tmp6_ == ((guint) 0)) {
			const gchar* _tmp7_ = NULL;
			GType _tmp8_ = 0UL;
			const gchar* _tmp9_ = NULL;
			_tmp7_ = signal_name;
			_tmp8_ = class_type;
			_tmp9_ = g_type_name (_tmp8_);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp7_, _tmp9_);
			result = (guint) 0;
			return result;
		}
		_tmp10_ = class_type;
		_tmp11_ = signal_id;
		_tmp12_ = detail_string;
		_tmp13_ = folks_inspect_signal_manager_add_emission_hook (self, _tmp10_, _tmp11_, _tmp12_);
		if (_tmp13_ == FALSE) {
			const gchar* _tmp14_ = NULL;
			GType _tmp15_ = 0UL;
			const gchar* _tmp16_ = NULL;
			_tmp14_ = signal_name;
			_tmp15_ = class_type;
			_tmp16_ = g_type_name (_tmp15_);
			folks_inspect_utils_print_line ("Not allowed to connect to signal '%s' on " "class '%s'.", _tmp14_, _tmp16_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp17_ = FALSE;
		GType _tmp18_ = 0UL;
		_tmp18_ = class_type;
		if (_tmp18_ != G_TYPE_INVALID) {
			const gchar* _tmp19_ = NULL;
			_tmp19_ = signal_name;
			_tmp17_ = _tmp19_ == NULL;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			guint* signal_ids = NULL;
			GType _tmp20_ = 0UL;
			gint _tmp21_ = 0;
			guint* _tmp22_ = NULL;
			gint signal_ids_length1 = 0;
			gint _signal_ids_size_ = 0;
			guint signal_count = 0U;
			guint* _tmp23_ = NULL;
			gint _tmp23__length1 = 0;
			_tmp20_ = class_type;
			_tmp22_ = g_signal_list_ids (_tmp20_, &_tmp21_);
			signal_ids = _tmp22_;
			signal_ids_length1 = _tmp21_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp23_ = signal_ids;
			_tmp23__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp23_;
				signal_id_collection_length1 = _tmp23__length1;
				for (signal_id_it = 0; signal_id_it < _tmp23__length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						GType _tmp24_ = 0UL;
						guint _tmp25_ = 0U;
						gboolean _tmp26_ = FALSE;
						_tmp24_ = class_type;
						_tmp25_ = signal_id;
						_tmp26_ = folks_inspect_signal_manager_add_emission_hook (self, _tmp24_, _tmp25_, NULL);
						if (_tmp26_ == TRUE) {
							guint _tmp27_ = 0U;
							_tmp27_ = signal_count;
							signal_count = _tmp27_ + 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp28_ = FALSE;
			GObject* _tmp29_ = NULL;
			_tmp29_ = class_instance;
			if (_tmp29_ != NULL) {
				const gchar* _tmp30_ = NULL;
				_tmp30_ = signal_name;
				_tmp28_ = _tmp30_ != NULL;
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				guint signal_id = 0U;
				const gchar* _tmp31_ = NULL;
				GObject* _tmp32_ = NULL;
				GType _tmp33_ = 0UL;
				guint _tmp34_ = 0U;
				guint _tmp35_ = 0U;
				GObject* _tmp41_ = NULL;
				guint _tmp42_ = 0U;
				const gchar* _tmp43_ = NULL;
				_tmp31_ = signal_name;
				_tmp32_ = class_instance;
				_tmp33_ = G_TYPE_FROM_INSTANCE (_tmp32_);
				_tmp34_ = g_signal_lookup (_tmp31_, _tmp33_);
				signal_id = _tmp34_;
				_tmp35_ = signal_id;
				if (_tmp35_ == ((guint) 0)) {
					const gchar* _tmp36_ = NULL;
					GObject* _tmp37_ = NULL;
					GObject* _tmp38_ = NULL;
					GType _tmp39_ = 0UL;
					const gchar* _tmp40_ = NULL;
					_tmp36_ = signal_name;
					_tmp37_ = class_instance;
					_tmp38_ = class_instance;
					_tmp39_ = G_TYPE_FROM_INSTANCE (_tmp38_);
					_tmp40_ = g_type_name (_tmp39_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", _tmp36_, _tmp37_, _tmp40_);
					result = (guint) 0;
					return result;
				}
				_tmp41_ = class_instance;
				_tmp42_ = signal_id;
				_tmp43_ = detail_string;
				folks_inspect_signal_manager_add_signal_handler (self, _tmp41_, _tmp42_, _tmp43_);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp44_ = FALSE;
				GObject* _tmp45_ = NULL;
				_tmp45_ = class_instance;
				if (_tmp45_ != NULL) {
					const gchar* _tmp46_ = NULL;
					_tmp46_ = signal_name;
					_tmp44_ = _tmp46_ == NULL;
				} else {
					_tmp44_ = FALSE;
				}
				if (_tmp44_) {
					guint* signal_ids = NULL;
					GObject* _tmp47_ = NULL;
					GType _tmp48_ = 0UL;
					gint _tmp49_ = 0;
					guint* _tmp50_ = NULL;
					gint signal_ids_length1 = 0;
					gint _signal_ids_size_ = 0;
					guint signal_count = 0U;
					guint* _tmp51_ = NULL;
					gint _tmp51__length1 = 0;
					_tmp47_ = class_instance;
					_tmp48_ = G_TYPE_FROM_INSTANCE (_tmp47_);
					_tmp50_ = g_signal_list_ids (_tmp48_, &_tmp49_);
					signal_ids = _tmp50_;
					signal_ids_length1 = _tmp49_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp51_ = signal_ids;
					_tmp51__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp51_;
						signal_id_collection_length1 = _tmp51__length1;
						for (signal_id_it = 0; signal_id_it < _tmp51__length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								guint _tmp52_ = 0U;
								GObject* _tmp53_ = NULL;
								guint _tmp54_ = 0U;
								_tmp52_ = signal_count;
								signal_count = _tmp52_ + 1;
								_tmp53_ = class_instance;
								_tmp54_ = signal_id;
								folks_inspect_signal_manager_add_signal_handler (self, _tmp53_, _tmp54_, NULL);
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


guint folks_inspect_signal_manager_disconnect_from_signal (FolksInspectSignalManager* self, GType class_type, GObject* class_instance, const gchar* signal_name, const gchar* detail_string) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	GType _tmp1_ = 0UL;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp1_ = class_type;
	if (_tmp1_ != G_TYPE_INVALID) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = signal_name;
		_tmp0_ = _tmp2_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint signal_id = 0U;
		const gchar* _tmp3_ = NULL;
		GType _tmp4_ = 0UL;
		guint _tmp5_ = 0U;
		guint _tmp6_ = 0U;
		GType _tmp10_ = 0UL;
		guint _tmp11_ = 0U;
		gboolean _tmp12_ = FALSE;
		_tmp3_ = signal_name;
		_tmp4_ = class_type;
		_tmp5_ = g_signal_lookup (_tmp3_, _tmp4_);
		signal_id = _tmp5_;
		_tmp6_ = signal_id;
		if (_tmp6_ == ((guint) 0)) {
			const gchar* _tmp7_ = NULL;
			GType _tmp8_ = 0UL;
			const gchar* _tmp9_ = NULL;
			_tmp7_ = signal_name;
			_tmp8_ = class_type;
			_tmp9_ = g_type_name (_tmp8_);
			folks_inspect_utils_print_line ("Unrecognised signal name '%s' on class '%s'.", _tmp7_, _tmp9_);
			result = (guint) 0;
			return result;
		}
		_tmp10_ = class_type;
		_tmp11_ = signal_id;
		_tmp12_ = folks_inspect_signal_manager_remove_emission_hook (self, _tmp10_, _tmp11_);
		if (_tmp12_ == FALSE) {
			const gchar* _tmp13_ = NULL;
			GType _tmp14_ = 0UL;
			const gchar* _tmp15_ = NULL;
			_tmp13_ = signal_name;
			_tmp14_ = class_type;
			_tmp15_ = g_type_name (_tmp14_);
			folks_inspect_utils_print_line ("Could not remove hook for signal '%s' on " "class '%s'.", _tmp13_, _tmp15_);
			result = (guint) 0;
			return result;
		}
		result = (guint) 1;
		return result;
	} else {
		gboolean _tmp16_ = FALSE;
		GType _tmp17_ = 0UL;
		_tmp17_ = class_type;
		if (_tmp17_ != G_TYPE_INVALID) {
			const gchar* _tmp18_ = NULL;
			_tmp18_ = signal_name;
			_tmp16_ = _tmp18_ == NULL;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			guint* signal_ids = NULL;
			GType _tmp19_ = 0UL;
			gint _tmp20_ = 0;
			guint* _tmp21_ = NULL;
			gint signal_ids_length1 = 0;
			gint _signal_ids_size_ = 0;
			guint signal_count = 0U;
			guint* _tmp22_ = NULL;
			gint _tmp22__length1 = 0;
			_tmp19_ = class_type;
			_tmp21_ = g_signal_list_ids (_tmp19_, &_tmp20_);
			signal_ids = _tmp21_;
			signal_ids_length1 = _tmp20_;
			_signal_ids_size_ = signal_ids_length1;
			signal_count = (guint) 0;
			_tmp22_ = signal_ids;
			_tmp22__length1 = signal_ids_length1;
			{
				guint* signal_id_collection = NULL;
				gint signal_id_collection_length1 = 0;
				gint _signal_id_collection_size_ = 0;
				gint signal_id_it = 0;
				signal_id_collection = _tmp22_;
				signal_id_collection_length1 = _tmp22__length1;
				for (signal_id_it = 0; signal_id_it < _tmp22__length1; signal_id_it = signal_id_it + 1) {
					guint signal_id = 0U;
					signal_id = signal_id_collection[signal_id_it];
					{
						GType _tmp23_ = 0UL;
						guint _tmp24_ = 0U;
						gboolean _tmp25_ = FALSE;
						_tmp23_ = class_type;
						_tmp24_ = signal_id;
						_tmp25_ = folks_inspect_signal_manager_remove_emission_hook (self, _tmp23_, _tmp24_);
						if (_tmp25_ == TRUE) {
							guint _tmp26_ = 0U;
							_tmp26_ = signal_count;
							signal_count = _tmp26_ - 1;
						}
					}
				}
			}
			result = signal_count;
			signal_ids = (g_free (signal_ids), NULL);
			return result;
		} else {
			gboolean _tmp27_ = FALSE;
			GObject* _tmp28_ = NULL;
			_tmp28_ = class_instance;
			if (_tmp28_ != NULL) {
				const gchar* _tmp29_ = NULL;
				_tmp29_ = signal_name;
				_tmp27_ = _tmp29_ != NULL;
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				guint signal_id = 0U;
				const gchar* _tmp30_ = NULL;
				GObject* _tmp31_ = NULL;
				GType _tmp32_ = 0UL;
				guint _tmp33_ = 0U;
				guint _tmp34_ = 0U;
				GObject* _tmp40_ = NULL;
				guint _tmp41_ = 0U;
				_tmp30_ = signal_name;
				_tmp31_ = class_instance;
				_tmp32_ = G_TYPE_FROM_INSTANCE (_tmp31_);
				_tmp33_ = g_signal_lookup (_tmp30_, _tmp32_);
				signal_id = _tmp33_;
				_tmp34_ = signal_id;
				if (_tmp34_ == ((guint) 0)) {
					const gchar* _tmp35_ = NULL;
					GObject* _tmp36_ = NULL;
					GObject* _tmp37_ = NULL;
					GType _tmp38_ = 0UL;
					const gchar* _tmp39_ = NULL;
					_tmp35_ = signal_name;
					_tmp36_ = class_instance;
					_tmp37_ = class_instance;
					_tmp38_ = G_TYPE_FROM_INSTANCE (_tmp37_);
					_tmp39_ = g_type_name (_tmp38_);
					folks_inspect_utils_print_line ("Unrecognised signal name '%s' on instance " "%p of class '%s'.", _tmp35_, _tmp36_, _tmp39_);
					result = (guint) 0;
					return result;
				}
				_tmp40_ = class_instance;
				_tmp41_ = signal_id;
				folks_inspect_signal_manager_remove_signal_handler (self, _tmp40_, _tmp41_);
				result = (guint) 1;
				return result;
			} else {
				gboolean _tmp42_ = FALSE;
				GObject* _tmp43_ = NULL;
				_tmp43_ = class_instance;
				if (_tmp43_ != NULL) {
					const gchar* _tmp44_ = NULL;
					_tmp44_ = signal_name;
					_tmp42_ = _tmp44_ == NULL;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					guint* signal_ids = NULL;
					GObject* _tmp45_ = NULL;
					GType _tmp46_ = 0UL;
					gint _tmp47_ = 0;
					guint* _tmp48_ = NULL;
					gint signal_ids_length1 = 0;
					gint _signal_ids_size_ = 0;
					guint signal_count = 0U;
					guint* _tmp49_ = NULL;
					gint _tmp49__length1 = 0;
					_tmp45_ = class_instance;
					_tmp46_ = G_TYPE_FROM_INSTANCE (_tmp45_);
					_tmp48_ = g_signal_list_ids (_tmp46_, &_tmp47_);
					signal_ids = _tmp48_;
					signal_ids_length1 = _tmp47_;
					_signal_ids_size_ = signal_ids_length1;
					signal_count = (guint) 0;
					_tmp49_ = signal_ids;
					_tmp49__length1 = signal_ids_length1;
					{
						guint* signal_id_collection = NULL;
						gint signal_id_collection_length1 = 0;
						gint _signal_id_collection_size_ = 0;
						gint signal_id_it = 0;
						signal_id_collection = _tmp49_;
						signal_id_collection_length1 = _tmp49__length1;
						for (signal_id_it = 0; signal_id_it < _tmp49__length1; signal_id_it = signal_id_it + 1) {
							guint signal_id = 0U;
							signal_id = signal_id_collection[signal_id_it];
							{
								GObject* _tmp50_ = NULL;
								guint _tmp51_ = 0U;
								gboolean _tmp52_ = FALSE;
								_tmp50_ = class_instance;
								_tmp51_ = signal_id;
								_tmp52_ = folks_inspect_signal_manager_remove_signal_handler (self, _tmp50_, _tmp51_);
								if (_tmp52_) {
									guint _tmp53_ = 0U;
									_tmp53_ = signal_count;
									signal_count = _tmp53_ - 1;
								}
							}
						}
					}
					result = signal_count;
					signal_ids = (g_free (signal_ids), NULL);
					return result;
				}
			}
		}
	}
	g_assert_not_reached ();
}


static void folks_inspect_signal_manager_list_signals_for_type (FolksInspectSignalManager* self, GType type, GeeHashMap* signal_id_map) {
	guint* signal_ids = NULL;
	GType _tmp0_ = 0UL;
	gint _tmp1_ = 0;
	guint* _tmp2_ = NULL;
	gint signal_ids_length1 = 0;
	gint _signal_ids_size_ = 0;
	guint* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GType* interfaces = NULL;
	GType _tmp19_ = 0UL;
	guint _tmp20_;
	GType* _tmp21_ = NULL;
	gint interfaces_length1 = 0;
	gint _interfaces_size_ = 0;
	GType* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	GType parent_type = 0UL;
	GType _tmp25_ = 0UL;
	GType _tmp26_ = 0UL;
	GType _tmp27_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = type;
	_tmp2_ = g_signal_list_ids (_tmp0_, &_tmp1_);
	signal_ids = _tmp2_;
	signal_ids_length1 = _tmp1_;
	_signal_ids_size_ = signal_ids_length1;
	_tmp3_ = signal_ids;
	_tmp3__length1 = signal_ids_length1;
	if (_tmp3_ != NULL) {
		gchar* type_name = NULL;
		GType _tmp4_ = 0UL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		guint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		_tmp4_ = type;
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_strdup (_tmp5_);
		type_name = _tmp6_;
		_tmp7_ = signal_ids;
		_tmp7__length1 = signal_ids_length1;
		{
			guint* signal_id_collection = NULL;
			gint signal_id_collection_length1 = 0;
			gint _signal_id_collection_size_ = 0;
			gint signal_id_it = 0;
			signal_id_collection = _tmp7_;
			signal_id_collection_length1 = _tmp7__length1;
			for (signal_id_it = 0; signal_id_it < _tmp7__length1; signal_id_it = signal_id_it + 1) {
				guint signal_id = 0U;
				signal_id = signal_id_collection[signal_id_it];
				{
					const gchar* signal_name = NULL;
					guint _tmp8_ = 0U;
					const gchar* _tmp9_ = NULL;
					gboolean _tmp10_ = FALSE;
					GeeHashMap* _tmp11_ = NULL;
					_tmp8_ = signal_id;
					_tmp9_ = g_signal_name (_tmp8_);
					signal_name = _tmp9_;
					_tmp11_ = signal_id_map;
					if (_tmp11_ != NULL) {
						GeeHashMap* _tmp12_ = NULL;
						guint _tmp13_ = 0U;
						gboolean _tmp14_ = FALSE;
						_tmp12_ = signal_id_map;
						_tmp13_ = signal_id;
						_tmp14_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp12_, (gpointer) ((guintptr) _tmp13_));
						_tmp10_ = _tmp14_ == TRUE;
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						const gchar* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						_tmp15_ = type_name;
						_tmp16_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s — connected", _tmp15_, _tmp16_);
					} else {
						const gchar* _tmp17_ = NULL;
						const gchar* _tmp18_ = NULL;
						_tmp17_ = type_name;
						_tmp18_ = signal_name;
						folks_inspect_utils_print_line ("%s::%s", _tmp17_, _tmp18_);
					}
				}
			}
		}
		_g_free0 (type_name);
	}
	_tmp19_ = type;
	_tmp21_ = g_type_interfaces (_tmp19_, &_tmp20_);
	interfaces = _tmp21_;
	interfaces_length1 = _tmp20_;
	_interfaces_size_ = interfaces_length1;
	_tmp22_ = interfaces;
	_tmp22__length1 = interfaces_length1;
	{
		GType* interface_type_collection = NULL;
		gint interface_type_collection_length1 = 0;
		gint _interface_type_collection_size_ = 0;
		gint interface_type_it = 0;
		interface_type_collection = _tmp22_;
		interface_type_collection_length1 = _tmp22__length1;
		for (interface_type_it = 0; interface_type_it < _tmp22__length1; interface_type_it = interface_type_it + 1) {
			GType interface_type = 0UL;
			interface_type = interface_type_collection[interface_type_it];
			{
				GType _tmp23_ = 0UL;
				GeeHashMap* _tmp24_ = NULL;
				_tmp23_ = interface_type;
				_tmp24_ = signal_id_map;
				folks_inspect_signal_manager_list_signals_for_type (self, _tmp23_, _tmp24_);
			}
		}
	}
	_tmp25_ = type;
	_tmp26_ = g_type_parent (_tmp25_);
	parent_type = _tmp26_;
	_tmp27_ = parent_type;
	if (_tmp27_ != G_TYPE_INVALID) {
		GType _tmp28_ = 0UL;
		GeeHashMap* _tmp29_ = NULL;
		_tmp28_ = parent_type;
		_tmp29_ = signal_id_map;
		folks_inspect_signal_manager_list_signals_for_type (self, _tmp28_, _tmp29_);
	}
	interfaces = (g_free (interfaces), NULL);
	signal_ids = (g_free (signal_ids), NULL);
}


static void _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal (GClosure* closure, GValue* return_value, int param_values_length1, GValue* param_values, void* invocation_hint, void* marshal_data) {
	folks_inspect_signal_manager_signal_meta_marshaller (closure, return_value, param_values, param_values_length1, invocation_hint, marshal_data);
}


static void folks_inspect_signal_manager_add_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id, const gchar* detail_string) {
	GClosure* closure = NULL;
	GClosure* _tmp0_ = NULL;
	GClosure* _tmp1_ = NULL;
	GQuark detail_quark = 0U;
	const gchar* _tmp2_ = NULL;
	gulong signal_handler_id = 0UL;
	GObject* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GQuark _tmp7_ = 0U;
	GClosure* _tmp8_ = NULL;
	gulong _tmp9_ = 0UL;
	GeeHashMap* signal_handler_ids = NULL;
	GeeHashMap* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	gpointer _tmp12_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	gulong _tmp20_ = 0UL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (class_instance != NULL);
	_tmp0_ = g_closure_new_object ((gulong) sizeof (GClosure), (GObject*) self);
	closure = _tmp0_;
	_tmp1_ = closure;
	g_closure_set_meta_marshal (_tmp1_, NULL, _folks_inspect_signal_manager_signal_meta_marshaller_gclosure_marshal);
	detail_quark = (GQuark) 0;
	_tmp2_ = detail_string;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		GQuark _tmp4_ = 0U;
		_tmp3_ = detail_string;
		_tmp4_ = g_quark_try_string (_tmp3_);
		detail_quark = _tmp4_;
	}
	_tmp5_ = class_instance;
	_tmp6_ = signal_id;
	_tmp7_ = detail_quark;
	_tmp8_ = closure;
	_tmp9_ = g_signal_connect_closure_by_id (_tmp5_, _tmp6_, _tmp7_, _tmp8_, FALSE);
	signal_handler_id = _tmp9_;
	_tmp10_ = self->priv->signals_by_class_instance;
	_tmp11_ = class_instance;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
	signal_handler_ids = (GeeHashMap*) _tmp12_;
	_tmp13_ = signal_handler_ids;
	if (_tmp13_ == NULL) {
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		GObject* _tmp16_ = NULL;
		GeeHashMap* _tmp17_ = NULL;
		_tmp14_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (signal_handler_ids);
		signal_handler_ids = _tmp14_;
		_tmp15_ = self->priv->signals_by_class_instance;
		_tmp16_ = class_instance;
		_tmp17_ = signal_handler_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, _tmp16_, _tmp17_);
	}
	_tmp18_ = signal_handler_ids;
	_tmp19_ = signal_id;
	_tmp20_ = signal_handler_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, (gpointer) ((guintptr) _tmp19_), (gpointer) ((guintptr) _tmp20_));
	_g_object_unref0 (signal_handler_ids);
	_g_closure_unref0 (closure);
}


static gboolean folks_inspect_signal_manager_remove_signal_handler (FolksInspectSignalManager* self, GObject* class_instance, guint signal_id) {
	gboolean result = FALSE;
	GeeHashMap* signal_handler_ids = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GObject* _tmp1_ = NULL;
	gpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_ = NULL;
	gulong signal_handler_id = 0UL;
	GeeHashMap* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gpointer _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	gulong _tmp12_ = 0UL;
	GeeHashMap* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (class_instance != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_instance;
	_tmp1_ = class_instance;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, _tmp1_);
	signal_handler_ids = (GeeHashMap*) _tmp2_;
	_tmp4_ = signal_handler_ids;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeHashMap* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = signal_handler_ids;
		_tmp6_ = signal_id;
		_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
		_tmp3_ = _tmp7_ == FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		_g_object_unref0 (signal_handler_ids);
		return result;
	}
	_tmp8_ = signal_handler_ids;
	_tmp9_ = signal_id;
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) _tmp9_));
	signal_handler_id = (gulong) ((guintptr) _tmp10_);
	_tmp11_ = class_instance;
	_tmp12_ = signal_handler_id;
	g_signal_handler_disconnect (_tmp11_, _tmp12_);
	_tmp13_ = signal_handler_ids;
	_tmp14_ = signal_id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) _tmp14_), NULL);
	result = TRUE;
	_g_object_unref0 (signal_handler_ids);
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void folks_inspect_signal_manager_signal_meta_marshaller (GClosure* closure, GValue** return_value, GValue* param_values, int param_values_length1, void* invocation_hint, void* marshal_data) {
	GValue* _vala_return_value = NULL;
	GSignalInvocationHint* hint = NULL;
	void* _tmp0_ = NULL;
	GSignalQuery query_info = {0};
	GSignalInvocationHint* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GSignalQuery _tmp3_ = {0};
	GSignalQuery _tmp4_ = {0};
	GType _tmp5_ = 0UL;
	const gchar* _tmp6_ = NULL;
	GSignalQuery _tmp7_ = {0};
	const gchar* _tmp8_ = NULL;
	guint i = 0U;
	GValue* _tmp9_ = NULL;
	gint _tmp9__length1 = 0;
	g_return_if_fail (closure != NULL);
	_tmp0_ = invocation_hint;
	hint = (GSignalInvocationHint*) _tmp0_;
	__vala_GValue_free0 (_vala_return_value);
	_vala_return_value = NULL;
	_tmp1_ = hint;
	_tmp2_ = (*_tmp1_).signal_id;
	g_signal_query (_tmp2_, &_tmp3_);
	query_info = _tmp3_;
	_tmp4_ = query_info;
	_tmp5_ = _tmp4_.itype;
	_tmp6_ = g_type_name (_tmp5_);
	_tmp7_ = query_info;
	_tmp8_ = _tmp7_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp6_, _tmp8_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	_tmp9_ = param_values;
	_tmp9__length1 = param_values_length1;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = _tmp9_;
		param_value_collection_length1 = _tmp9__length1;
		for (param_value_it = 0; param_value_it < _tmp9__length1; param_value_it = param_value_it + 1) {
			GValue _tmp10_ = {0};
			GValue param_value = {0};
			if (G_IS_VALUE (&param_value_collection[param_value_it])) {
				g_value_init (&_tmp10_, G_VALUE_TYPE (&param_value_collection[param_value_it]));
				g_value_copy (&param_value_collection[param_value_it], &_tmp10_);
			} else {
				_tmp10_ = param_value_collection[param_value_it];
			}
			param_value = _tmp10_;
			{
				guint _tmp11_ = 0U;
				GType _tmp12_ = 0UL;
				const gchar* _tmp13_ = NULL;
				GValue _tmp14_ = {0};
				gchar* _tmp15_ = NULL;
				gchar* _tmp16_ = NULL;
				_tmp11_ = i;
				i = _tmp11_ + 1;
				_tmp12_ = G_VALUE_TYPE (&param_value);
				_tmp13_ = g_type_name (_tmp12_);
				_tmp14_ = param_value;
				_tmp15_ = folks_inspect_utils_transform_value_to_string (&_tmp14_);
				_tmp16_ = _tmp15_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp11_, _tmp13_, _tmp16_);
				_g_free0 (_tmp16_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	if (return_value) {
		*return_value = _vala_return_value;
	} else {
		__vala_GValue_free0 (_vala_return_value);
	}
}


static gboolean _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook (GSignalInvocationHint* ihint, int param_values_length1, GValue* param_values, gpointer self) {
	gboolean result;
	result = folks_inspect_signal_manager_emission_hook_cb ((FolksInspectSignalManager*) self, ihint, param_values, param_values_length1);
	return result;
}


static gboolean folks_inspect_signal_manager_add_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id, const gchar* detail_string) {
	gboolean result = FALSE;
	GQuark detail_quark = 0U;
	const gchar* _tmp0_ = NULL;
	GSignalQuery query = {0};
	guint _tmp3_ = 0U;
	GSignalQuery _tmp4_ = {0};
	GSignalQuery _tmp5_ = {0};
	GSignalFlags _tmp6_ = 0;
	gulong hook_id = 0UL;
	guint _tmp7_ = 0U;
	GQuark _tmp8_ = 0U;
	gulong _tmp9_ = 0UL;
	GeeHashMap* hook_ids = NULL;
	GeeHashMap* _tmp10_ = NULL;
	GType _tmp11_ = 0UL;
	gpointer _tmp12_ = NULL;
	GeeHashMap* _tmp13_ = NULL;
	GeeHashMap* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	gulong _tmp20_ = 0UL;
	g_return_val_if_fail (self != NULL, FALSE);
	detail_quark = (GQuark) 0;
	_tmp0_ = detail_string;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		GQuark _tmp2_ = 0U;
		_tmp1_ = detail_string;
		_tmp2_ = g_quark_try_string (_tmp1_);
		detail_quark = _tmp2_;
	}
	_tmp3_ = signal_id;
	g_signal_query (_tmp3_, &_tmp4_);
	query = _tmp4_;
	_tmp5_ = query;
	_tmp6_ = _tmp5_.signal_flags;
	if ((_tmp6_ & G_SIGNAL_NO_HOOKS) != 0) {
		result = FALSE;
		return result;
	}
	_tmp7_ = signal_id;
	_tmp8_ = detail_quark;
	_tmp9_ = g_signal_add_emission_hook (_tmp7_, _tmp8_, _folks_inspect_signal_manager_emission_hook_cb_gsignal_emission_hook, self, NULL);
	hook_id = _tmp9_;
	_tmp10_ = self->priv->signals_by_class_type;
	_tmp11_ = class_type;
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) _tmp11_));
	hook_ids = (GeeHashMap*) _tmp12_;
	_tmp13_ = hook_ids;
	if (_tmp13_ == NULL) {
		GeeHashMap* _tmp14_ = NULL;
		GeeHashMap* _tmp15_ = NULL;
		GType _tmp16_ = 0UL;
		GeeHashMap* _tmp17_ = NULL;
		_tmp14_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, G_TYPE_ULONG, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (hook_ids);
		hook_ids = _tmp14_;
		_tmp15_ = self->priv->signals_by_class_type;
		_tmp16_ = class_type;
		_tmp17_ = hook_ids;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, (gpointer) ((gintptr) _tmp16_), _tmp17_);
	}
	_tmp18_ = hook_ids;
	_tmp19_ = signal_id;
	_tmp20_ = hook_id;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, (gpointer) ((guintptr) _tmp19_), (gpointer) ((guintptr) _tmp20_));
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_remove_emission_hook (FolksInspectSignalManager* self, GType class_type, guint signal_id) {
	gboolean result = FALSE;
	GeeHashMap* hook_ids = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GType _tmp1_ = 0UL;
	gpointer _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GeeHashMap* _tmp4_ = NULL;
	gulong hook_id = 0UL;
	GeeHashMap* _tmp8_ = NULL;
	guint _tmp9_ = 0U;
	gpointer _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	gulong _tmp12_ = 0UL;
	GeeHashMap* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->signals_by_class_type;
	_tmp1_ = class_type;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp1_));
	hook_ids = (GeeHashMap*) _tmp2_;
	_tmp4_ = hook_ids;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		GeeHashMap* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = hook_ids;
		_tmp6_ = signal_id;
		_tmp7_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, (gpointer) ((guintptr) _tmp6_));
		_tmp3_ = _tmp7_ == FALSE;
	}
	if (_tmp3_) {
		result = FALSE;
		_g_object_unref0 (hook_ids);
		return result;
	}
	_tmp8_ = hook_ids;
	_tmp9_ = signal_id;
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) _tmp9_));
	hook_id = (gulong) ((guintptr) _tmp10_);
	_tmp11_ = signal_id;
	_tmp12_ = hook_id;
	g_signal_remove_emission_hook (_tmp11_, _tmp12_);
	_tmp13_ = hook_ids;
	_tmp14_ = signal_id;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp13_, (gpointer) ((guintptr) _tmp14_), NULL);
	result = TRUE;
	_g_object_unref0 (hook_ids);
	return result;
}


static gboolean folks_inspect_signal_manager_emission_hook_cb (FolksInspectSignalManager* self, GSignalInvocationHint* hint, GValue* param_values, int param_values_length1) {
	gboolean result = FALSE;
	GSignalQuery query_info = {0};
	GSignalInvocationHint _tmp0_ = {0};
	guint _tmp1_ = 0U;
	GSignalQuery _tmp2_ = {0};
	GSignalQuery _tmp3_ = {0};
	GType _tmp4_ = 0UL;
	const gchar* _tmp5_ = NULL;
	GSignalQuery _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	guint i = 0U;
	GValue* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (hint != NULL, FALSE);
	_tmp0_ = *hint;
	_tmp1_ = _tmp0_.signal_id;
	g_signal_query (_tmp1_, &_tmp2_);
	query_info = _tmp2_;
	_tmp3_ = query_info;
	_tmp4_ = _tmp3_.itype;
	_tmp5_ = g_type_name (_tmp4_);
	_tmp6_ = query_info;
	_tmp7_ = _tmp6_.signal_name;
	folks_inspect_utils_print_line ("Signal '%s::%s' emitted with parameters:", _tmp5_, _tmp7_);
	folks_inspect_utils_indent ();
	i = (guint) 0;
	_tmp8_ = param_values;
	_tmp8__length1 = param_values_length1;
	{
		GValue* param_value_collection = NULL;
		gint param_value_collection_length1 = 0;
		gint _param_value_collection_size_ = 0;
		gint param_value_it = 0;
		param_value_collection = _tmp8_;
		param_value_collection_length1 = _tmp8__length1;
		for (param_value_it = 0; param_value_it < _tmp8__length1; param_value_it = param_value_it + 1) {
			GValue _tmp9_ = {0};
			GValue param_value = {0};
			if (G_IS_VALUE (&param_value_collection[param_value_it])) {
				g_value_init (&_tmp9_, G_VALUE_TYPE (&param_value_collection[param_value_it]));
				g_value_copy (&param_value_collection[param_value_it], &_tmp9_);
			} else {
				_tmp9_ = param_value_collection[param_value_it];
			}
			param_value = _tmp9_;
			{
				guint _tmp10_ = 0U;
				GType _tmp11_ = 0UL;
				const gchar* _tmp12_ = NULL;
				GValue _tmp13_ = {0};
				gchar* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				_tmp10_ = i;
				i = _tmp10_ + 1;
				_tmp11_ = G_VALUE_TYPE (&param_value);
				_tmp12_ = g_type_name (_tmp11_);
				_tmp13_ = param_value;
				_tmp14_ = folks_inspect_utils_transform_value_to_string (&_tmp13_);
				_tmp15_ = _tmp14_;
				folks_inspect_utils_print_line ("%-4u  %-10s  %s", _tmp10_, _tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				G_IS_VALUE (&param_value) ? (g_value_unset (&param_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
	result = TRUE;
	return result;
}


static gchar* folks_inspect_signal_manager_signal_flags_to_string (GSignalFlags flags) {
	gchar* result = NULL;
	gchar* output = NULL;
	gchar* _tmp0_ = NULL;
	GSignalFlags _tmp1_ = 0;
	GSignalFlags _tmp4_ = 0;
	GSignalFlags _tmp11_ = 0;
	GSignalFlags _tmp18_ = 0;
	GSignalFlags _tmp25_ = 0;
	GSignalFlags _tmp32_ = 0;
	_tmp0_ = g_strdup ("");
	output = _tmp0_;
	_tmp1_ = flags;
	if ((_tmp1_ & G_SIGNAL_RUN_FIRST) != 0) {
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		_tmp2_ = output;
		_tmp3_ = g_strconcat (_tmp2_, "G_SIGNAL_RUN_FIRST", NULL);
		_g_free0 (output);
		output = _tmp3_;
	}
	_tmp4_ = flags;
	if ((_tmp4_ & G_SIGNAL_RUN_LAST) != 0) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp6_ = output;
		if (g_strcmp0 (_tmp6_, "") != 0) {
			_tmp5_ = " | ";
		} else {
			_tmp5_ = "";
		}
		_tmp7_ = output;
		_tmp8_ = g_strconcat (_tmp5_, "G_SIGNAL_RUN_LAST", NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
		_g_free0 (output);
		output = _tmp10_;
		_g_free0 (_tmp9_);
	}
	_tmp11_ = flags;
	if ((_tmp11_ & G_SIGNAL_RUN_CLEANUP) != 0) {
		const gchar* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		_tmp13_ = output;
		if (g_strcmp0 (_tmp13_, "") != 0) {
			_tmp12_ = " | ";
		} else {
			_tmp12_ = "";
		}
		_tmp14_ = output;
		_tmp15_ = g_strconcat (_tmp12_, "G_SIGNAL_RUN_CLEANUP", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp14_, _tmp16_, NULL);
		_g_free0 (output);
		output = _tmp17_;
		_g_free0 (_tmp16_);
	}
	_tmp18_ = flags;
	if ((_tmp18_ & G_SIGNAL_DETAILED) != 0) {
		const gchar* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		gchar* _tmp24_ = NULL;
		_tmp20_ = output;
		if (g_strcmp0 (_tmp20_, "") != 0) {
			_tmp19_ = " | ";
		} else {
			_tmp19_ = "";
		}
		_tmp21_ = output;
		_tmp22_ = g_strconcat (_tmp19_, "G_SIGNAL_DETAILED", NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp21_, _tmp23_, NULL);
		_g_free0 (output);
		output = _tmp24_;
		_g_free0 (_tmp23_);
	}
	_tmp25_ = flags;
	if ((_tmp25_ & G_SIGNAL_ACTION) != 0) {
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		gchar* _tmp29_ = NULL;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		_tmp27_ = output;
		if (g_strcmp0 (_tmp27_, "") != 0) {
			_tmp26_ = " | ";
		} else {
			_tmp26_ = "";
		}
		_tmp28_ = output;
		_tmp29_ = g_strconcat (_tmp26_, "G_SIGNAL_ACTION", NULL);
		_tmp30_ = _tmp29_;
		_tmp31_ = g_strconcat (_tmp28_, _tmp30_, NULL);
		_g_free0 (output);
		output = _tmp31_;
		_g_free0 (_tmp30_);
	}
	_tmp32_ = flags;
	if ((_tmp32_ & G_SIGNAL_NO_HOOKS) != 0) {
		const gchar* _tmp33_ = NULL;
		const gchar* _tmp34_ = NULL;
		const gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		_tmp34_ = output;
		if (g_strcmp0 (_tmp34_, "") != 0) {
			_tmp33_ = " | ";
		} else {
			_tmp33_ = "";
		}
		_tmp35_ = output;
		_tmp36_ = g_strconcat (_tmp33_, "G_SIGNAL_NO_HOOKS", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = g_strconcat (_tmp35_, _tmp37_, NULL);
		_g_free0 (output);
		output = _tmp38_;
		_g_free0 (_tmp37_);
	}
	result = output;
	return result;
}


static void folks_inspect_signal_manager_class_init (FolksInspectSignalManagerClass * klass) {
	folks_inspect_signal_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksInspectSignalManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_signal_manager_finalize;
}


static void folks_inspect_signal_manager_instance_init (FolksInspectSignalManager * self) {
	self->priv = FOLKS_INSPECT_SIGNAL_MANAGER_GET_PRIVATE (self);
}


static void folks_inspect_signal_manager_finalize (GObject* obj) {
	FolksInspectSignalManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager);
	_g_object_unref0 (self->priv->signals_by_class_type);
	_g_object_unref0 (self->priv->signals_by_class_instance);
	G_OBJECT_CLASS (folks_inspect_signal_manager_parent_class)->finalize (obj);
}


GType folks_inspect_signal_manager_get_type (void) {
	static volatile gsize folks_inspect_signal_manager_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_signal_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectSignalManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_signal_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectSignalManager), 0, (GInstanceInitFunc) folks_inspect_signal_manager_instance_init, NULL };
		GType folks_inspect_signal_manager_type_id;
		folks_inspect_signal_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectSignalManager", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_signal_manager_type_id__volatile, folks_inspect_signal_manager_type_id);
	}
	return folks_inspect_signal_manager_type_id__volatile;
}



