/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JTextField;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;

public final class ChatPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(ChatPanel.class.getName());
    public static final int CHAT = 1;
    private final JTextField field;

    public ChatPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new BorderLayout(10, 10));
        JLabel label = Utility.localizedLabel("chatPanel.message");
        this.add((Component)label, "First");
        label.setFocusable(false);
        this.field = new JTextField("", 40);
        this.field.setActionCommand(String.valueOf(1));
        this.field.addActionListener(this);
        this.add((Component)this.field, "Center");
        this.field.setFocusable(true);
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ChatPanel.this.getGUI().removeComponent(ChatPanel.this);
            }
        });
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void requestFocus() {
        this.field.requestFocus();
    }

    public String getChatText() {
        String message = this.field.getText();
        this.field.setText("");
        return message;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        try {
            switch (Integer.parseInt(command)) {
                case 1: {
                    String message = this.getChatText();
                    if (!message.trim().equals("")) {
                        this.igc().chat(message);
                    }
                    this.getGUI().removeComponent(this);
                    break;
                }
                default: {
                    super.actionPerformed(ae);
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            logger.warning("Invalid ActionEvent, not a number: " + command);
        }
    }
}

