### v0.26.2
- Fixed overflow in texture scale calculation (bkoropoff)

### v0.26.1
- Fixed secret messages carrying over between levels
- Fixed locked door color in udmf
- Fixed blood color leaking into raised sprites
- Fixed ansi endoom crash
- Fixed textured automap not working if map started with textured mode off

### v0.26.0

This update brings beta udmf support, expanded line actions, zip file loading, level table progress tracking, text color and extended hud configuration, build mode refinements, new console commands, better opengl fuzz, indexed light mode fixes, improved heretic and hexen support, and much more. Check out all the changes in detail below.

#### UDMF (beta)
- Added support for UDMF
- Added support for the zdoom v1.33 namespace
- Added support for zdbsp nodes x/z gl n/2/3
- Highlights:
  - Mid texture wrapping and clipping
  - 3d mid textures (walking on fences)
  - Separate line flags for blocking projectiles and hitscan
  - Multi-tagging for sectors and lines
  - Texture and flat scaling
  - Flat rotation and offsets
  - Separate scale, offset, and light for top, mid, and bottom textures
  - Non-integer vertex positions
  - Sector gravity
  - Thing translucency, gravity, health, and secrets
- See the [doc](../docs/udmf.md) for comprehensive information

#### New Line Actions
- Stairs_BuildUpDoomCrush
- Floor_Stop
- Ceiling_Stop
- Floor_MoveToValueAndCrush
- Ceiling_MoveToValueAndCrush
- Line_SetAutomapFlags
- Line_SetAutomapStyle
- Sector_SetRotation
- Sector_SetCeilingScale
- Sector_SetFloorScale
- Sector_SetCeilingScale2
- Sector_SetFloorScale2
- Sector_ChangeFlags
- Line_SetTextureScale

#### Line Action Updates
- The following actions are now fully supported:
  - Scroll_Wall
  - Line_SetTextureOffset
  - Scroll_Texture_Left
  - Scroll_Texture_Right
  - Scroll_Texture_Up
  - Scroll_Texture_Down
  - Scroll_Texture_Offsets
  - Line_SetBlocking
- TranslucentLine now supports alpha values

#### Quality of Life
- Added `-bex` alias for `-deh`
- Added `-command X`
  - Executes one or more console commands on the first tic the player has control
  - Example: `-command "idclip; iddqd"` (start the game with noclip and god mode on)
- Added "organize failed demos" option
  - Puts failed demos in `dsda_doom_data/.../failed_demos/` (path based on wad)
- Added "Locked doors blink" automap option
- Added "announce map on entry" option
- Added zip file support for `-file` (FtZPetruska)
- Added support for the dome sky in indexed light mode
- Added `-game_speed <speed>` command line option
  - Game speed no longer persists between sessions
    - Replaced persistent `realtic_clock_rate` with transient `game_speed`
    - Associated keybindings and console commands work as before
- Added optional sfx for movement toggles
- The tntcomp cheat now accepts two digits for the complevel
  - It also rejects the unspecified complevels, 18-20
- Menus with font replacements now have correct vertical spacing
- Menus now scroll vertically if there is not enough room to fit the text

#### Level Table
- Added a level table (currently at the bottom of the options submenu)
- Added tracking for completion of individual levels
  - Kills, items, and secrets
  - Time, max time, and skill 5 time for pistol starts on each map
- Added wad stats summary page with overall completion statistics
- You can warp to maps from the level table

#### Text Color
- Migrated from fixed CR Table lumps to dynamic color ranges
- Added the DSDACR lump for color range configuration
  - See the [doc](../docs/color_range.md) for more information
- Wads with font replacements should have expected colors in the menus
  - There are exceptions for palettes with limited hues
- Adjusted some existing colors
- Added the DSDATC lump for text component color configuration
  - See the [doc](../docs/text_color.md) for more information

#### Wad Preferences
- Added DSDAPREF lump to define dsda-doom-specific preferences
  - Can add renderer preference (e.g., because software rendering tricks are used)
    - Will show an alert if the user is on a different renderer
  - More to come
- See the [doc](../docs/dsdapref.md) for more information

#### HUD
- Added ex hud scale and ratio options to control stretching
- Added minimap option (automap menu)
  - The location, size, and scale of the minimap can be edited in the hud config
- Migrated the automap layout to dsdahud.lmp
- Migrated message widgets to dsdahud.lmp
- Added arguments to some hud components
  - `stat_totals`: you can now configure which stats are displayed and the stat orientation
  - `weapon_text`: you can now toggle a grid configuration (bkoropoff)
  - `ammo_text`: you can now toggle the ammo names
  - `composite_time`: you can now toggle the "time" label
  - `speed_text`: you can now toggle the "speed" label
  - `keys`: you can now toggle a horizontal configuration
- Added new components:
  - `message`
  - `secret_message`
  - `map_totals`
  - `map_time`
  - `map_coordinates`
  - `map_title`
  - `minimap`
  - `color_test`
  - `free_text`
- Adjusted and added config options for automap component visibility
- The `big_health` component now shows the berserk kit when in berserk mode
- See the [hud doc](../docs/hud.md) for more details

#### Console
- Added `player.set_angle <angle>`
- Added `player.round_angle`
- Added `level.exit <position>`: exit to intermission screen
- Added `level.secret_exit <position>`: secret exit to intermission screen
- Added `demo.join`: join demo playback - same as key binding
- Added `game.quit`: quit immediately without a prompt
- Added `game.describe`: show the level, skill, and monster params
- Added `config.forget`: do not overwrite config file on exit
- Added `config.remember`: do overwrite config file on exit
- Added `wad_stats.forget`: do not update wad stats on exit
- Added `wad_stats.remember`: do update wad stats on exit
- Added `free_text.update`: update free text component
- Added `free_text.clear`: clear free text component
- `iddt` now works whether the automap is active or not

#### Tools
- Added `brute_force.frame / bf.frame <frame> <ranges> <buttons>` console command (specify frame-specific brute force ranges / buttons)
  - Use `brute_force.start / bf.start <depth> <conditions>` to run the frames
  - See the [build mode guide](../docs/build_mode.md) for more info.
- Increased brute force depth limit to 35 tics
- Added `-quit_after_brute_force` (quit the game automatically when brute force ends)
- Joining during recordfromto now adds the remaining playback buffer to the command queue
- Build mode now edits the previous command and updates the game state as the command changes
  - There are various small improvements to the workflow
  - There may be some edge case bugs; please report any unexpected behaviour

#### Heretic & Hexen Support
- Mouselook pitch is now translated to the mechanical look direction
  - Vertical look boundaries now match heretic and hexen
  - You aim where you are looking even when using the mouse
  - This currently does not work while recording because of demo format restrictions
    - This will be resolved in the future
- Look direction does not center on landing if using mouselook
- Fixed sky height and offsets in heretic and hexen
- Fixed the notarget cheat in heretic & hexen
- Fixed the fly cheat in heretic & hexen
- Fixed animated midtextures not working in heretic and hexen
- Fixed heretic pacifist tracking when hitting pods
- Fixed broken hexen music tracks (bkoropoff)
- Fixed an issue with heretic torch colormaps (bkoropoff)
- Fixed missing advisory patch on heretic title screen (fabiangreffrath)

#### Miscellaneous
- Revised TRANMAP handling
  - TRANMAPs are now stored inside dsda_doom_data/tranmaps
  - TRANMAPs are now indexed by PLAYPAL
- Removed comperr_zerotag setting
- Removed reduced view
- Removed the legacy screen sky mode
- Removed gldefs support
- Removed old light modes
- Removed hi-res support (not supported by either rendering mode)
- Removed `gl_tex_format_string` option (bkoropoff)
- Removed `gl_blend_animations` option
- Added `-chain_episodes` (e.g., e1m8 leads to e2m1)
  - This supports recording and playback
- The `idmypos` cheat now toggles the coordinate display
- Added demo file fallback in case the target file location is inaccessible
- Split extended hud text axis scaling options
- Turn 180 is now disabled in strict mode
- Adjusted raven automap colors
- Improved time to write first demo of a session when there are many demos present
- Updated to umapinfo rev 2.2 (author field)
- The `-file` argument can now locate all supported file types when omitting the extension
- Improved opengl fuzz style (bkoropoff)
- Improved performance in opengl (bkoropoff)
- Improved vram consumption in opengl (bkoropoff)

#### Bug Fixes
- Fixed a crash caused by png texture patches (they are now ignored)
- Fixed vertical look boundaries not properly resetting when changing video mode
- Fixed an issue with the nontextured overlay automap in indexed light mode
- Fixed an issue with the textured automap when scaling the window in opengl (bkoropoff)
- Fixed invuln colors leaking into the intermission screen in indexed light mode
- Fixed bright invuln fuzz in indexed light mode
- Fixed invuln colors affecting sky during nonzero palette in indexed light mode in cl 2
- Fixed an issue with sky textures in indexed light mode (bkoropoff)
- Fixed an issue with boom colormaps in indexed light mode (bkoropoff)
- Fixed chaingun with 0 ammo during fullclip
- Fixed some cheats working in strict mode
- Fixed `-1` out of range config values being set to `0` rather than the default
- Fixed hud flicker the first time changing zoom level
- Fixed extended hud message overlap caused by nonstandard font heights
- Fixed icon-spawned archvile resurrections affecting the stat totals
- Fixed overrun footer data carrying across demo attempts
- Fixed an overrun in a texture warning
- Fixed `0` counting as an unset time in split tracking
- Fixed a case where you could jump in midair (in casual play)
- Fixed issue with opengl melt screen (JadingTsunami)
- Fixed non-latin paths on windows (rfomin)
- Fixed an issue with music volume in portmidi (ceski)
- Fixed an issue with gl vbo memory (bkoropoff)
- Fixed an issue with 2D frustum calculation in opengl (bkoropoff)
- Fixed an issue that would sometimes cause disappearing walls in opengl (bkoropoff)
- Fixed an issue with weapon sprite coordinates in opengl (bkoropoff)
- Fixed hang on terminal interrupt on linux (bkoropoff)
- Fixed an issue with mid-level music changes in portmidi (ceski)
- Fixed a crash in blockmap generation (andrey-budko)

#### Development Environment
- Replaced `-devparm` with `-sigsegv` (disable SIGSEGV signal handler)
- Reduced default mapping error logs (use `-verbose` when testing)
- Fixed many warnings and potential future bugs (bkoropoff)
- Improved cmake configuration (FtZPetruska)
- Improved CI configuration (FtZPetruska)
- Added [windows build guide](../docs/guides/building_on_windows.md) (FtZPetruska)
- Fixed detection of dsda-doom.wad in the exe dir for portable non-windows builds (FtZPetruska)
- Fixed the dboolean type for C23 (FtZPetruska)
