/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.keyword;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.MessageSourceError;
import com.networknt.schema.Schema;
import com.networknt.schema.SchemaContext;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.keyword.BaseKeywordValidator;
import com.networknt.schema.keyword.KeywordType;
import com.networknt.schema.keyword.KeywordValidator;
import com.networknt.schema.path.NodePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RequiredValidator
extends BaseKeywordValidator
implements KeywordValidator {
    private final List<String> fieldNames;

    public RequiredValidator(SchemaLocation schemaLocation, JsonNode schemaNode, Schema parentSchema, SchemaContext schemaContext) {
        super(KeywordType.REQUIRED, schemaNode, schemaLocation, parentSchema, schemaContext);
        if (schemaNode.isArray()) {
            this.fieldNames = new ArrayList<String>(schemaNode.size());
            for (JsonNode fieldNme : schemaNode) {
                this.fieldNames.add(fieldNme.asText());
            }
        } else {
            this.fieldNames = Collections.emptyList();
        }
    }

    @Override
    public void validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, NodePath instanceLocation) {
        if (!node.isObject()) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            JsonNode writeOnlyNode;
            JsonNode readOnlyNode;
            JsonNode propertyNode = node.get(fieldName);
            if (propertyNode != null) continue;
            Boolean readOnly = executionContext.getExecutionConfig().getReadOnly();
            Boolean writeOnly = executionContext.getExecutionConfig().getWriteOnly();
            if (Boolean.TRUE.equals(readOnly) ? (readOnlyNode = this.getFieldKeyword(fieldName, "readOnly")) != null && readOnlyNode.booleanValue() : Boolean.TRUE.equals(writeOnly) && (writeOnlyNode = this.getFieldKeyword(fieldName, "writeOnly")) != null && writeOnlyNode.booleanValue()) continue;
            executionContext.addError(((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)((MessageSourceError.Builder)this.error().instanceNode(node)).property(fieldName)).instanceLocation(instanceLocation)).evaluationPath(executionContext.getEvaluationPath())).locale(executionContext.getExecutionConfig().getLocale())).arguments(fieldName)).build());
        }
    }

    protected JsonNode getFieldKeyword(String fieldName, String keyword) {
        JsonNode fieldNode;
        JsonNode propertiesNode = this.parentSchema.getSchemaNode().get("properties");
        if (propertiesNode != null && (fieldNode = propertiesNode.get(fieldName)) != null) {
            return fieldNode.get(keyword);
        }
        return null;
    }
}

