/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) | (~ ivec3(-36, 32, -88))) => ivec3(-1, -1, -1)
 * (ivec3(-36, 32, -88) | (~ ivec3(36, 32, 88))) => ivec3(-33, -1, -81)
 * (ivec3(-36, 32, -88) | (~ ivec3(59, 77, 68))) => ivec3(-36, -78, -69)
 * (ivec3(36, 32, 88) | (~ ivec3(-36, 32, -88))) => ivec3(39, -1, 95)
 * (ivec3(36, 32, 88) | (~ ivec3(36, 32, 88))) => ivec3(-1, -1, -1)
 * (ivec3(36, 32, 88) | (~ ivec3(59, 77, 68))) => ivec3(-28, -78, -5)
 * (ivec3(59, 77, 68) | (~ ivec3(-36, 32, -88))) => ivec3(59, -33, 87)
 * (ivec3(59, 77, 68) | (~ ivec3(36, 32, 88))) => ivec3(-5, -33, -25)
 * (ivec3(59, 77, 68) | (~ ivec3(59, 77, 68))) => ivec3(-1, -1, -1)
 */
#version 130

void main()
{
  float[all(equal((ivec3(-36, 32, -88) | (~ ivec3(-36, 32, -88))), ivec3(-1, -1, -1))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) | (~ ivec3(36, 32, 88))), ivec3(-33, -1, -81))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) | (~ ivec3(59, 77, 68))), ivec3(-36, -78, -69))) ? 1 : -1] array2;
  float[all(equal((ivec3(36, 32, 88) | (~ ivec3(-36, 32, -88))), ivec3(39, -1, 95))) ? 1 : -1] array3;
  float[all(equal((ivec3(36, 32, 88) | (~ ivec3(36, 32, 88))), ivec3(-1, -1, -1))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) | (~ ivec3(59, 77, 68))), ivec3(-28, -78, -5))) ? 1 : -1] array5;
  float[all(equal((ivec3(59, 77, 68) | (~ ivec3(-36, 32, -88))), ivec3(59, -33, 87))) ? 1 : -1] array6;
  float[all(equal((ivec3(59, 77, 68) | (~ ivec3(36, 32, 88))), ivec3(-5, -33, -25))) ? 1 : -1] array7;
  float[all(equal((ivec3(59, 77, 68) | (~ ivec3(59, 77, 68))), ivec3(-1, -1, -1))) ? 1 : -1] array8;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
