/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.memorycontainer;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.ml.common.memorycontainer.MLMemoryContainer;
import org.opensearch.ml.common.memorycontainer.MemoryConfiguration;
import org.opensearch.ml.common.memorycontainer.MemoryStrategy;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.memorycontainer.memory.MLUpdateMemoryContainerRequest;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.helper.MemoryContainerHelper;
import org.opensearch.ml.helper.MemoryContainerModelValidator;
import org.opensearch.ml.helper.MemoryContainerPipelineHelper;
import org.opensearch.ml.helper.MemoryContainerSharedIndexValidator;
import org.opensearch.ml.helper.StrategyMergeHelper;
import org.opensearch.ml.model.MLModelManager;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class TransportUpdateMemoryContainerAction
extends HandledTransportAction<ActionRequest, UpdateResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(TransportUpdateMemoryContainerAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final NamedXContentRegistry xContentRegistry;
    private final ConnectorAccessControlHelper connectorAccessControlHelper;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLModelManager mlModelManager;
    private final MemoryContainerHelper memoryContainerHelper;
    private final MLIndicesHandler mlIndicesHandler;

    @Inject
    public TransportUpdateMemoryContainerAction(TransportService transportService, ActionFilters actionFilters, Client client, SdkClient sdkClient, NamedXContentRegistry xContentRegistry, ConnectorAccessControlHelper connectorAccessControlHelper, MLFeatureEnabledSetting mlFeatureEnabledSetting, MLModelManager mlModelManager, MemoryContainerHelper memoryContainerHelper, MLIndicesHandler mlIndicesHandler) {
        super("cluster:admin/opensearch/ml/memory_containers/update", transportService, actionFilters, MLUpdateMemoryContainerRequest::new);
        this.client = client;
        this.sdkClient = sdkClient;
        this.xContentRegistry = xContentRegistry;
        this.connectorAccessControlHelper = connectorAccessControlHelper;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.mlModelManager = mlModelManager;
        this.memoryContainerHelper = memoryContainerHelper;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<UpdateResponse> actionListener) {
        if (!this.mlFeatureEnabledSetting.isAgenticMemoryEnabled()) {
            actionListener.onFailure((Exception)new OpenSearchStatusException(MLCommonsSettings.ML_COMMONS_AGENTIC_MEMORY_DISABLED_MESSAGE, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        MLUpdateMemoryContainerRequest mlUpdateMemoryContainerRequest = MLUpdateMemoryContainerRequest.fromActionRequest((ActionRequest)request);
        String memoryContainerId = mlUpdateMemoryContainerRequest.getMemoryContainerId();
        String newName = mlUpdateMemoryContainerRequest.getMlUpdateMemoryContainerInput().getName();
        String newDescription = mlUpdateMemoryContainerRequest.getMlUpdateMemoryContainerInput().getDescription();
        List allowedBackendRoles = mlUpdateMemoryContainerRequest.getMlUpdateMemoryContainerInput().getBackendRoles();
        MemoryConfiguration updateConfiguration = mlUpdateMemoryContainerRequest.getMlUpdateMemoryContainerInput().getConfiguration();
        this.memoryContainerHelper.getMemoryContainer(memoryContainerId, (ActionListener<MLMemoryContainer>)ActionListener.wrap(container -> {
            User user = RestActionUtils.getUserContext(this.client);
            if (!this.memoryContainerHelper.checkMemoryContainerAccess(user, (MLMemoryContainer)container)) {
                actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have permissions to update memories in this container", RestStatus.FORBIDDEN, new Object[0]));
                return;
            }
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            if (newName != null) {
                updateFields.put("name", newName);
            }
            if (newDescription != null) {
                updateFields.put("description", newDescription);
            }
            if (allowedBackendRoles != null) {
                updateFields.put("backend_roles", allowedBackendRoles);
            }
            if (updateConfiguration != null) {
                try {
                    boolean nowHasStrategies;
                    MemoryConfiguration finalUpdateConfig;
                    boolean hadNoStrategies;
                    MemoryConfiguration currentConfig = container.getConfiguration();
                    this.validateEmbeddingUpdate(currentConfig, updateConfiguration);
                    boolean bl = hadNoStrategies = currentConfig.getStrategies() == null || currentConfig.getStrategies().isEmpty();
                    if (updateConfiguration.getStrategies() != null && !updateConfiguration.getStrategies().isEmpty()) {
                        List<MemoryStrategy> mergedStrategies = StrategyMergeHelper.mergeStrategies(currentConfig.getStrategies(), updateConfiguration.getStrategies());
                        finalUpdateConfig = MemoryConfiguration.builder().llmId(updateConfiguration.getLlmId()).maxInferSize(updateConfiguration.getMaxInferSize()).strategies(mergedStrategies).embeddingModelId(updateConfiguration.getEmbeddingModelId()).embeddingModelType(updateConfiguration.getEmbeddingModelType()).dimension(updateConfiguration.getDimension()).build();
                    } else {
                        finalUpdateConfig = updateConfiguration;
                    }
                    currentConfig.update(finalUpdateConfig);
                    currentConfig.validate();
                    MemoryConfiguration.validateStrategiesRequireModels((MemoryConfiguration)currentConfig);
                    boolean bl2 = nowHasStrategies = currentConfig.getStrategies() != null && !currentConfig.getStrategies().isEmpty();
                    if (hadNoStrategies && nowHasStrategies) {
                        this.validateAndCreateIndices((MLMemoryContainer)container, currentConfig, (Map<String, Object>)updateFields, memoryContainerId, actionListener);
                        return;
                    }
                    updateFields.put("configuration", currentConfig);
                }
                catch (Exception e) {
                    log.error("Failed to update configuration for container {}", (Object)memoryContainerId, (Object)e);
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                    return;
                }
            }
            updateFields.put("last_updated_time", Instant.now().toEpochMilli());
            this.performUpdate(".plugins-ml-am-memory-container", memoryContainerId, updateFields, actionListener);
        }, e -> {
            log.error("Failed to get memory container for update", (Throwable)e);
            actionListener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private void validateEmbeddingUpdate(MemoryConfiguration currentConfig, MemoryConfiguration updateConfig) {
        boolean updateHasEmbedding;
        if (currentConfig.getStrategies() == null || currentConfig.getStrategies().isEmpty()) {
            log.debug("Container has no strategies - allowing embedding configuration update");
            return;
        }
        boolean currentHasEmbedding = currentConfig.getEmbeddingModelId() != null;
        boolean bl = updateHasEmbedding = updateConfig.getEmbeddingModelId() != null || updateConfig.getEmbeddingModelType() != null || updateConfig.getDimension() != null;
        if (currentHasEmbedding && updateHasEmbedding) {
            boolean dimensionChanged;
            boolean idChanged = updateConfig.getEmbeddingModelId() != null && !updateConfig.getEmbeddingModelId().equals(currentConfig.getEmbeddingModelId());
            boolean typeChanged = updateConfig.getEmbeddingModelType() != null && !updateConfig.getEmbeddingModelType().equals((Object)currentConfig.getEmbeddingModelType());
            boolean bl2 = dimensionChanged = updateConfig.getDimension() != null && !updateConfig.getDimension().equals(currentConfig.getDimension());
            if (idChanged || typeChanged || dimensionChanged) {
                throw new IllegalArgumentException("Cannot change embedding configuration once strategies are configured. The long-term memory index already exists with specific embedding mappings. Current: {embedding_model_id=" + currentConfig.getEmbeddingModelId() + ", embedding_model_type=" + String.valueOf(currentConfig.getEmbeddingModelType()) + ", dimension=" + currentConfig.getDimension() + "}. Create a new memory container if you need different embedding configuration.");
            }
        }
    }

    private void performUpdate(String indexName, String memoryContainerId, Map<String, Object> updateFields, ActionListener<UpdateResponse> listener) {
        UpdateRequest updateRequest = new UpdateRequest(indexName, memoryContainerId).doc(updateFields);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.update(updateRequest, ActionListener.runBefore(listener, () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e) {
            log.error("Failed to update memory container {}", (Object)memoryContainerId, (Object)e);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }
    }

    private void validateAndCreateIndices(MLMemoryContainer container, MemoryConfiguration config, Map<String, Object> updateFields, String memoryContainerId, ActionListener<UpdateResponse> listener) {
        MemoryContainerModelValidator.validateLlmModel(config.getLlmId(), this.mlModelManager, this.client, (ActionListener<Boolean>)ActionListener.wrap(llmValid -> MemoryContainerModelValidator.validateEmbeddingModel(config.getEmbeddingModelId(), config.getEmbeddingModelType(), this.mlModelManager, this.client, (ActionListener<Boolean>)ActionListener.wrap(embeddingValid -> this.validateSharedIndexAndCreateIndices(container, config, updateFields, memoryContainerId, listener), arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void validateSharedIndexAndCreateIndices(MLMemoryContainer container, MemoryConfiguration config, Map<String, Object> updateFields, String memoryContainerId, ActionListener<UpdateResponse> listener) {
        String longTermIndexName = config.getLongMemoryIndexName();
        MemoryContainerSharedIndexValidator.validateSharedIndexCompatibility(config, longTermIndexName, this.client, (ActionListener<MemoryContainerSharedIndexValidator.ValidationResult>)ActionListener.wrap(result -> {
            if (result.isIndexExists() && result.isCompatible()) {
                this.createHistoryIndexOnly(config, updateFields, memoryContainerId, listener);
            } else if (!result.isIndexExists()) {
                this.createLongTermAndHistoryIndices(container, config, updateFields, memoryContainerId, listener);
            } else {
                listener.onFailure((Exception)new IllegalStateException("Unexpected validation state: index exists but compatibility is false"));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void createHistoryIndexOnly(MemoryConfiguration config, Map<String, Object> updateFields, String memoryContainerId, ActionListener<UpdateResponse> listener) {
        if (!config.isDisableHistory()) {
            String historyIndexName = config.getLongMemoryHistoryIndexName();
            this.mlIndicesHandler.createLongTermMemoryHistoryIndex(historyIndexName, config, ActionListener.wrap(success -> {
                updateFields.put("configuration", config);
                updateFields.put("last_updated_time", Instant.now().toEpochMilli());
                this.performUpdate(".plugins-ml-am-memory-container", memoryContainerId, updateFields, listener);
            }, e -> {
                log.error("Failed to create history index '{}'", (Object)historyIndexName, e);
                listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            }));
        } else {
            updateFields.put("configuration", config);
            updateFields.put("last_updated_time", Instant.now().toEpochMilli());
            this.performUpdate(".plugins-ml-am-memory-container", memoryContainerId, updateFields, listener);
        }
    }

    private void createLongTermAndHistoryIndices(MLMemoryContainer container, MemoryConfiguration config, Map<String, Object> updateFields, String memoryContainerId, ActionListener<UpdateResponse> listener) {
        String longTermIndexName = config.getLongMemoryIndexName();
        String historyIndexName = config.getLongMemoryHistoryIndexName();
        this.createLongTermMemoryIngestPipeline(longTermIndexName, config, (ActionListener<Boolean>)ActionListener.wrap(success -> {
            if (!config.isDisableHistory()) {
                this.mlIndicesHandler.createLongTermMemoryHistoryIndex(historyIndexName, config, ActionListener.wrap(historySuccess -> {
                    updateFields.put("configuration", config);
                    updateFields.put("last_updated_time", Instant.now().toEpochMilli());
                    this.performUpdate(".plugins-ml-am-memory-container", memoryContainerId, updateFields, listener);
                }, e -> {
                    log.error("Failed to create history index '{}'", (Object)historyIndexName, e);
                    listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
                }));
            } else {
                updateFields.put("configuration", config);
                updateFields.put("last_updated_time", Instant.now().toEpochMilli());
                this.performUpdate(".plugins-ml-am-memory-container", memoryContainerId, updateFields, listener);
            }
        }, e -> {
            log.error("Failed to create long-term index '{}'", (Object)longTermIndexName, e);
            listener.onFailure((Exception)new OpenSearchStatusException("Internal server error", RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
        }));
    }

    private void createLongTermMemoryIngestPipeline(String indexName, MemoryConfiguration config, ActionListener<Boolean> listener) {
        MemoryContainerPipelineHelper.createLongTermMemoryIngestPipeline(indexName, config, this.mlIndicesHandler, this.client, listener);
    }
}

