/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.RSAPaddingMode;

public class RSADecryptInput {
    private final RSAPaddingMode padding;
    private final ByteBuffer privateKey;
    private final ByteBuffer cipherText;

    protected RSADecryptInput(BuilderImpl builder) {
        this.padding = builder.padding();
        this.privateKey = builder.privateKey();
        this.cipherText = builder.cipherText();
    }

    public RSAPaddingMode padding() {
        return this.padding;
    }

    public ByteBuffer privateKey() {
        return this.privateKey;
    }

    public ByteBuffer cipherText() {
        return this.cipherText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected RSAPaddingMode padding;
        protected ByteBuffer privateKey;
        protected ByteBuffer cipherText;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RSADecryptInput model) {
            this.padding = model.padding();
            this.privateKey = model.privateKey();
            this.cipherText = model.cipherText();
        }

        @Override
        public Builder padding(RSAPaddingMode padding) {
            this.padding = padding;
            return this;
        }

        @Override
        public RSAPaddingMode padding() {
            return this.padding;
        }

        @Override
        public Builder privateKey(ByteBuffer privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        @Override
        public ByteBuffer privateKey() {
            return this.privateKey;
        }

        @Override
        public Builder cipherText(ByteBuffer cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        @Override
        public ByteBuffer cipherText() {
            return this.cipherText;
        }

        @Override
        public RSADecryptInput build() {
            if (Objects.isNull((Object)this.padding())) {
                throw new IllegalArgumentException("Missing value for required field `padding`");
            }
            if (Objects.isNull(this.privateKey())) {
                throw new IllegalArgumentException("Missing value for required field `privateKey`");
            }
            if (Objects.isNull(this.cipherText())) {
                throw new IllegalArgumentException("Missing value for required field `cipherText`");
            }
            return new RSADecryptInput(this);
        }
    }

    public static interface Builder {
        public Builder padding(RSAPaddingMode var1);

        public RSAPaddingMode padding();

        public Builder privateKey(ByteBuffer var1);

        public ByteBuffer privateKey();

        public Builder cipherText(ByteBuffer var1);

        public ByteBuffer cipherText();

        public RSADecryptInput build();
    }
}

