/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.items;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.items.Metadata;
import org.openhab.core.items.MetadataKey;
import org.openhab.core.items.MetadataProvider;
import org.openhab.core.model.yaml.YamlModelUtils;
import org.openhab.core.model.yaml.internal.items.YamlMetadataDTO;
import org.openhab.core.model.yaml.internal.util.YamlElementUtils;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={MetadataProvider.class, YamlMetadataProvider.class})
public class YamlMetadataProvider
extends AbstractProvider<Metadata>
implements MetadataProvider {
    private final Logger logger = LoggerFactory.getLogger(YamlMetadataProvider.class);
    private Map<String, Map<String, Map<String, Metadata>>> metadataMap = new ConcurrentHashMap<String, Map<String, Map<String, Metadata>>>();

    public Collection<Metadata> getAll() {
        return this.metadataMap.keySet().stream().filter(name -> !YamlModelUtils.isIsolatedModel(name)).map(name -> this.metadataMap.getOrDefault(name, Map.of())).flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).toList();
    }

    public Collection<Metadata> getAllFromModel(String modelName) {
        return this.metadataMap.getOrDefault(modelName, Map.of()).values().stream().flatMap(m -> m.values().stream()).toList();
    }

    public void updateMetadata(String modelName, String itemName, Map<String, YamlMetadataDTO> metadata) {
        Map itemsMetadataMap = Objects.requireNonNull(this.metadataMap.computeIfAbsent(modelName, k -> new ConcurrentHashMap()));
        Map namespacesMetadataMap = Objects.requireNonNull(itemsMetadataMap.computeIfAbsent(itemName, k -> new ConcurrentHashMap()));
        HashSet namespaceToBeRemoved = new HashSet(namespacesMetadataMap.keySet());
        for (Map.Entry<String, YamlMetadataDTO> entry : metadata.entrySet()) {
            String namespace2 = entry.getKey();
            YamlMetadataDTO mdDTO = entry.getValue();
            MetadataKey key = new MetadataKey(namespace2, itemName);
            Metadata md = new Metadata(key, mdDTO.value == null ? "" : mdDTO.value, mdDTO.config);
            namespaceToBeRemoved.remove(namespace2);
            Metadata oldMd = (Metadata)namespacesMetadataMap.get(namespace2);
            if (oldMd == null) {
                namespacesMetadataMap.put(namespace2, md);
                this.logger.debug("model {} added metadata {}", (Object)modelName, (Object)namespace2);
                if (YamlModelUtils.isIsolatedModel(modelName)) continue;
                this.notifyListenersAboutAddedElement(md);
                continue;
            }
            if (md.getValue().equals(oldMd.getValue()) && YamlElementUtils.equalsConfig(md.getConfiguration(), oldMd.getConfiguration())) continue;
            namespacesMetadataMap.put(namespace2, md);
            this.logger.debug("model {} updated metadata {}", (Object)modelName, (Object)namespace2);
            if (YamlModelUtils.isIsolatedModel(modelName)) continue;
            this.notifyListenersAboutUpdatedElement(oldMd, md);
        }
        namespaceToBeRemoved.forEach(namespace -> {
            Metadata md = (Metadata)namespacesMetadataMap.remove(namespace);
            if (md != null) {
                this.logger.debug("model {} removed metadata {}", (Object)modelName, namespace);
                if (!YamlModelUtils.isIsolatedModel(modelName)) {
                    this.notifyListenersAboutRemovedElement(md);
                }
            }
        });
        if (namespacesMetadataMap.isEmpty()) {
            itemsMetadataMap.remove(itemName);
        }
        if (itemsMetadataMap.isEmpty()) {
            this.metadataMap.remove(modelName);
        }
    }
}

