/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.transport.modbus.internal;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.wimpi.modbus.ModbusException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.io.transport.modbus.internal.ModbusManagerImpl;

@NonNullByDefault
public class SimpleStopWatch {
    private volatile long totalMillis;
    private volatile long resumed;

    public synchronized void resume() {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot suspend a running StopWatch");
        }
        this.resumed = System.currentTimeMillis();
    }

    public synchronized void suspend() {
        if (!this.isRunning()) {
            throw new IllegalStateException("Cannot suspend non-running StopWatch");
        }
        this.totalMillis += System.currentTimeMillis() - this.resumed;
        this.resumed = 0L;
    }

    public synchronized long getTotalTimeMillis() {
        return this.totalMillis;
    }

    public synchronized boolean isRunning() {
        return this.resumed > 0L;
    }

    public <R> R timeSupplierWithPollTaskUnregisteredException(SupplierWithPollTaskUnregisteredException<R> supplier) throws ModbusManagerImpl.PollTaskUnregistered {
        try {
            this.resume();
            R r = supplier.get();
            return r;
        }
        finally {
            this.suspend();
        }
    }

    public <R> R timeSupplier(Supplier<R> supplier) {
        try {
            this.resume();
            R r = supplier.get();
            return r;
        }
        finally {
            this.suspend();
        }
    }

    public void timeRunnableWithModbusException(RunnableWithModbusException action) throws ModbusException {
        try {
            this.resume();
            action.run();
        }
        finally {
            this.suspend();
        }
    }

    public void timeRunnable(Runnable runnable) {
        try {
            this.resume();
            runnable.run();
        }
        finally {
            this.suspend();
        }
    }

    public <T> void timeConsumer(Consumer<T> consumer, T parameter) {
        try {
            this.resume();
            consumer.accept(parameter);
        }
        finally {
            this.suspend();
        }
    }

    @FunctionalInterface
    public static interface RunnableWithModbusException {
        public void run() throws ModbusException;
    }

    @FunctionalInterface
    public static interface SupplierWithPollTaskUnregisteredException<T> {
        public T get() throws ModbusManagerImpl.PollTaskUnregistered;
    }
}

