/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public abstract class ActionWithTempFile {
    private File myTempFile;
    private final File mySourceFile;
    @NonNls
    private static final String TMP_PREFIX = "vcs";
    @NonNls
    private static final String TMP_SUFFIX = "tmp";

    public ActionWithTempFile(File sourceFile) {
        this.mySourceFile = sourceFile;
    }

    public void execute() throws VcsException {
        try {
            try {
                this.init();
                this.executeInternal();
            }
            finally {
                this.rollbackChanges();
            }
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private void init() throws IOException {
        this.myTempFile = FileUtil.createTempFile((String)TMP_PREFIX, (String)TMP_SUFFIX);
        FileUtil.delete((File)this.myTempFile);
        FileUtil.rename((File)this.mySourceFile, (File)this.myTempFile);
    }

    protected abstract void executeInternal() throws VcsException;

    private void rollbackChanges() throws IOException {
        try {
            FileUtil.delete((File)this.mySourceFile);
        }
        finally {
            try {
                FileUtil.rename((File)this.myTempFile, (File)this.mySourceFile);
            }
            finally {
                FileUtil.delete((File)this.myTempFile);
            }
        }
    }
}

