/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.webTypes.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.intellij.polySymbols.webTypes.json.CanonicalNames;
import com.intellij.polySymbols.webTypes.json.MatchNames;
import com.intellij.polySymbols.webTypes.json.NameVariants;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"canonical-names", "match-names", "name-variants"})
public class ReferenceNameConversion {
    @JsonProperty(value="canonical-names")
    @JsonPropertyDescription(value="Override global canonical name conversion rule against which comparisons are made for the referenced symbols. When only rule name is specified, it applies to the symbols of the same kind as the last segment of the referenced path. Otherwise format of the property names is '{namespace}/{symbol kind}'. Supported by JetBrains IDEs since 2022.1.")
    private CanonicalNames canonicalNames;
    @JsonProperty(value="match-names")
    @JsonPropertyDescription(value="Override global rules, by which referenced symbols should be matched against their canonical names. When only rule names are specified, they applies to the symbols of the same kind as the last segment of the referenced path. Otherwise format of the property names is '{namespace}/{symbol kind}'. Supported by JetBrains IDEs since 2022.1.")
    private MatchNames matchNames;
    @JsonProperty(value="name-variants")
    @JsonPropertyDescription(value="Override global rules, by which referenced symbol names should be proposed in auto completion. When only rule names are specified, they applies to the symbols of the same kind as the last segment of the referenced path. Otherwise format of the property names is '{namespace}/{symbol kind}'. Supported by JetBrains IDEs since 2022.1.")
    private NameVariants nameVariants;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="canonical-names")
    public CanonicalNames getCanonicalNames() {
        return this.canonicalNames;
    }

    @JsonProperty(value="canonical-names")
    public void setCanonicalNames(CanonicalNames canonicalNames) {
        this.canonicalNames = canonicalNames;
    }

    @JsonProperty(value="match-names")
    public MatchNames getMatchNames() {
        return this.matchNames;
    }

    @JsonProperty(value="match-names")
    public void setMatchNames(MatchNames matchNames) {
        this.matchNames = matchNames;
    }

    @JsonProperty(value="name-variants")
    public NameVariants getNameVariants() {
        return this.nameVariants;
    }

    @JsonProperty(value="name-variants")
    public void setNameVariants(NameVariants nameVariants) {
        this.nameVariants = nameVariants;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }
}

