/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.Map;
import org.gradle.api.internal.artifacts.transform.AbstractTransformExecution;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.internal.artifacts.transform.TransformDependencies;
import org.gradle.api.internal.artifacts.transform.TransformExecutionListener;
import org.gradle.api.internal.artifacts.transform.TransformStepSubject;
import org.gradle.api.internal.artifacts.transform.TransformWorkspaceIdentity;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.MutableUnitOfWork;
import org.gradle.internal.execution.UnitOfWork;
import org.gradle.internal.execution.workspace.MutableWorkspaceProvider;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.BuildOperationRunner;
import org.gradle.internal.snapshot.ValueSnapshot;

class MutableTransformExecution
extends AbstractTransformExecution
implements MutableUnitOfWork {
    private final String rootProjectLocation;
    private final String producerBuildTreePath;
    private final MutableWorkspaceProvider workspaceProvider;

    public MutableTransformExecution(Transform transform, File inputArtifact, TransformDependencies dependencies, TransformStepSubject subject, ProjectInternal producerProject, TransformExecutionListener transformExecutionListener, BuildOperationRunner buildOperationRunner, BuildOperationProgressEventEmitter progressEventEmitter, FileCollectionFactory fileCollectionFactory, InputFingerprinter inputFingerprinter, MutableWorkspaceProvider workspaceProvider, boolean disableCachingByProperty) {
        super(transform, inputArtifact, dependencies, subject, transformExecutionListener, buildOperationRunner, progressEventEmitter, fileCollectionFactory, inputFingerprinter, disableCachingByProperty);
        this.rootProjectLocation = producerProject.getRootDir().getAbsolutePath() + File.separator;
        this.producerBuildTreePath = producerProject.getBuildTreePath();
        this.workspaceProvider = workspaceProvider;
    }

    public MutableWorkspaceProvider getWorkspaceProvider() {
        return this.workspaceProvider;
    }

    @Override
    protected TransformWorkspaceIdentity createIdentity(Map<String, ValueSnapshot> identityInputs, Map<String, CurrentFileCollectionFingerprint> identityFileInputs) {
        return TransformWorkspaceIdentity.createMutable(this.normalizeAbsolutePath(this.inputArtifact.getAbsolutePath()), this.producerBuildTreePath, identityInputs.get("inputPropertiesHash"), identityFileInputs.get("inputArtifactDependencies").getHash());
    }

    public void visitRegularInputs(UnitOfWork.InputVisitor visitor) {
        this.visitInputArtifact(visitor);
    }

    private String normalizeAbsolutePath(String path) {
        if (path.startsWith(this.rootProjectLocation)) {
            return path.substring(this.rootProjectLocation.length());
        }
        return path;
    }
}

