/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.DataLossException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.storage.Crc32cValue;
import com.google.common.hash.Hashing;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.logging.Logger;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ParametersAreNonnullByDefault
interface Hasher {
    default public @Nullable Crc32cValue.Crc32cLengthKnown hash(Supplier<ByteBuffer> b) {
        return this.hash(b.get());
    }

    public @Nullable Crc32cValue.Crc32cLengthKnown hash(ByteBuffer var1);

    public @Nullable Crc32cValue.Crc32cLengthKnown hash(ByteString var1);

    public void validate(Crc32cValue<?> var1, Supplier<ByteBuffer> var2) throws ChecksumMismatchException;

    public void validate(Crc32cValue<?> var1, ByteString var2) throws ChecksumMismatchException;

    public void validateUnchecked(Crc32cValue<?> var1, ByteString var2) throws UncheckedChecksumMismatchException;

    public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(@Nullable Crc32cValue.Crc32cLengthKnown var1, @NonNull Crc32cValue.Crc32cLengthKnown var2);

    public @Nullable Crc32cValue.Crc32cLengthKnown initialValue();

    public static NoOpHasher noop() {
        return NoOpHasher.INSTANCE;
    }

    public static GuavaHasher enabled() {
        return GuavaHasher.INSTANCE;
    }

    public static Hasher defaultHasher() {
        return DefaultInstanceHolder.DEFAULT_HASHER;
    }

    @Immutable
    public static class NoOpHasher
    implements Hasher {
        private static final NoOpHasher INSTANCE = new NoOpHasher();

        private NoOpHasher() {
        }

        @Override
        public Crc32cValue.Crc32cLengthKnown hash(ByteBuffer b) {
            return null;
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown hash(ByteString byteString) {
            return null;
        }

        @Override
        public void validate(Crc32cValue<?> expected, Supplier<ByteBuffer> b) {
        }

        @Override
        public void validate(Crc32cValue<?> expected, ByteString b) {
        }

        @Override
        public void validateUnchecked(Crc32cValue<?> expected, ByteString byteString) {
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(@Nullable Crc32cValue.Crc32cLengthKnown r1, @NonNull Crc32cValue.Crc32cLengthKnown r2) {
            return null;
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown initialValue() {
            return null;
        }
    }

    @Immutable
    public static class GuavaHasher
    implements Hasher {
        private static final GuavaHasher INSTANCE = new GuavaHasher();

        private GuavaHasher() {
        }

        @Override
        public @NonNull Crc32cValue.Crc32cLengthKnown hash(Supplier<ByteBuffer> b) {
            return this.hash(b.get());
        }

        @Override
        public @NonNull Crc32cValue.Crc32cLengthKnown hash(ByteBuffer b) {
            int remaining = b.remaining();
            return Crc32cValue.of(Hashing.crc32c().hashBytes(b).asInt(), remaining);
        }

        @Override
        public @NonNull Crc32cValue.Crc32cLengthKnown hash(ByteString byteString) {
            List buffers = byteString.asReadOnlyByteBufferList();
            com.google.common.hash.Hasher crc32c = Hashing.crc32c().newHasher();
            for (ByteBuffer b : buffers) {
                crc32c.putBytes(b);
            }
            return Crc32cValue.of(crc32c.hash().asInt(), byteString.size());
        }

        @Override
        public void validate(Crc32cValue<?> expected, ByteString byteString) throws ChecksumMismatchException {
            Crc32cValue.Crc32cLengthKnown actual = this.hash(byteString);
            if (!actual.eqValue(expected)) {
                throw new ChecksumMismatchException(expected, actual);
            }
        }

        @Override
        public void validate(Crc32cValue<?> expected, Supplier<ByteBuffer> b) throws ChecksumMismatchException {
            @NonNull Crc32cValue.Crc32cLengthKnown actual = this.hash(b);
            if (!actual.eqValue(expected)) {
                throw new ChecksumMismatchException(expected, actual);
            }
        }

        @Override
        public void validateUnchecked(Crc32cValue<?> expected, ByteString byteString) throws UncheckedChecksumMismatchException {
            Crc32cValue.Crc32cLengthKnown actual = this.hash(byteString);
            if (!actual.eqValue(expected)) {
                throw new UncheckedChecksumMismatchException(expected, actual);
            }
        }

        @Override
        public @Nullable Crc32cValue.Crc32cLengthKnown nullSafeConcat(@Nullable Crc32cValue.Crc32cLengthKnown r1, @NonNull Crc32cValue.Crc32cLengthKnown r2) {
            if (r1 == null) {
                return null;
            }
            return r1.concat(r2);
        }

        @Override
        public @NonNull Crc32cValue.Crc32cLengthKnown initialValue() {
            return Crc32cValue.zero();
        }
    }

    public static final class DefaultInstanceHolder {
        private static final Logger LOGGER = Logger.getLogger(Hasher.class.getName());
        private static final String PROPERTY_NAME = "com.google.cloud.storage.Hasher.default";
        private static final String PROPERTY_VALUE = System.getProperty("com.google.cloud.storage.Hasher.default", "enabled");
        static final Hasher DEFAULT_HASHER;

        static {
            LOGGER.fine(String.format(Locale.US, "-D%s=%s", PROPERTY_NAME, PROPERTY_VALUE));
            if ("disabled".equalsIgnoreCase(PROPERTY_VALUE)) {
                DEFAULT_HASHER = Hasher.noop();
            } else {
                try {
                    Class.forName("java.util.zip.CRC32C");
                }
                catch (ClassNotFoundException e) {
                    LOGGER.fine("Fast CRC32C implementation (Java 9+) is not available.");
                }
                DEFAULT_HASHER = Hasher.enabled();
            }
        }
    }

    public static final class UncheckedChecksumMismatchException
    extends DataLossException {
        private static final GrpcStatusCode STATUS_CODE = GrpcStatusCode.of((Status.Code)Status.Code.DATA_LOSS);
        private final Crc32cValue<?> expected;
        private final Crc32cValue.Crc32cLengthKnown actual;

        private UncheckedChecksumMismatchException(Crc32cValue<?> expected, Crc32cValue.Crc32cLengthKnown actual) {
            super(String.format("Mismatch checksum value. Expected %s actual %s", expected.debugString(), actual.debugString()), null, (StatusCode)STATUS_CODE, false);
            this.expected = expected;
            this.actual = actual;
        }

        Crc32cValue<?> getExpected() {
            return this.expected;
        }

        Crc32cValue.Crc32cLengthKnown getActual() {
            return this.actual;
        }
    }

    public static final class ChecksumMismatchException
    extends IOException {
        private final Crc32cValue<?> expected;
        private final Crc32cValue.Crc32cLengthKnown actual;

        private ChecksumMismatchException(Crc32cValue<?> expected, Crc32cValue.Crc32cLengthKnown actual) {
            super(String.format(Locale.US, "Mismatch checksum value. Expected %s actual %s", expected.debugString(), actual.debugString()));
            this.expected = expected;
            this.actual = actual;
        }

        Crc32cValue<?> getExpected() {
            return this.expected;
        }

        Crc32cValue<?> getActual() {
            return this.actual;
        }
    }
}

