
lib = File.expand_path("../lib", __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)
require "puppetserver/ca/version"

Gem::Specification.new do |spec|
  spec.name          = "openvoxserver-ca"
  spec.version       = Puppetserver::Ca::VERSION
  spec.authors       = ["OpenVox Project"]
  spec.email         = ["openvox@voxpupuli.org"]
  spec.license       = "Apache-2.0"

  spec.summary       = %q{A simple CLI tool for interacting with OpenVox Server's Certificate Authority}
  spec.homepage      = "https://github.com/OpenVoxProject/openvoxserver-ca/"

  spec.files         = `git ls-files -z`.split("\x0").reject do |f|
    f.match(%r{^(test|spec|features)/})
  end
  spec.bindir        = "exe"
  spec.executables   = spec.files.grep(%r{^exe/}) { |f| File.basename(f) }
  spec.require_paths = ["lib"]

  spec.add_runtime_dependency "openfact", [">= 5.0.0", "< 6"]

  spec.add_development_dependency "bundler", ">= 1.16"
  spec.add_development_dependency "rake", ">= 12.3.3"
  spec.add_development_dependency "rspec", "~> 3.0"

  # openvoxserver 7 uses jruby 9.3 which is compatible with MRI ruby 2.6
  spec.required_ruby_version = '>= 2.6.0'
end
