"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WLM_GROUP_ID_PARAM = exports.WLM_CONFIG = exports.VALIDATION_LIMITS = exports.TYPE = exports.TOTAL_SHARDS = exports.TOP_N_DISPLAY_LIMIT = exports.TIME_UNIT_ABBREVIATION = exports.TIME_UNITS_TEXT = exports.TIME_UNIT = exports.TIMESTAMP = exports.SEARCH_TYPE = exports.REFRESH_INTERVAL_OPTIONS = exports.QUERY_COUNT = exports.NODE_ID = exports.MetricType = exports.MINUTES_OPTIONS = exports.METRIC_TYPES_TEXT = exports.MEMORY_USAGE = exports.LATENCY = exports.INDICES = exports.ID = exports.GROUP_BY_OPTIONS = exports.GROUP_BY = exports.EXPORTER_TYPES_LIST = exports.EXPORTER_TYPE = exports.DEFAULT_WINDOW_SIZE = exports.DEFAULT_TOP_N_SIZE = exports.DEFAULT_TIME_UNIT = exports.DEFAULT_SHOW_LIVE_QUERIES_ON_ERROR = exports.DEFAULT_REFRESH_INTERVAL = exports.DEFAULT_METRIC_ENABLED = exports.DEFAULT_GROUP_BY = exports.DEFAULT_EXPORTER_TYPE = exports.DEFAULT_DELETE_AFTER_DAYS = exports.CPU_TIME = exports.CHART_COLORS = exports.AVERAGE_MEMORY_USAGE = exports.AVERAGE_LATENCY = exports.AVERAGE_CPU_TIME = exports.ALL_WORKLOAD_GROUPS_TEXT = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const TIMESTAMP = exports.TIMESTAMP = 'Timestamp';
const TYPE = exports.TYPE = 'Type';
const ID = exports.ID = 'Id';
const QUERY_COUNT = exports.QUERY_COUNT = 'Query Count';
const LATENCY = exports.LATENCY = 'Latency';
const CPU_TIME = exports.CPU_TIME = 'CPU Time';
const MEMORY_USAGE = exports.MEMORY_USAGE = 'Memory Usage';
const INDICES = exports.INDICES = 'Indices';
const SEARCH_TYPE = exports.SEARCH_TYPE = 'Search Type';
const NODE_ID = exports.NODE_ID = 'Coordinator Node ID';
const TOTAL_SHARDS = exports.TOTAL_SHARDS = 'Total Shards';
const GROUP_BY = exports.GROUP_BY = 'Group by';
const AVERAGE_LATENCY = exports.AVERAGE_LATENCY = 'Average Latency';
const AVERAGE_CPU_TIME = exports.AVERAGE_CPU_TIME = 'Average CPU Time';
const AVERAGE_MEMORY_USAGE = exports.AVERAGE_MEMORY_USAGE = 'Average Memory Usage';
const MetricType = exports.MetricType = {
  LATENCY: 'latency',
  CPU: 'cpu',
  MEMORY: 'memory'
};
const METRIC_TYPES_TEXT = exports.METRIC_TYPES_TEXT = [{
  value: MetricType.LATENCY,
  text: 'Latency'
}, {
  value: MetricType.CPU,
  text: 'CPU'
}, {
  value: MetricType.MEMORY,
  text: 'Memory'
}];
const TIME_UNITS_TEXT = exports.TIME_UNITS_TEXT = [{
  value: 'MINUTES',
  text: 'Minute(s)'
}, {
  value: 'HOURS',
  text: 'Hour(s)'
}];
const MINUTES_OPTIONS = exports.MINUTES_OPTIONS = [{
  value: '1',
  text: '1'
}, {
  value: '5',
  text: '5'
}, {
  value: '10',
  text: '10'
}, {
  value: '30',
  text: '30'
}];
const GROUP_BY_OPTIONS = exports.GROUP_BY_OPTIONS = [{
  value: 'none',
  text: 'None'
}, {
  value: 'similarity',
  text: 'Similarity'
}];
const TIME_UNIT = exports.TIME_UNIT = {
  MINUTES: 'MINUTES',
  HOURS: 'HOURS'
};
const TIME_UNIT_ABBREVIATION = exports.TIME_UNIT_ABBREVIATION = {
  MINUTES: 'm',
  HOURS: 'h'
};
const EXPORTER_TYPE = exports.EXPORTER_TYPE = {
  localIndex: 'local_index',
  none: 'none'
};
const EXPORTER_TYPES_LIST = exports.EXPORTER_TYPES_LIST = [{
  value: EXPORTER_TYPE.localIndex,
  text: 'Local Index'
}, {
  value: EXPORTER_TYPE.none,
  text: 'None'
}];
const DEFAULT_METRIC_ENABLED = exports.DEFAULT_METRIC_ENABLED = true;
const DEFAULT_TOP_N_SIZE = exports.DEFAULT_TOP_N_SIZE = '10';
const DEFAULT_WINDOW_SIZE = exports.DEFAULT_WINDOW_SIZE = '5';
const DEFAULT_TIME_UNIT = exports.DEFAULT_TIME_UNIT = TIME_UNIT.MINUTES;
const DEFAULT_GROUP_BY = exports.DEFAULT_GROUP_BY = 'none';
const DEFAULT_EXPORTER_TYPE = exports.DEFAULT_EXPORTER_TYPE = EXPORTER_TYPE.localIndex;
const DEFAULT_DELETE_AFTER_DAYS = exports.DEFAULT_DELETE_AFTER_DAYS = '7';
const DEFAULT_REFRESH_INTERVAL = exports.DEFAULT_REFRESH_INTERVAL = 30000; // default 30s
const TOP_N_DISPLAY_LIMIT = exports.TOP_N_DISPLAY_LIMIT = 9;
const DEFAULT_SHOW_LIVE_QUERIES_ON_ERROR = exports.DEFAULT_SHOW_LIVE_QUERIES_ON_ERROR = false;
const WLM_GROUP_ID_PARAM = exports.WLM_GROUP_ID_PARAM = 'wlmGroupId';
const ALL_WORKLOAD_GROUPS_TEXT = exports.ALL_WORKLOAD_GROUPS_TEXT = 'All workload groups';
const CHART_COLORS = exports.CHART_COLORS = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728', '#9467bd', '#8c564b', '#e377c2', '#7f7f7f', '#bcbd22', '#17becf'];
const REFRESH_INTERVAL_OPTIONS = exports.REFRESH_INTERVAL_OPTIONS = [{
  value: '5000',
  text: '5 seconds'
}, {
  value: '10000',
  text: '10 seconds'
}, {
  value: '30000',
  text: '30 seconds'
}, {
  value: '60000',
  text: '1 minute'
}];

// Validation constants
const VALIDATION_LIMITS = exports.VALIDATION_LIMITS = {
  TOP_N_SIZE: {
    MIN: 1,
    MAX: 100
  },
  WINDOW_SIZE_HOURS: {
    MIN: 1,
    MAX: 24
  },
  DELETE_AFTER_DAYS: {
    MIN: 1,
    MAX: 180
  }
};
const DEFAULT_CONFIG = {
  wlm: {
    enabled: true
  }
};
const WLM_CONFIG = exports.WLM_CONFIG = Object.freeze({
  ...DEFAULT_CONFIG.wlm
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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