"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setIndexCache = exports.getIndexCache = exports.getAllIndexCache = exports.clearIndexCache = exports.clearAllIndexCache = exports.IndexCacheData = void 0;
var _crypto = require("crypto");
var _cache_util = require("../utils/cache_util");
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          * Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                                                                                                                          */
const indexCacheSize = 1000;

// Cache to store the data for checking the index is log-related or not.
class IndexCacheData {
  static generateCacheKey(indexName, dataSourceId) {
    const combinedString = `${dataSourceId}-${indexName}`;
    return (0, _crypto.createHash)('sha256').update(combinedString).digest('hex');
  }
  constructor(isLogRelated, reason) {
    _defineProperty(this, "isLogRelated", void 0);
    _defineProperty(this, "reason", void 0);
    this.isLogRelated = isLogRelated;
    this.reason = reason;
  }
}

// Create an instance of LRUCache for IndexCacheData.
exports.IndexCacheData = IndexCacheData;
const indexLRUCache = new _cache_util.LRUCache(indexCacheSize);
const getIndexCache = (indexName, dataSourceId) => {
  return indexLRUCache.getCache(IndexCacheData.generateCacheKey(indexName, dataSourceId));
};
exports.getIndexCache = getIndexCache;
const setIndexCache = (data, indexName, dataSourceId) => {
  return indexLRUCache.setCache(IndexCacheData.generateCacheKey(indexName, dataSourceId), data);
};
exports.setIndexCache = setIndexCache;
const getAllIndexCache = () => {
  return indexLRUCache.getAllCache();
};
exports.getAllIndexCache = getAllIndexCache;
const clearIndexCache = (indexName, dataSourceId) => {
  return indexLRUCache.clearCache(IndexCacheData.generateCacheKey(indexName, dataSourceId));
};
exports.clearIndexCache = clearIndexCache;
const clearAllIndexCache = () => {
  return indexLRUCache.clearAllCache();
};
exports.clearAllIndexCache = clearAllIndexCache;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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