/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.actions;

import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventPublisher;
import org.openhab.core.items.GroupItem;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemNotFoundException;
import org.openhab.core.items.ItemRegistry;
import org.openhab.core.items.events.ItemEventFactory;
import org.openhab.core.model.script.ScriptServiceUtil;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;
import org.openhab.core.types.TimeSeries;
import org.openhab.core.types.TypeParser;
import org.slf4j.LoggerFactory;

public class BusEvent {
    public static Object sendCommand(Item item, String commandString) {
        if (item != null) {
            return BusEvent.sendCommand(item.getName(), commandString);
        }
        return null;
    }

    public static Object sendCommand(Item item, Number number) {
        if (item != null && number != null) {
            return BusEvent.sendCommand(item.getName(), number.toString());
        }
        return null;
    }

    public static Object sendCommand(String itemName, String commandString) {
        ItemRegistry registry = ScriptServiceUtil.getItemRegistry();
        EventPublisher publisher = ScriptServiceUtil.getEventPublisher();
        if (publisher != null && registry != null) {
            try {
                Item item = registry.getItem(itemName);
                Command command = TypeParser.parseCommand((List)item.getAcceptedCommandTypes(), (String)commandString);
                if (command != null) {
                    publisher.post((Event)ItemEventFactory.createCommandEvent((String)itemName, (Command)command));
                } else {
                    LoggerFactory.getLogger(BusEvent.class).warn("Cannot convert '{}' to a command type which item '{}' accepts: {}.", new Object[]{commandString, itemName, BusEvent.getAcceptedCommandNames(item)});
                }
            }
            catch (ItemNotFoundException e) {
                LoggerFactory.getLogger(BusEvent.class).warn("Item '{}' does not exist.", (Object)itemName);
            }
        }
        return null;
    }

    private static <T extends State> List<String> getAcceptedCommandNames(Item item) {
        return item.getAcceptedCommandTypes().stream().map(Class::getSimpleName).toList();
    }

    public static Object sendCommand(Item item, Command command) {
        EventPublisher publisher = ScriptServiceUtil.getEventPublisher();
        if (publisher != null && item != null) {
            publisher.post((Event)ItemEventFactory.createCommandEvent((String)item.getName(), (Command)command));
        }
        return null;
    }

    public static Object postUpdate(Item item, Number state) {
        if (item != null && state != null) {
            return BusEvent.postUpdate(item.getName(), state.toString());
        }
        return null;
    }

    public static Object postUpdate(Item item, String stateAsString) {
        if (item != null) {
            return BusEvent.postUpdate(item.getName(), stateAsString);
        }
        return null;
    }

    public static Object postUpdate(String itemName, String stateString) {
        ItemRegistry registry = ScriptServiceUtil.getItemRegistry();
        EventPublisher publisher = ScriptServiceUtil.getEventPublisher();
        if (publisher != null && registry != null) {
            try {
                Item item = registry.getItem(itemName);
                State state = TypeParser.parseState((List)item.getAcceptedDataTypes(), (String)stateString);
                if (state != null) {
                    publisher.post((Event)ItemEventFactory.createStateEvent((String)itemName, (State)state));
                } else {
                    LoggerFactory.getLogger(BusEvent.class).warn("Cannot convert '{}' to a state type which item '{}' accepts: {}.", new Object[]{stateString, itemName, BusEvent.getAcceptedDataTypeNames(item)});
                }
            }
            catch (ItemNotFoundException e) {
                LoggerFactory.getLogger(BusEvent.class).warn("Item '{}' does not exist.", (Object)itemName);
            }
        }
        return null;
    }

    public static Object sendTimeSeries(@Nullable Item item, @Nullable TimeSeries timeSeries) {
        EventPublisher eventPublisher1 = ScriptServiceUtil.getEventPublisher();
        if (eventPublisher1 != null && item != null && timeSeries != null) {
            eventPublisher1.post((Event)ItemEventFactory.createTimeSeriesEvent((String)item.getName(), (TimeSeries)timeSeries, null));
        }
        return null;
    }

    public static Object sendTimeSeries(@Nullable String itemName, @Nullable Map<ZonedDateTime, State> values, String policy) {
        EventPublisher eventPublisher1 = ScriptServiceUtil.getEventPublisher();
        if (eventPublisher1 != null && itemName != null && values != null && policy != null) {
            try {
                TimeSeries timeSeries = new TimeSeries(TimeSeries.Policy.valueOf((String)policy));
                values.forEach((key, value) -> timeSeries.add(key.toInstant(), value));
                eventPublisher1.post((Event)ItemEventFactory.createTimeSeriesEvent((String)itemName, (TimeSeries)timeSeries, null));
            }
            catch (IllegalArgumentException e) {
                LoggerFactory.getLogger(BusEvent.class).warn("Policy '{}' does not exist.", (Object)policy);
            }
        }
        return null;
    }

    private static <T extends State> List<String> getAcceptedDataTypeNames(Item item) {
        return item.getAcceptedDataTypes().stream().map(Class::getSimpleName).toList();
    }

    public static Object postUpdate(Item item, State state) {
        EventPublisher publisher = ScriptServiceUtil.getEventPublisher();
        if (publisher != null && item != null) {
            publisher.post((Event)ItemEventFactory.createStateEvent((String)item.getName(), (State)state));
        }
        return null;
    }

    public static Map<Item, State> storeStates(Item ... items) {
        HashMap<Item, State> statesMap = new HashMap<Item, State>();
        if (items != null) {
            Item[] itemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Item item = itemArray[n2];
                if (item instanceof GroupItem) {
                    GroupItem groupItem = (GroupItem)item;
                    for (Item member : groupItem.getAllMembers()) {
                        statesMap.put(member, member.getState());
                    }
                } else {
                    statesMap.put(item, item.getState());
                }
                ++n2;
            }
        }
        return statesMap;
    }

    public static Object restoreStates(Map<Item, State> statesMap) {
        if (statesMap != null) {
            for (Map.Entry<Item, State> entry : statesMap.entrySet()) {
                if (entry.getValue() instanceof Command) {
                    BusEvent.sendCommand(entry.getKey(), (Command)entry.getValue());
                    continue;
                }
                BusEvent.postUpdate(entry.getKey(), entry.getValue());
            }
        }
        return null;
    }
}

