/*
 * Decompiled with CFR 0.152.
 */
package lucee.loader.engine;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lucee.loader.util.Util;
import lucee.runtime.exp.PageException;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.xml.sax.SAXException;

public final class BundleProvider {
    public static final int CONNECTION_TIMEOUT = 10000;
    private static final long MAX_AGE = 10000L;
    private static URL[] DEFAULT_PROVIDER_DETAILSX = null;
    private static URL DEFAULT_PROVIDER_DETAIL_MVN = null;
    private static URL[] defaultProviderDetail;
    private static URL defaultProviderDetailMvn;
    private static Map<String, Info[]> mappings;
    private URL[] details;
    private static Map<String, Pair> readers;

    private static void put(Map<String, Info[]> mappings, String name, Info ... value) {
        if (mappings.containsKey(name)) {
            throw new RuntimeException(name + " already set");
        }
        mappings.put(name, value);
    }

    public static Map getMappings() {
        return mappings;
    }

    private static URL[] getDefaultProviderDetail() {
        if (defaultProviderDetail == null) {
            String str = BundleProvider.getSystemPropOrEnvVar("lucee.s3.bundle.detail", null);
            if (!Util.isEmpty(str, true)) {
                try {
                    defaultProviderDetail = new URL[]{new URL(str.trim())};
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (defaultProviderDetail == null) {
                defaultProviderDetail = DEFAULT_PROVIDER_DETAILSX;
            }
        }
        return defaultProviderDetail;
    }

    private static URL getDefaultProviderDetailMvn() {
        if (defaultProviderDetailMvn == null) {
            String str = BundleProvider.getSystemPropOrEnvVar("lucee.mvn.bundle.detail", null);
            if (!Util.isEmpty(str, true)) {
                try {
                    defaultProviderDetailMvn = new URL(str.trim());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (defaultProviderDetailMvn == null) {
                defaultProviderDetailMvn = DEFAULT_PROVIDER_DETAIL_MVN;
            }
        }
        return defaultProviderDetailMvn;
    }

    private BundleProvider(URL[] details) throws MalformedURLException {
        for (int i = 0; i < details.length; ++i) {
            if (details[i].toExternalForm().endsWith("/")) continue;
            details[i] = new URL(details[i].toExternalForm() + "/");
        }
        this.details = details;
    }

    public static BundleProvider getInstance() throws MalformedURLException {
        return BundleProvider.getInstance(BundleProvider.getDefaultProviderDetail());
    }

    public static BundleProvider getInstance(URL[] details) throws MalformedURLException {
        String key = BundleProvider.toKey(details);
        Pair pair = readers.get(key);
        if (pair != null && pair.lastModified + 10000L > System.currentTimeMillis()) {
            return pair.bundleProvider;
        }
        BundleProvider reader = new BundleProvider(details);
        readers.put(key, new Pair(System.currentTimeMillis(), reader));
        return reader;
    }

    private static String toKey(URL[] details) {
        StringBuilder sb = new StringBuilder();
        for (URL d : details) {
            sb.append(';').append(d.toExternalForm());
        }
        return sb.toString();
    }

    public URL getBundleAsURL(String bundleName, String bundleVersion) throws PageException, IOException, GeneralSecurityException, SAXException, BundleException {
        BundleDefinition bd = new BundleDefinition(bundleName, bundleVersion);
        URL url = null;
        Info[] infos = mappings.get(bd.name);
        if (infos != null && infos.length > 0) {
            Info[] infoArray = infos;
            int n = infoArray.length;
            for (int i = 0; i < n; ++i) {
                Info info = infoArray[i];
                if (!info.isMaven()) continue;
                String v = bd.getVersionAsString();
                url = BundleProvider.validate(BundleProvider.createURL(BundleProvider.getDefaultProviderDetailMvn(), info, v), null);
                if (url != null) {
                    return url;
                }
                if (v == null || !v.endsWith(".0")) continue;
                v = v.substring(0, v.length() - 2);
                url = BundleProvider.validate(BundleProvider.createURL(BundleProvider.getDefaultProviderDetailMvn(), info, v), null);
                if (url == null) continue;
                return url;
            }
        } else {
            int index = bd.name.lastIndexOf(46);
            String last = index == -1 ? bd.name : bd.name.substring(index + 1);
            url = BundleProvider.validate(new URL(BundleProvider.getDefaultProviderDetailMvn(), bd.name.replace('.', '/') + "/" + bd.version + "/" + last + "-" + bd.version + ".jar"), null);
            if (url != null) {
                return url;
            }
        }
        for (URL detail : this.details) {
            url = BundleProvider.validate(new URL(detail, bd.name + "-" + bd.version + ".jar"), null);
            if (url == null) continue;
            return url;
        }
        throw new IOException("no URL found for bundle [" + bd.name + ":" + bd.version + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL validate(URL url, URL defaultValue) {
        HttpURLConnection conn = null;
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("HEAD");
            conn.setConnectTimeout(10000);
            conn.connect();
            int code = conn.getResponseCode();
            if (code >= 200 && code < 300) {
                URL uRL = url;
                return uRL;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return defaultValue;
    }

    private static URL createURL(URL base, Info info, String version) throws MalformedURLException {
        return new URL(base, info.groupId.replace('.', '/') + "/" + info.artifactId + "/" + version + "/" + info.artifactId + "-" + version + ".jar");
    }

    private static String getSystemPropOrEnvVar(String string, Object object) {
        return null;
    }

    private static Version toVersion(String version, Version defaultValue) {
        String qualifier;
        Integer micro;
        Integer minor;
        Integer major;
        String[] arr;
        if (Util.isEmpty(version)) {
            return defaultValue;
        }
        try {
            arr = version.split("\\.");
        }
        catch (Exception e) {
            return defaultValue;
        }
        if (arr.length == 1) {
            major = Integer.parseInt(arr[0]);
            minor = 0;
            micro = 0;
            qualifier = null;
        } else if (arr.length == 2) {
            major = Integer.parseInt(arr[0]);
            minor = Integer.parseInt(arr[1]);
            micro = 0;
            qualifier = null;
        } else if (arr.length == 3) {
            major = Integer.parseInt(arr[0]);
            minor = Integer.parseInt(arr[1]);
            micro = Integer.parseInt(arr[2]);
            qualifier = null;
        } else {
            major = Integer.parseInt(arr[0]);
            minor = Integer.parseInt(arr[1]);
            micro = Integer.parseInt(arr[2]);
            qualifier = arr[3];
        }
        if (major == null || minor == null || micro == null) {
            return defaultValue;
        }
        if (qualifier == null) {
            return new Version(major, minor, micro);
        }
        return new Version(major, minor, micro, qualifier);
    }

    private static Version toVersion(String version) throws BundleException {
        Version v = BundleProvider.toVersion(version, null);
        if (v != null) {
            return v;
        }
        throw new BundleException("Given version [" + version + "] is invalid, a valid version is following this pattern <major-number>.<minor-number>.<micro-number>[.<qualifier>]");
    }

    static {
        mappings = new ConcurrentHashMap<String, Info[]>();
        readers = new HashMap<String, Pair>();
        try {
            DEFAULT_PROVIDER_DETAILSX = new URL[]{new URL("https://bundle-download.s3.amazonaws.com/")};
            DEFAULT_PROVIDER_DETAIL_MVN = new URL("https://repo1.maven.org/maven2/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        BundleProvider.put(mappings, "apache.http.components.client", new Info("org.apache.httpcomponents", "httpclient"));
        BundleProvider.put(mappings, "apache.http.components.core", new Info("org.apache.httpcomponents", "httpcore"));
        BundleProvider.put(mappings, "apache.http.components.mime", new Info("org.apache.httpcomponents", "httpmime"));
        BundleProvider.put(mappings, "com.amazonaws.aws-java-sdk-osgi", new Info("com.amazonaws", "aws-java-sdk-osgi"));
        BundleProvider.put(mappings, "com.amazonaws.aws.java.sdk.support", new Info("com.amazonaws", "aws-java-sdk-support"));
        BundleProvider.put(mappings, "com.google.gson", new Info("com.google.code.gson", "gson"));
        BundleProvider.put(mappings, "com.launchdarkly.client", new Info("commons-codec", "commons-codec"));
        BundleProvider.put(mappings, "ehcache", new Info("net.sf.ehcache", "ehcache-core"));
        BundleProvider.put(mappings, "ESAPI", new Info("org.owasp.esapi", "esapi"));
        BundleProvider.put(mappings, "activiti-osgi", new Info("org.activiti", "activiti-osgi"));
        BundleProvider.put(mappings, "avalon.framework.api", new Info("org.apache.avalon", "avalon-framework", "1"));
        BundleProvider.put(mappings, "com.fasterxml.classmate", new Info("com.fasterxml", "classmate", "1.3.0"));
        BundleProvider.put(mappings, "com.fasterxml.jackson.core.jackson-annotations", new Info("com.fasterxml.jackson.core", "jackson-annotations"));
        BundleProvider.put(mappings, "com.fasterxml.jackson.core.jackson-core", new Info("com.fasterxml.jackson.core", "jackson-core"));
        BundleProvider.put(mappings, "com.fasterxml.jackson.core.jackson-databind", new Info("com.fasterxml.jackson.core", "jackson-databind"));
        BundleProvider.put(mappings, "com.fasterxml.jackson.dataformat.jackson-dataformat-cbor", new Info("com.fasterxml.jackson.dataformat", "jackson-dataformat-cbor"));
        BundleProvider.put(mappings, "com.github.kirviq.dumbster", new Info("com.github.kirviq", "dumbster"));
        BundleProvider.put(mappings, "com.google.guava", new Info("com.google.guava", "guava"));
        BundleProvider.put(mappings, "com.google.guava.failureaccess", new Info("com.google.guava", "failureaccess"));
        BundleProvider.put(mappings, "com.google.protobuf", new Info("com.google.protobuf", "protobuf-java"));
        BundleProvider.put(mappings, "com.googlecode.json-simple", new Info("com.googlecode.json-simple", "json-simple"));
        BundleProvider.put(mappings, "com.googlecode.owasp-java-html-sanitizer", new Info("com.googlecode.owasp-java-html-sanitizer", "owasp-java-html-sanitizer"));
        BundleProvider.put(mappings, "com.microsoft.sqlserver.mssql-jdbc", new Info("com.microsoft.sqlserver", "mssql-jdbc"));
        BundleProvider.put(mappings, "antlr", new Info("antlr", "antlr"));
        BundleProvider.put(mappings, "apache.lucene.analyzers", new Info[0]);
        BundleProvider.put(mappings, "apache.lucene.analyzers.common", new Info[0]);
        BundleProvider.put(mappings, "apache.lucene.core", new Info[0]);
        BundleProvider.put(mappings, "apache.lucene.facet", new Info[0]);
        BundleProvider.put(mappings, "apache.lucene.queries", new Info[0]);
        BundleProvider.put(mappings, "apache.lucene.queryparser", new Info[0]);
        BundleProvider.put(mappings, "apache.poi", new Info[0]);
        BundleProvider.put(mappings, "apache.poi.ooxml", new Info[0]);
        BundleProvider.put(mappings, "apache.poi.ooxml.schemas", new Info[0]);
        BundleProvider.put(mappings, "apache.poi.tm.extractors", new Info[0]);
        BundleProvider.put(mappings, "apache.ws.axis", new Info[0]);
        BundleProvider.put(mappings, "apache.ws.axis.ant", new Info[0]);
        BundleProvider.put(mappings, "apache.xml.xalan", new Info[0]);
        BundleProvider.put(mappings, "apache.xml.xalan.serializer", new Info[0]);
        BundleProvider.put(mappings, "apache.xml.xerces", new Info[0]);
        BundleProvider.put(mappings, "backport.util.concurrent", new Info[0]);
        BundleProvider.put(mappings, "bcprov", new Info[0]);
        BundleProvider.put(mappings, "bcprov.jdk14", new Info[0]);
        BundleProvider.put(mappings, "bouncycastle.mail", new Info[0]);
        BundleProvider.put(mappings, "bouncycastle.prov", new Info[0]);
        BundleProvider.put(mappings, "bouncycastle.tsp", new Info[0]);
        BundleProvider.put(mappings, "chart.extension", new Info[0]);
        BundleProvider.put(mappings, "checker-qual", new Info("org.checkerframework", "checker-qual"));
        BundleProvider.put(mappings, "com.mysql.cj", new Info("com.mysql", "mysql-connector-j"), new Info("mysql", "mysql-connector-java"));
        BundleProvider.put(mappings, "com.mysql.jdbc", new Info("mysql", "mysql-connector-java"));
        BundleProvider.put(mappings, "com.naryx.tagfusion.cfx", new Info[0]);
        BundleProvider.put(mappings, "com.sun.jna", new Info("net.java.dev.jna", "jna"));
        BundleProvider.put(mappings, "com.teradata.jdbc", new Info[0]);
        BundleProvider.put(mappings, "com.teradata.tdgss", new Info[0]);
        BundleProvider.put(mappings, "compress.extension", new Info[0]);
        BundleProvider.put(mappings, "concurrent", new Info[0]);
        BundleProvider.put(mappings, "distrokid.extension", new Info[0]);
        BundleProvider.put(mappings, "ehcache.extension", new Info[0]);
        BundleProvider.put(mappings, "esapi.extension", new Info[0]);
        BundleProvider.put(mappings, "findbugsAnnotations", new Info("com.google.code.findbugs", "annotations"));
        BundleProvider.put(mappings, "flex.messaging.common", new Info[0]);
        BundleProvider.put(mappings, "flex.messaging.core", new Info[0]);
        BundleProvider.put(mappings, "flex.messaging.opt", new Info[0]);
        BundleProvider.put(mappings, "flex.messaging.proxy", new Info[0]);
        BundleProvider.put(mappings, "flex.messaging.remoting", new Info[0]);
        BundleProvider.put(mappings, "flying.saucer.core", new Info("org.xhtmlrenderer", "flying-saucer-core"));
        BundleProvider.put(mappings, "flying.saucer.pdf", new Info("org.xhtmlrenderer", "flying-saucer-pdf"));
        BundleProvider.put(mappings, "fonts", new Info[0]);
        BundleProvider.put(mappings, "form.extension", new Info[0]);
        BundleProvider.put(mappings, "fusiondebug.api.server", new Info("com.intergral.fusiondebug", "fusiondebug-api-server"));
        BundleProvider.put(mappings, "hibernate", new Info("org.hibernate", "hibernate-core"));
        BundleProvider.put(mappings, "hibernate.extension", new Info[0]);
        BundleProvider.put(mappings, "hsqldb", new Info[0]);
        BundleProvider.put(mappings, "hypersonic.hsqldb", new Info[0]);
        BundleProvider.put(mappings, "icepdf.core", new Info[0]);
        BundleProvider.put(mappings, "ieffects", new Info[0]);
        BundleProvider.put(mappings, "image.extension", new Info[0]);
        BundleProvider.put(mappings, "jackson-core-asl", new Info("org.codehaus.jackson", "jackson-core-asl"));
        BundleProvider.put(mappings, "jackson-mapper-asl", new Info("org.codehaus.jackson", "jackson-mapper-asl"));
        BundleProvider.put(mappings, "jacob", new Info[0]);
        BundleProvider.put(mappings, "jandex", new Info("org.jboss", "jandex"));
        BundleProvider.put(mappings, "java.xmlbuilder", new Info("com.jamesmurty.utils", "java-xmlbuilder"));
        BundleProvider.put(mappings, "javaparser", new Info[0]);
        BundleProvider.put(mappings, "javassist", new Info("org.javassist", "javassist"));
        BundleProvider.put(mappings, "javasysmon", new Info[0]);
        BundleProvider.put(mappings, "javax.activation", new Info[0]);
        BundleProvider.put(mappings, "javax.el", new Info[0]);
        BundleProvider.put(mappings, "javax.mail", new Info("javax.mail", "mail"));
        BundleProvider.put(mappings, "javax.mail-api", new Info("javax.mail", "javax.mail-api"));
        BundleProvider.put(mappings, "javax.mail.activation", new Info("javax.mail", "mail"));
        BundleProvider.put(mappings, "javax.servlet.jsp-api", new Info("javax.servlet.jsp", "javax.servlet.jsp-api"));
        BundleProvider.put(mappings, "javax.websocket-api", new Info("javax.websocket", "javax.websocket-api"));
        BundleProvider.put(mappings, "jaxb-api", new Info("javax.xml.bind", "jaxb-api"));
        BundleProvider.put(mappings, "jboss.logging.annotations", new Info("org.jboss.logging", "jboss-logging-annotations"));
        BundleProvider.put(mappings, "jboss.transaction", new Info("org.jboss.spec.javax.transaction", "jboss-transaction-api_1.2_spec"));
        BundleProvider.put(mappings, "jcifs", new Info[0]);
        BundleProvider.put(mappings, "jcl.over.slf4j", new Info("org.slf4j", "jcl-over-slf4j"));
        BundleProvider.put(mappings, "jcommon", new Info[0]);
        BundleProvider.put(mappings, "jencrypt", new Info[0]);
        BundleProvider.put(mappings, "jets3t", new Info[0]);
        BundleProvider.put(mappings, "jffmpeg", new Info[0]);
        BundleProvider.put(mappings, "jfreechart", new Info[0]);
        BundleProvider.put(mappings, "jfreechart.patch", new Info[0]);
        BundleProvider.put(mappings, "jline", new Info("jline", "jline"));
        BundleProvider.put(mappings, "jmimemagic", new Info[0]);
        BundleProvider.put(mappings, "joda-convert", new Info("org.joda", "joda-convert"));
        BundleProvider.put(mappings, "joda-time", new Info("joda-time", "joda-time"));
        BundleProvider.put(mappings, "jpedal.gpl", new Info[0]);
        BundleProvider.put(mappings, "jta", new Info("org.jboss.javaee", "jboss-transaction-api"));
        BundleProvider.put(mappings, "jtds", new Info[0]);
        BundleProvider.put(mappings, "junit", new Info[0]);
        BundleProvider.put(mappings, "junit-jupiter", new Info[0]);
        BundleProvider.put(mappings, "junit-jupiter-api", new Info[0]);
        BundleProvider.put(mappings, "junit-jupiter-engine", new Info[0]);
        BundleProvider.put(mappings, "junit-jupiter-params", new Info[0]);
        BundleProvider.put(mappings, "junit-platform-commons", new Info[0]);
        BundleProvider.put(mappings, "junit-platform-engine", new Info[0]);
        BundleProvider.put(mappings, "jython-standalone", new Info("com.carrotsearch", "java-sizeof"));
        BundleProvider.put(mappings, "log4j", new Info("log4j", "log4j"));
        BundleProvider.put(mappings, "lowagie.itext", new Info[0]);
        BundleProvider.put(mappings, "lucee.image.extension", new Info[0]);
        BundleProvider.put(mappings, "lucene.search.extension", new Info[0]);
        BundleProvider.put(mappings, "memcached", new Info[0]);
        BundleProvider.put(mappings, "memcached.extension", new Info[0]);
        BundleProvider.put(mappings, "metadata.extractor", new Info("com.drewnoakes", "metadata-extractor"));
        BundleProvider.put(mappings, "microsoft.sqljdbc", new Info[0]);
        BundleProvider.put(mappings, "mongodb.extension", new Info[0]);
        BundleProvider.put(mappings, "mssqljdbc4", new Info[0]);
        BundleProvider.put(mappings, "mx4j", new Info[0]);
        BundleProvider.put(mappings, "mx4j.lite", new Info[0]);
        BundleProvider.put(mappings, "net.lingala.zip4j", new Info("net.lingala.zip4j", "zip4j"));
        BundleProvider.put(mappings, "net.sf.ehcache", new Info("net.sf.ehcache", "ehcache"));
        BundleProvider.put(mappings, "net.twentyonesolutions.luceeapps", new Info("net.twentyonesolutions", "lucee-apps"));
        BundleProvider.put(mappings, "net.twentyonesolutions.luceewebsocket", new Info("net.twentyonesolutions", "lucee-websocket"));
        BundleProvider.put(mappings, "nu.xom", new Info[0]);
        BundleProvider.put(mappings, "ojdbc14", new Info[0]);
        BundleProvider.put(mappings, "ojdbc6", new Info[0]);
        BundleProvider.put(mappings, "ojdbc7", new Info[0]);
        BundleProvider.put(mappings, "openamf", new Info[0]);
        BundleProvider.put(mappings, "openamf.astranslator", new Info[0]);
        BundleProvider.put(mappings, "org.activiti.engine", new Info("org.activiti", "activiti-engine"));
        BundleProvider.put(mappings, "org.apache.commons.cli", new Info("commons-cli", "commons-cli"));
        BundleProvider.put(mappings, "org.apache.commons.codec", new Info("commons-codec", "commons-codec"));
        BundleProvider.put(mappings, "org.apache.commons.collections", new Info("commons-collections", "commons-collections"));
        BundleProvider.put(mappings, "org.apache.commons.collections4", new Info("org.apache.commons", "commons-collections4"));
        BundleProvider.put(mappings, "org.apache.commons.commons-codec", new Info("commons-codec", "commons-codec"));
        BundleProvider.put(mappings, "org.apache.commons.commons-collections4", new Info("org.apache.commons", "commons-collections4"));
        BundleProvider.put(mappings, "org.apache.commons.commons-compress", new Info("org.apache.commons", "commons-compress"));
        BundleProvider.put(mappings, "org.apache.commons.commons-imaging", new Info("org.apache.commons", "commons-imaging"));
        BundleProvider.put(mappings, "org.apache.commons.commons-io", new Info("commons-io", "commons-io"));
        BundleProvider.put(mappings, "org.apache.commons.commons-net", new Info("commons-net", "commons-net"));
        BundleProvider.put(mappings, "org.apache.commons.commons-pool2", new Info("org.apache.commons", "commons-pool2"));
        BundleProvider.put(mappings, "org.apache.commons.commons-text", new Info("org.apache.commons", "commons-text"));
        BundleProvider.put(mappings, "org.apache.commons.compress", new Info("org.apache.commons", "commons-compress"));
        BundleProvider.put(mappings, "org.apache.commons.discovery", new Info[0]);
        BundleProvider.put(mappings, "org.apache.commons.email", new Info("org.apache.commons", "commons-email"));
        BundleProvider.put(mappings, "org.apache.commons.fileupload", new Info("commons-fileupload", "commons-fileupload"));
        BundleProvider.put(mappings, "org.apache.commons.commons-fileupload2-core", new Info("org.apache.commons", "commons-fileupload2-core"));
        BundleProvider.put(mappings, "org.apache.commons.httpclient", new Info("org.apache.httpcomponents", "httpclient"));
        BundleProvider.put(mappings, "org.apache.commons.httpcore", new Info("org.apache.httpcomponents", "httpcore"));
        BundleProvider.put(mappings, "org.apache.commons.httpmime", new Info("org.apache.httpcomponents", "httpmime"));
        BundleProvider.put(mappings, "org.apache.commons.image", new Info("org.apache.commons", "commons-imaging"));
        BundleProvider.put(mappings, "org.apache.commons.io", new Info("commons-io", "commons-io"));
        BundleProvider.put(mappings, "org.apache.commons.lang", new Info("commons-lang", "commons-lang"));
        BundleProvider.put(mappings, "org.apache.commons.lang3", new Info("org.apache.commons", "commons-lang3"));
        BundleProvider.put(mappings, "org.apache.commons.logging", new Info("commons-logging", "commons-logging"));
        BundleProvider.put(mappings, "org.apache.commons.logging.adapters", new Info("commons-logging", "commons-logging"));
        BundleProvider.put(mappings, "org.apache.commons.logging.api", new Info("commons-logging", "commons-logging"));
        BundleProvider.put(mappings, "org.apache.commons.math3", new Info("org.apache.commons", "commons-math3"));
        BundleProvider.put(mappings, "org.apache.commons.net", new Info("commons-net", "commons-net"));
        BundleProvider.put(mappings, "org.apache.commons.pool", new Info("commons-pool", "commons-pool"));
        BundleProvider.put(mappings, "org.apache.commons.pool2", new Info("org.apache.commons", "commons-pool2"));
        BundleProvider.put(mappings, "org.apache.felix.framework", new Info("org.apache.felix", "org.apache.felix.framework"));
        BundleProvider.put(mappings, "org.apache.fop", new Info[0]);
        BundleProvider.put(mappings, "org.apache.hadoop.zookeeper", new Info[0]);
        BundleProvider.put(mappings, "org.apache.logging.log4j.core", new Info("org.apache.logging.log4j", "log4j-core"));
        BundleProvider.put(mappings, "org.apache.oro", new Info[0]);
        BundleProvider.put(mappings, "org.apache.pdfbox", new Info("org.apache.pdfbox", "pdfbox"));
        BundleProvider.put(mappings, "org.apache.pdfbox.fontbox", new Info("org.apache.pdfbox", "fontbox"));
        BundleProvider.put(mappings, "org.apache.pdfbox.jempbox", new Info("org.apache.pdfbox", "jempbox"));
        BundleProvider.put(mappings, "org.apache.poi", new Info[0]);
        BundleProvider.put(mappings, "org.apache.poi.ooxml", new Info[0]);
        BundleProvider.put(mappings, "org.apache.sanselan.sanselan", new Info("org.apache.sanselan", "sanselan"));
        BundleProvider.put(mappings, "org.apache.servicemix.bundles.poi", new Info("org.apache.servicemix.bundles", "org.apache.servicemix.bundles.poi"));
        BundleProvider.put(mappings, "org.apache.tika.core", new Info("org.apache.tika", "tika-core"));
        BundleProvider.put(mappings, "org.apache.tika.parsers", new Info("org.apache.tika", "tika-parsers"));
        BundleProvider.put(mappings, "org.apiguardian.api", new Info[0]);
        BundleProvider.put(mappings, "org.aspectj.lang", new Info[0]);
        BundleProvider.put(mappings, "org.glassfish.javax.json", new Info("org.glassfish", "javax.json"));
        BundleProvider.put(mappings, "org.h2", new Info[0]);
        BundleProvider.put(mappings, "org.hamcrest", new Info[0]);
        BundleProvider.put(mappings, "org.hibernate.common.hibernate-commons-annotations", new Info[0]);
        BundleProvider.put(mappings, "org.hibernate.core", new Info[0]);
        BundleProvider.put(mappings, "org.hibernate.ehcache", new Info[0]);
        BundleProvider.put(mappings, "org.hibernate.javax.persistence.hibernate-jpa-2.1-api", new Info[0]);
        BundleProvider.put(mappings, "org.hsqldb.hsqldb", new Info[0]);
        BundleProvider.put(mappings, "org.infinispan.client-hotrod", new Info("org.infinispan", "infinispan-client-hotrod"));
        BundleProvider.put(mappings, "org.infinispan.commons", new Info("org.lucee", "org.infinispan.commons"));
        BundleProvider.put(mappings, "org.infinispan.protostream", new Info("com.google.protobuf", "protobuf-java"));
        BundleProvider.put(mappings, "org.infinispan.query-dsl", new Info("org.infinispan", "infinispan-query-dsl"));
        BundleProvider.put(mappings, "org.infinispan.remote-query-client", new Info("org.infinispan", "infinispan-remote-query-client"));
        BundleProvider.put(mappings, "org.jboss.logging.jboss-logging", new Info("org.jboss.logging", "jboss-logging"));
        BundleProvider.put(mappings, "org.jboss.marshalling.jboss-marshalling-osgi", new Info("org.jboss.marshalling", "jboss-marshalling-osgi"));
        BundleProvider.put(mappings, "org.jfree.chart", new Info("org.jfree", "jfreechart"));
        BundleProvider.put(mappings, "org.jfree.common", new Info("org.jfree", "jcommon"));
        BundleProvider.put(mappings, "org.joda.time", new Info("joda-time", "joda-time"));
        BundleProvider.put(mappings, "org.jsoup", new Info("org.jsoup", "jsoup"));
        BundleProvider.put(mappings, "org.jsr-305", new Info("com.google.code.findbugs", "jsr305"));
        BundleProvider.put(mappings, "org.lucee.antisamy", new Info("org.lucee", "antisamy"));
        BundleProvider.put(mappings, "org.lucee.antlr", new Info("org.lucee", "antlr"));
        BundleProvider.put(mappings, "org.lucee.argon2", new Info("org.lucee", "argon2"));
        BundleProvider.put(mappings, "org.lucee.aws-core", new Info("org.lucee", "awscore"));
        BundleProvider.put(mappings, "org.lucee.aws-java-sdk-core", new Info("org.lucee", "aws-java-sdk-core"));
        BundleProvider.put(mappings, "org.lucee.aws-java-sdk-kms", new Info("org.lucee", "aws-java-sdk-kms"));
        BundleProvider.put(mappings, "org.lucee.aws-java-sdk-s3", new Info("org.lucee", "aws-java-sdk-s3"));
        BundleProvider.put(mappings, "org.lucee.aws-java-sdk-s3-all", new Info("org.lucee", "aws-jmespath-java"));
        BundleProvider.put(mappings, "org.lucee.aws-jmespath-java", new Info("org.lucee", "aws-jmespath-java"));
        BundleProvider.put(mappings, "org.lucee.aws-java-sdk-secretsmanager-all", new Info("org.lucee", "aws-java-sdk-core"));
        BundleProvider.put(mappings, "org.lucee.aws-jmespath", new Info("org.lucee", "awsjmespath"));
        BundleProvider.put(mappings, "org.lucee.aws-secretsmanager", new Info("org.lucee", "awssecretsmanager"));
        BundleProvider.put(mappings, "org.lucee.axis", new Info("org.lucee", "axis"));
        BundleProvider.put(mappings, "org.lucee.axis.ant", new Info("org.lucee", "axis-ant"));
        BundleProvider.put(mappings, "org.lucee.axis.extension", new Info[0]);
        BundleProvider.put(mappings, "org.lucee.batik", new Info("org.lucee", "batik"));
        BundleProvider.put(mappings, "org.lucee.batikutil", new Info("org.lucee", "batik-util"));
        BundleProvider.put(mappings, "org.lucee.bouncycastle.bcprov", new Info("org.lucee", "bcprov-jdk15on"));
        BundleProvider.put(mappings, "org.lucee.commons.httpclient", new Info("org.lucee", "commons-httpclient"));
        BundleProvider.put(mappings, "org.lucee.commons.compress", new Info("org.lucee", "commons-compress"));
        BundleProvider.put(mappings, "org.lucee.commons.email", new Info("org.lucee", "commons-email"));
        BundleProvider.put(mappings, "org.lucee.commons.fileupload", new Info("org.lucee", "commons-fileupload"));
        BundleProvider.put(mappings, "org.lucee.commons.io", new Info("commons-io", "commons-io"));
        BundleProvider.put(mappings, "org.lucee.commons.lang", new Info("org.lucee", "commons-lang"));
        BundleProvider.put(mappings, "org.lucee.commons.logging", new Info("org.lucee", "commons-logging"));
        BundleProvider.put(mappings, "org.lucee.commons.logging.adapters", new Info("org.lucee", "commons-logging-adapters"));
        BundleProvider.put(mappings, "org.lucee.commons.logging.api", new Info("org.lucee", "commons-logging-api"));
        BundleProvider.put(mappings, "org.lucee.commons.sanselan", new Info("org.lucee", "commons-sanselan"));
        BundleProvider.put(mappings, "org.lucee.dom4j", new Info("org.lucee", "dom4j"));
        BundleProvider.put(mappings, "org.lucee.ehcache", new Info("org.lucee", "ehcache"));
        BundleProvider.put(mappings, "org.lucee.ehcachecore", new Info("org.lucee", "ehcacheCore"));
        BundleProvider.put(mappings, "org.lucee.esapi", new Info("org.lucee", "esapi"));
        BundleProvider.put(mappings, "org.lucee.esapi-logger", new Info[0]);
        BundleProvider.put(mappings, "org.lucee.exasol", new Info("org.lucee", "exasol"));
        BundleProvider.put(mappings, "org.lucee.flyingSaucerCore", new Info("org.lucee", "flyingSaucerCore"));
        BundleProvider.put(mappings, "org.lucee.flyingSaucerPDF", new Info("org.lucee", "flyingSaucerPDF"));
        BundleProvider.put(mappings, "org.lucee.geoip2", new Info("org.lucee", "geoip2"));
        BundleProvider.put(mappings, "org.lucee.gotson-webp", new Info("org.lucee", "gotson-webp"));
        BundleProvider.put(mappings, "org.lucee.h2", new Info("org.lucee", "h2"));
        BundleProvider.put(mappings, "org.lucee.hsqldb", new Info("org.lucee", "hsqldb"));
        BundleProvider.put(mappings, "org.lucee.httpcomponents.httpclient", new Info("org.lucee", "httpcomponents-httpclient"));
        BundleProvider.put(mappings, "org.lucee.httpcomponents.httpcore", new Info("org.lucee", "httpcomponents-httpcore"));
        BundleProvider.put(mappings, "org.lucee.httpcomponents.httpmime", new Info("org.lucee", "httpcomponents-httpmime"));
        BundleProvider.put(mappings, "org.lucee.imgscalr", new Info("org.lucee", "imgscalr"));
        BundleProvider.put(mappings, "org.lucee.itext", new Info("org.lucee", "itext"));
        BundleProvider.put(mappings, "org.lucee.javassist", new Info("org.lucee", "javassist"));
        BundleProvider.put(mappings, "org.lucee.jaxrpc", new Info("org.lucee", "jaxrpc"));
        BundleProvider.put(mappings, "org.lucee.jboss-logging-processor", new Info("org.lucee", "jboss-logging-processor"));
        BundleProvider.put(mappings, "org.lucee.jcip-annotations", new Info("org.lucee", "jcip-annotations"));
        BundleProvider.put(mappings, "org.lucee.jdeparser", new Info("org.lucee", "jboss-jdeparser"));
        BundleProvider.put(mappings, "org.lucee.jets3t", new Info("org.lucee", "jets3t"));
        BundleProvider.put(mappings, "org.lucee.jmagick", new Info("org.lucee", "jmagick"));
        BundleProvider.put(mappings, "org.lucee.jmimemagic", new Info("org.lucee", "jmimemagic"));
        BundleProvider.put(mappings, "org.lucee.jsch", new Info("org.lucee", "jsch"));
        BundleProvider.put(mappings, "org.lucee.jta", new Info("org.lucee", "jta"));
        BundleProvider.put(mappings, "org.lucee.jzlib", new Info("org.lucee", "jzlib"));
        BundleProvider.put(mappings, "org.lucee.launchdarkly", new Info("org.lucee", "launchdarkly"));
        BundleProvider.put(mappings, "org.lucee.launchdarkly-redis", new Info("org.lucee", "launchdarkly-redis"));
        BundleProvider.put(mappings, "org.lucee.log4j-api", new Info("org.lucee", "log4j-api"));
        BundleProvider.put(mappings, "org.lucee.log4j-core", new Info("org.lucee", "log4j-core"));
        BundleProvider.put(mappings, "org.lucee.maxmind-db", new Info("org.lucee", "maxmind-db"));
        BundleProvider.put(mappings, "org.lucee.metadata-extractor", new Info("org.lucee", "metadata-extractor"));
        BundleProvider.put(mappings, "org.lucee.mssql", new Info("org.lucee", "mssql"));
        BundleProvider.put(mappings, "org.lucee.oracle", new Info("org.lucee", "oracle"));
        BundleProvider.put(mappings, "org.lucee.oro", new Info("org.lucee", "oro"));
        BundleProvider.put(mappings, "org.lucee.oswego-concurrent", new Info("org.lucee", "oswego-concurrent"));
        BundleProvider.put(mappings, "org.lucee.pdfbox", new Info("org.lucee", "pdfbox"));
        BundleProvider.put(mappings, "org.lucee.pdfbox-fontbox", new Info("org.lucee", "pdfbox-fontbox"));
        BundleProvider.put(mappings, "org.lucee.poi-ooxml-schemas", new Info("org.lucee", "poi-ooxml-schemas"));
        BundleProvider.put(mappings, "org.lucee.poi-scratchpad", new Info("org.lucee", "poi-scratchpad"));
        BundleProvider.put(mappings, "org.lucee.portlet", new Info("org.lucee", "portlet"));
        BundleProvider.put(mappings, "org.lucee.postgresql", new Info("org.lucee", "postgresql"));
        BundleProvider.put(mappings, "org.lucee.protoparser", new Info("org.lucee", "protoparser"));
        BundleProvider.put(mappings, "org.lucee.saaj", new Info("org.lucee", "saaj"));
        BundleProvider.put(mappings, "org.lucee.sejda-webp", new Info("org.lucee", "sejda-webp"));
        BundleProvider.put(mappings, "org.lucee.software.amazon.ion", new Info("org.lucee", "software.amazon.ion"));
        BundleProvider.put(mappings, "org.lucee.spymemcached", new Info("org.lucee", "spymemcached"));
        BundleProvider.put(mappings, "org.lucee.tika-core", new Info("org.lucee", "tika-core"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.common-image", new Info("org.lucee", "com.twelvemonkeys.common-image"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.common-io", new Info("org.lucee", "com.twelvemonkeys.common-io"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.common-lang", new Info("org.lucee", "com.twelvemonkeys.common-lang"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-bmp", new Info("org.lucee", "com.twelvemonkeys.imageio-bmp"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-core", new Info("org.lucee", "com.twelvemonkeys.imageio-core"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-icns", new Info("org.lucee", "com.twelvemonkeys.imageio-icns"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-ico", new Info("org.lucee", "com.twelvemonkeys.imageio-ico"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-jpeg", new Info("org.lucee", "com.twelvemonkeys.imageio-jpeg"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-metadata", new Info("org.lucee", "com.twelvemonkeys.imageio-metadata"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-psd", new Info("org.lucee", "com.twelvemonkeys.imageio-psd"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-tiff", new Info("org.lucee", "com.twelvemonkeys.imageio-tiff"));
        BundleProvider.put(mappings, "org.lucee.twelvemonkeys.imageio-webp", new Info("org.lucee", "com.twelvemonkeys.imageio-webp"));
        BundleProvider.put(mappings, "org.lucee.txtmark", new Info("org.lucee", "txtmark"));
        BundleProvider.put(mappings, "org.lucee.websocket.extension", new Info[0]);
        BundleProvider.put(mappings, "org.lucee.wsdl4j", new Info("org.lucee", "wsdl4j"));
        BundleProvider.put(mappings, "org.lucee.xalan", new Info("org.lucee", "xalan"));
        BundleProvider.put(mappings, "org.lucee.xalan.serializer", new Info("org.lucee", "xalan-serializer"));
        BundleProvider.put(mappings, "org.lucee.xml", new Info("org.lucee", "xml"));
        BundleProvider.put(mappings, "org.lucee.xml.apis", new Info("org.lucee", "xml-apis"));
        BundleProvider.put(mappings, "org.lucee.xml.apisext", new Info("org.lucee", "xml-apis-ext"));
        BundleProvider.put(mappings, "org.lucee.xml.resolver", new Info("org.lucee", "xml-resolver"));
        BundleProvider.put(mappings, "org.lucee.xml.xerces", new Info("org.lucee", "xml-xerces"));
        BundleProvider.put(mappings, "org.lucee.xmlbeans", new Info("org.lucee", "xmlbeans"));
        BundleProvider.put(mappings, "org.lucee.xmpcore", new Info("org.lucee", "xmpcore"));
        BundleProvider.put(mappings, "org.lucee.zip4j", new Info("org.lucee", "zip4j"));
        BundleProvider.put(mappings, "org.mongodb.bson", new Info("org.mongodb", "bson"));
        BundleProvider.put(mappings, "org.mongodb.driver", new Info("org.mongodb", "mongodb-driver"));
        BundleProvider.put(mappings, "org.mongodb.driver-core", new Info("org.mongodb", "mongodb-driver-core"));
        BundleProvider.put(mappings, "org.mongodb.mongo-java-driver", new Info("org.mongodb", "mongo-java-driver"));
        BundleProvider.put(mappings, "org.objectweb.asm.all", new Info[0]);
        BundleProvider.put(mappings, "org.opentest4j", new Info[0]);
        BundleProvider.put(mappings, "org.postgresql.jdbc", new Info("org.postgresql", "postgresql"));
        BundleProvider.put(mappings, "org.postgresql.jdbc40", new Info("org.postgresql", "postgresql"));
        BundleProvider.put(mappings, "org.postgresql.jdbc41", new Info("org.postgresql", "postgresql"));
        BundleProvider.put(mappings, "org.postgresql.jdbc42", new Info("org.postgresql", "postgresql"));
        BundleProvider.put(mappings, "org.xhtmlrenderer.flying.saucer.core", new Info("org.xhtmlrenderer", "flying-saucer-core"));
        BundleProvider.put(mappings, "pdf.extension", new Info[0]);
        BundleProvider.put(mappings, "postgresql", new Info[0]);
        BundleProvider.put(mappings, "redis.clients.jedis", new Info("redis.clients", "jedis"));
        BundleProvider.put(mappings, "redis.extension", new Info[0]);
        BundleProvider.put(mappings, "redissentinel.extension", new Info[0]);
        BundleProvider.put(mappings, "resolver", new Info[0]);
        BundleProvider.put(mappings, "s3.extension", new Info[0]);
        BundleProvider.put(mappings, "sapdbc", new Info[0]);
        BundleProvider.put(mappings, "sentry", new Info("io.sentry", "sentry"));
        BundleProvider.put(mappings, "sentry.extension", new Info[0]);
        BundleProvider.put(mappings, "sentry-log4j", new Info("io.sentry", "sentry-log4j"));
        BundleProvider.put(mappings, "sentry-log4j2", new Info[0]);
        BundleProvider.put(mappings, "serializer", new Info[0]);
        BundleProvider.put(mappings, "slf4j.api", new Info("org.slf4j", "slf4j-api"));
        BundleProvider.put(mappings, "slf4j.nop", new Info("org.slf4j", "slf4j-nop"));
        BundleProvider.put(mappings, "smtp.dumbster", new Info[0]);
        BundleProvider.put(mappings, "software.amazon.ion.java", new Info("software.amazon.ion", "ion-java"));
        BundleProvider.put(mappings, "ss.css2", new Info[0]);
        BundleProvider.put(mappings, "stax.api", new Info[0]);
        BundleProvider.put(mappings, "stax2-api", new Info("org.codehaus.woodstox", "stax2-api"));
        BundleProvider.put(mappings, "sun.activation", new Info[0]);
        BundleProvider.put(mappings, "sun.jai.codec", new Info[0]);
        BundleProvider.put(mappings, "sun.jai.core", new Info[0]);
        BundleProvider.put(mappings, "sun.jndi.ldap", new Info[0]);
        BundleProvider.put(mappings, "sun.jndi.ldapbp", new Info[0]);
        BundleProvider.put(mappings, "sun.jndi.ldapsec", new Info[0]);
        BundleProvider.put(mappings, "sun.jndi.providerutil", new Info[0]);
        BundleProvider.put(mappings, "sun.mail", new Info[0]);
        BundleProvider.put(mappings, "sun.security.jaas", new Info[0]);
        BundleProvider.put(mappings, "sun.xml.jaxrpc", new Info[0]);
        BundleProvider.put(mappings, "sun.xml.saaj", new Info[0]);
        BundleProvider.put(mappings, "sun.xml.wsdl4j", new Info[0]);
        BundleProvider.put(mappings, "tagsoup", new Info[0]);
        BundleProvider.put(mappings, "w3c.dom", new Info[0]);
        BundleProvider.put(mappings, "woodstox-core-asl", new Info[0]);
        BundleProvider.put(mappings, "xdb", new Info[0]);
        BundleProvider.put(mappings, "xml.apis", new Info[0]);
        BundleProvider.put(mappings, "xmlbeans", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.anim", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.awt.util", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.bridge", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.css", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.dom", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.ext", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.extension", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.gvt", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.parser", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.script", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.svg.dom", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.transcoder", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.util", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.batik.xml", new Info[0]);
        BundleProvider.put(mappings, "xmlgraphics.commons", new Info[0]);
        BundleProvider.put(mappings, "xmlparserv2", new Info[0]);
        BundleProvider.put(mappings, "xmpcore", new Info[0]);
        BundleProvider.put(mappings, "zip4j", new Info("net.lingala.zip4j", "zip4j"));
        BundleProvider.put(mappings, "org.apache.felix.main", new Info("org.apache.felix", "org.apache.felix.framework"));
        BundleProvider.put(mappings, "org.lucee.janino", new Info("org.lucee", "janino"));
        BundleProvider.put(mappings, "org.lucee.janinocc", new Info("org.lucee", "janino-commons-compiler"));
        BundleProvider.put(mappings, "org.apache.commons.commons-fileupload", new Info("commons-fileupload", "commons-fileupload"));
        BundleProvider.put(mappings, "jakarta.activation-api", new Info("jakarta.activation-api", "jakarta.activation"));
        BundleProvider.put(mappings, "jakarta.mail-api", new Info("jakarta.mail-api", "jakarta.mail"));
        BundleProvider.put(mappings, "com.sun.activation.jakarta.activation", new Info("com.sun.activation", "jakarta.activation"));
        BundleProvider.put(mappings, "com.sun.mail.jakarta.mail", new Info("com.sun.mail", "jakarta.mail"));
        BundleProvider.put(mappings, "org.lucee.greenmail", new Info("org.lucee", "com.icegreen"));
        BundleProvider.put(mappings, "org.lucee.jakarta-activation-mail", new Info("com.sun.mail", "jakarta.mail"));
        BundleProvider.put(mappings, "org.lucee.commons-email-all", new Info("org.lucee", "commons-email-all"));
        BundleProvider.put(mappings, "com.github.f4b6a3.ulid", new Info("com.github.f4b6a3", "ulid-creator"));
        BundleProvider.put(mappings, "org.objectweb.asm.tree.analysis", new Info("org.ow2.asm", "asm-analysis"));
        BundleProvider.put(mappings, "org.objectweb.asm.commons", new Info("org.ow2.asm", "asm-commons"));
        BundleProvider.put(mappings, "org.objectweb.asm.util", new Info("org.ow2.asm", "asm-util"));
        BundleProvider.put(mappings, "org.objectweb.asm", new Info("org.ow2.asm", "asm"));
        BundleProvider.put(mappings, "org.objectweb.asm.tree", new Info("org.ow2.asm", "asm-tree"));
        BundleProvider.put(mappings, "com.sun.xml.bind.jaxb-core", new Info("com.sun.istack", "istack-commons-runtime"));
        BundleProvider.put(mappings, "com.sun.xml.bind.jaxb-impl", new Info("org.glassfish.jaxb", "jaxb-runtime"));
        BundleProvider.put(mappings, "org.lucee.commonmark", new Info("org.lucee", "commonmark"));
        BundleProvider.put(mappings, "org.lucee.argon2-jvm-nolibs", new Info("org.lucee", "argon2-jvm-nolibs"));
        BundleProvider.put(mappings, "com.github.mwiede.jsch", new Info("com.github.mwiede", "jsch"));
    }

    private static final class Pair {
        final long lastModified;
        final BundleProvider bundleProvider;

        public Pair(long lastModified, BundleProvider bundleProvider) {
            this.lastModified = lastModified;
            this.bundleProvider = bundleProvider;
        }
    }

    public static class BundleDefinition {
        private static final int QUALIFIER_APPENDIX_SNAPSHOT = 1;
        private static final int QUALIFIER_APPENDIX_BETA = 2;
        private static final int QUALIFIER_APPENDIX_RC = 3;
        private static final int QUALIFIER_APPENDIX_OTHER = 4;
        private static final int QUALIFIER_APPENDIX_STABLE = 5;
        private String name;
        private Version version;

        public BundleDefinition(String name, Version version) {
            this.name = name;
            this.version = version;
        }

        public BundleDefinition(String name, String version) throws BundleException {
            this.name = name;
            this.version = BundleProvider.toVersion(version);
        }

        public String getVersionAsString() {
            return this.version == null ? null : this.version.toString();
        }

        public int compare(BundleDefinition bd) {
            int cmp = this.name.compareTo(bd.name);
            if (cmp != 0) {
                return cmp;
            }
            return BundleDefinition.compare(this.version, bd.version);
        }

        private static int compare(Version left, Version right) {
            int qran;
            int qr;
            if (left.getMajor() > right.getMajor()) {
                return 100;
            }
            if (left.getMajor() < right.getMajor()) {
                return -100;
            }
            if (left.getMinor() > right.getMinor()) {
                return 50;
            }
            if (left.getMinor() < right.getMinor()) {
                return -50;
            }
            if (left.getMicro() > right.getMicro()) {
                return 10;
            }
            if (left.getMicro() < right.getMicro()) {
                return -10;
            }
            String q = left.getQualifier();
            int index = q.indexOf(45);
            String qla = index == -1 ? "" : q.substring(index + 1).trim();
            String qln = index == -1 ? q : q.substring(0, index);
            int ql = Util.isEmpty(qln) ? Integer.MIN_VALUE : Integer.parseInt(qln);
            q = right.getQualifier();
            index = q.indexOf(45);
            String qra = index == -1 ? "" : q.substring(index + 1).trim();
            String qrn = index == -1 ? q : q.substring(0, index);
            int n = qr = Util.isEmpty(qrn) ? Integer.MIN_VALUE : Integer.parseInt(qrn);
            if (ql > qr) {
                return 5;
            }
            if (ql < qr) {
                return -5;
            }
            int qlan = BundleDefinition.qualifierAppendix2Number(qla);
            if (qlan > (qran = BundleDefinition.qualifierAppendix2Number(qra))) {
                return 2;
            }
            if (qlan < qran) {
                return -2;
            }
            if (qlan == 4 && qran == 4) {
                return left.compareTo(right) > 0 ? 1 : -1;
            }
            return 0;
        }

        private static int qualifierAppendix2Number(String str) {
            if (Util.isEmpty(str, true)) {
                return 5;
            }
            if ("SNAPSHOT".equalsIgnoreCase(str)) {
                return 1;
            }
            if ("BETA".equalsIgnoreCase(str)) {
                return 2;
            }
            if ("RC".equalsIgnoreCase(str)) {
                return 3;
            }
            return 4;
        }
    }

    private static class Info {
        private String groupId;
        private String artifactId;
        private String bundleSymbolicName;

        public Info(String groupId, String artifactId) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public Info(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public boolean isMaven() {
            return this.groupId != null && this.artifactId != null;
        }

        public String toString() {
            return String.format("groupId:%s;artifactId:%s;bundleSymbolicName:%s", this.groupId, this.artifactId, this.bundleSymbolicName);
        }
    }
}

