/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.reflect;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.loader.ClassFactoryContext;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.locks.LockOwner;
import org.apache.derby.iapi.services.locks.ShExLockable;
import org.apache.derby.iapi.services.locks.ShExQual;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.services.reflect.ClassLoaderLock;
import org.apache.derby.impl.services.reflect.DatabaseClasses;
import org.apache.derby.impl.services.reflect.JarLoader;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.stream.HeaderPrintWriter;

final class UpdateLoader
implements LockOwner {
    private static final String[] RESTRICTED_PACKAGES = new String[]{"javax.", "org.apache.derby."};
    private JarLoader[] jarList;
    private HeaderPrintWriter vs;
    private final ClassLoader myLoader;
    private boolean initDone;
    private String thisClasspath;
    private final LockFactory lf;
    private final ShExLockable classLoaderLock;
    private int version;
    private boolean normalizeToUpper;
    private DatabaseClasses parent;
    private final CompatibilitySpace compat;
    private boolean needReload;
    private JarReader jarReader;

    UpdateLoader(String classpath, DatabaseClasses parent, boolean verbose, boolean normalizeToUpper) throws StandardException {
        this.normalizeToUpper = normalizeToUpper;
        this.parent = parent;
        this.lf = (LockFactory)UpdateLoader.getServiceModule(parent, "org.apache.derby.iapi.services.locks.LockFactory");
        CompatibilitySpace compatibilitySpace = this.compat = this.lf != null ? this.lf.createCompatibilitySpace(this) : null;
        if (verbose) {
            this.vs = Monitor.getStream();
        }
        this.myLoader = this.getClass().getClassLoader();
        this.classLoaderLock = new ClassLoaderLock(this);
        this.initializeFromClassPath(classpath);
    }

    private void initializeFromClassPath(String classpath) throws StandardException {
        final String[][] elements = IdUtil.parseDbClassPath(classpath);
        final int jarCount = elements.length;
        this.jarList = new JarLoader[jarCount];
        if (jarCount != 0) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (int i = 0; i < jarCount; ++i) {
                        ((UpdateLoader)UpdateLoader.this).jarList[i] = new JarLoader(UpdateLoader.this, elements[i], UpdateLoader.this.vs);
                    }
                    return null;
                }
            });
        }
        if (this.vs != null) {
            this.vs.println(MessageService.getTextMessage((String)"C005", (Object[])new Object[]{classpath}));
        }
        this.thisClasspath = classpath;
        this.initDone = false;
    }

    /*
     * Exception decompiling
     */
    Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    InputStream getResourceAsStream(String name) {
        InputStream is;
        InputStream inputStream = is = this.myLoader == null ? ClassLoader.getSystemResourceAsStream(name) : this.myLoader.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        if (name.endsWith(".class")) {
            return null;
        }
        boolean unlockLoader = false;
        try {
            unlockLoader = this.lockClassLoader(ShExQual.SH);
            UpdateLoader updateLoader = this;
            synchronized (updateLoader) {
                if (this.needReload) {
                    this.reload();
                }
                if (!this.initDone) {
                    this.initLoaders();
                }
                for (int i = 0; i < this.jarList.length; ++i) {
                    JarLoader jl = this.jarList[i];
                    is = jl.getStream(name);
                    if (is == null) continue;
                    InputStream inputStream2 = is;
                    return inputStream2;
                }
            }
            updateLoader = null;
            return updateLoader;
        }
        catch (StandardException se) {
            InputStream inputStream3 = null;
            return inputStream3;
        }
        finally {
            if (unlockLoader) {
                this.lf.unlock(this.compat, this, this.classLoaderLock, ShExQual.SH);
            }
        }
    }

    synchronized void modifyClasspath(String classpath) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        this.modifyJar(false);
        this.initializeFromClassPath(classpath);
    }

    synchronized void modifyJar(boolean reload) throws StandardException {
        this.lockClassLoader(ShExQual.EX);
        ++this.version;
        if (!this.initDone) {
            return;
        }
        this.close();
        if (reload) {
            this.initializeFromClassPath(this.thisClasspath);
        }
    }

    private boolean lockClassLoader(ShExQual qualifier) throws StandardException {
        if (this.lf == null) {
            return false;
        }
        ClassFactoryContext cfc = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
        CompatibilitySpace lockSpace = null;
        if (cfc != null) {
            lockSpace = cfc.getLockSpace();
        }
        if (lockSpace == null) {
            lockSpace = this.compat;
        }
        LockOwner lockGroup = lockSpace.getOwner();
        this.lf.lockObject(lockSpace, lockGroup, this.classLoaderLock, qualifier, -2);
        return lockGroup == this;
    }

    Class checkLoaded(String className, boolean resolve) {
        for (int i = 0; i < this.jarList.length; ++i) {
            Class c = this.jarList[i].checkLoaded(className, resolve);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    void close() {
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].setInvalid();
        }
    }

    private void initLoaders() {
        if (this.initDone) {
            return;
        }
        for (int i = 0; i < this.jarList.length; ++i) {
            this.jarList[i].initialize();
        }
        this.initDone = true;
    }

    int getClassLoaderVersion() {
        return this.version;
    }

    synchronized void needReload() {
        ++this.version;
        this.needReload = true;
    }

    private void reload() throws StandardException {
        this.thisClasspath = this.getClasspath();
        this.close();
        this.initializeFromClassPath(this.thisClasspath);
        this.needReload = false;
    }

    private String getClasspath() throws StandardException {
        ClassFactoryContext cfc = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
        PersistentSet ps = cfc.getPersistentSet();
        String classpath = PropertyUtil.getServiceProperty(ps, "derby.database.classpath");
        if (classpath == null) {
            classpath = "";
        }
        return classpath;
    }

    JarReader getJarReader() {
        if (this.jarReader == null) {
            ClassFactoryContext cfc = (ClassFactoryContext)UpdateLoader.getContextOrNull("ClassFactoryContext");
            this.jarReader = cfc.getJarReader();
        }
        return this.jarReader;
    }

    @Override
    public boolean noWait() {
        return false;
    }

    @Override
    public boolean isNestedOwner() {
        return false;
    }

    @Override
    public boolean nestsUnder(LockOwner other) {
        return false;
    }

    private static Context getContextOrNull(final String contextID) {
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull(contextID);
            }
        });
    }

    private static Object getServiceModule(final Object serviceModule, final String factoryInterface) {
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return Monitor.getServiceModule(serviceModule, factoryInterface);
            }
        });
    }
}

