/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.utils;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.utils.SystemClientUtil;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.sessions.AuthenticationSessionModel;

public class LogoutUtil {
    public static Response sendResponseAfterLogoutFinished(KeycloakSession session, AuthenticationSessionModel logoutSession) {
        String redirectUri = logoutSession.getAuthNote("OIDC_LOGOUT_REDIRECT_URI");
        URI finalRedirectUri = LogoutUtil.getRedirectUriWithAttachedState(redirectUri, logoutSession);
        OIDCAdvancedConfigWrapper config = OIDCAdvancedConfigWrapper.fromClientModel(logoutSession.getClient());
        LoginFormsProvider loginFormsProvider = (LoginFormsProvider)session.getProvider(LoginFormsProvider.class);
        if (finalRedirectUri != null) {
            if (!config.isLogoutConfirmationEnabled()) {
                return Response.status((int)302).location(finalRedirectUri).build();
            }
            loginFormsProvider.setAttribute("pageRedirectUri", (Object)finalRedirectUri.toString());
        }
        SystemClientUtil.checkSkipLink((KeycloakSession)session, (AuthenticationSessionModel)logoutSession);
        return loginFormsProvider.setSuccess("successLogout", new Object[0]).setDetachedAuthSession().createInfoPage();
    }

    public static URI getRedirectUriWithAttachedState(String redirectUri, AuthenticationSessionModel logoutSession) {
        if (redirectUri == null) {
            return null;
        }
        String state = logoutSession.getAuthNote("OIDC_LOGOUT_STATE_PARAM");
        UriBuilder uriBuilder = UriBuilder.fromUri((String)redirectUri);
        if (state != null) {
            uriBuilder.queryParam("state", new Object[]{state});
        }
        return uriBuilder.build(new Object[0]);
    }
}

