/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.JSONArray;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.ParseUtil;
import twitter4j.StatusJSONImpl;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.v1.GeoLocation;
import twitter4j.v1.Query;
import twitter4j.v1.QueryResult;
import twitter4j.v1.Status;

final class QueryResultJSONImpl
extends TwitterResponseImpl
implements QueryResult,
Serializable {
    private static final long serialVersionUID = -5359566235429947156L;
    private final long sinceId;
    private long maxId;
    private String refreshUrl;
    private final int count;
    private double completedIn;
    private String query;
    private final List<Status> tweets;
    private String nextResults;

    QueryResultJSONImpl(HttpResponse res, boolean jsonStoreEnabled) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        try {
            JSONObject searchMetaData = json.getJSONObject("search_metadata");
            this.completedIn = ParseUtil.getDouble("completed_in", searchMetaData);
            this.count = ParseUtil.getInt("count", searchMetaData);
            this.maxId = ParseUtil.getLong("max_id", searchMetaData);
            this.nextResults = searchMetaData.has("next_results") ? searchMetaData.getString("next_results") : null;
            this.query = ParseUtil.getURLDecodedString("query", searchMetaData);
            this.refreshUrl = ParseUtil.getUnescapedString("refresh_url", searchMetaData);
            this.sinceId = ParseUtil.getLong("since_id", searchMetaData);
            JSONArray array = json.getJSONArray("statuses");
            this.tweets = new ArrayList<Status>(array.length());
            if (jsonStoreEnabled) {
                TwitterObjectFactory.clearThreadLocalMap();
            }
            for (int i = 0; i < array.length(); ++i) {
                JSONObject tweet = array.getJSONObject(i);
                this.tweets.add(new StatusJSONImpl(tweet, jsonStoreEnabled));
            }
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone.getMessage() + ":" + json, jsone);
        }
    }

    QueryResultJSONImpl(Query query) {
        this.sinceId = query.sinceId;
        this.count = query.count;
        this.tweets = new ArrayList<Status>(0);
    }

    static Query createWithNextPageQuery(@NotNull String nextPageQuery) {
        String nextPageParameters = nextPageQuery.substring(1);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        for (HttpParameter param : HttpParameter.decodeParameters(nextPageParameters)) {
            params.put(param.getName(), param.getValue());
        }
        Query query = Query.of(params.getOrDefault("q", ""));
        if (params.containsKey("lang")) {
            query = query.lang((String)params.get("lang"));
        }
        if (params.containsKey("locale")) {
            query = query.locale((String)params.get("locale"));
        }
        if (params.containsKey("max_id")) {
            query = query.maxId(Long.parseLong((String)params.get("max_id")));
        }
        if (params.containsKey("count")) {
            query = query.count(Integer.parseInt((String)params.get("count")));
        }
        if (params.containsKey("geocode")) {
            String[] parts = ((String)params.get("geocode")).split(",");
            double latitude = Double.parseDouble(parts[0]);
            double longitude = Double.parseDouble(parts[1]);
            Query.Unit unit = null;
            String radiusstr = parts[2];
            for (Query.Unit value : Query.Unit.values()) {
                if (!radiusstr.endsWith(value.name())) continue;
                double radius = Double.parseDouble(radiusstr.substring(0, radiusstr.length() - 2));
                unit = value;
                query = query.geoCode(GeoLocation.of(latitude, longitude), radius, unit);
                break;
            }
            if (unit == null) {
                throw new IllegalArgumentException("unrecognized geocode radius: " + radiusstr);
            }
        }
        if (params.containsKey("result_type")) {
            Query.ResultType resultType = Query.ResultType.valueOf((String)params.get("result_type"));
            query = query.resultType(resultType);
        }
        return query;
    }

    @Override
    public long getSinceId() {
        return this.sinceId;
    }

    @Override
    public long getMaxId() {
        return this.maxId;
    }

    @Override
    public String getRefreshURL() {
        return this.refreshUrl;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public double getCompletedIn() {
        return this.completedIn;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public List<Status> getTweets() {
        return this.tweets;
    }

    @Override
    public Query nextQuery() {
        if (this.nextResults == null) {
            return null;
        }
        return QueryResultJSONImpl.createWithNextPageQuery(this.nextResults);
    }

    @Override
    public boolean hasNext() {
        return this.nextResults != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueryResult that = (QueryResult)o;
        if (Double.compare(that.getCompletedIn(), this.completedIn) != 0) {
            return false;
        }
        if (this.maxId != that.getMaxId()) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (this.sinceId != that.getSinceId()) {
            return false;
        }
        if (!this.query.equals(that.getQuery())) {
            return false;
        }
        if (this.refreshUrl != null ? !this.refreshUrl.equals(that.getRefreshURL()) : that.getRefreshURL() != null) {
            return false;
        }
        return this.tweets != null ? this.tweets.equals(that.getTweets()) : that.getTweets() == null;
    }

    public int hashCode() {
        int result = (int)(this.sinceId ^ this.sinceId >>> 32);
        result = 31 * result + (int)(this.maxId ^ this.maxId >>> 32);
        result = 31 * result + (this.refreshUrl != null ? this.refreshUrl.hashCode() : 0);
        result = 31 * result + this.count;
        long temp = this.completedIn != 0.0 ? Double.doubleToLongBits(this.completedIn) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.query.hashCode();
        result = 31 * result + (this.tweets != null ? this.tweets.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "QueryResultJSONImpl{sinceId=" + this.sinceId + ", maxId=" + this.maxId + ", refreshUrl='" + this.refreshUrl + '\'' + ", count=" + this.count + ", completedIn=" + this.completedIn + ", query='" + this.query + '\'' + ", tweets=" + this.tweets + '}';
    }
}

