/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.Converters;
import io.smallrye.config.common.AbstractConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SysPropConfigSource
extends AbstractConfigSource {
    private static final long serialVersionUID = 9167738611308785403L;
    public static final String NAME = "SysPropConfigSource";
    public static final int ORDINAL = 400;

    public SysPropConfigSource() {
        super(NAME, SysPropConfigSource.getSystemOrdinal());
    }

    public Map<String, String> getProperties() {
        if (System.getSecurityManager() == null) {
            return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap((Properties)System.getProperties()));
        }
        return AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                return Collections.unmodifiableMap(ConfigSourceUtil.propertiesToMap((Properties)AccessController.doPrivileged(System::getProperties)));
            }
        });
    }

    public Set<String> getPropertyNames() {
        if (System.getSecurityManager() == null) {
            return System.getProperties().stringPropertyNames();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Set<String>>(){

            @Override
            public Set<String> run() {
                return System.getProperties().stringPropertyNames();
            }
        });
    }

    public String getValue(String propertyName) {
        return SysPropConfigSource.getSystemProperty(propertyName);
    }

    private static int getSystemOrdinal() {
        String value = SysPropConfigSource.getSystemProperty("config_ordinal");
        if (value != null) {
            return (Integer)Converters.INTEGER_CONVERTER.convert(value);
        }
        return 400;
    }

    private static String getSystemProperty(final String propertyName) {
        if (System.getSecurityManager() == null) {
            return System.getProperty(propertyName);
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }
}

