/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.converter;

import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.util.JsonSerialization;

public class MapStringConverter
implements AttributeConverter<Map<String, String>, String> {
    private static final Logger logger = Logger.getLogger(MapStringConverter.class);

    public String convertToDatabaseColumn(Map<String, String> attribute) {
        try {
            return JsonSerialization.writeValueAsString(attribute);
        }
        catch (IOException e) {
            logger.error((Object)"Error while converting Map to JSON String: ", (Throwable)e);
            return null;
        }
    }

    public Map<String, String> convertToEntityAttribute(String dbData) {
        try {
            return (Map)JsonSerialization.readValue((String)dbData, Map.class);
        }
        catch (IOException e) {
            logger.error((Object)"Error while converting JSON String to Map: ", (Throwable)e);
            return null;
        }
    }
}

