/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.concurrent.Callable;
import sun.awt.shell.DefaultShellFolder;
import sun.awt.shell.ShellFolder;

class ShellFolderManager {
    ShellFolderManager() {
    }

    public ShellFolder createShellFolder(File file) throws FileNotFoundException {
        return new DefaultShellFolder(null, file);
    }

    public Object get(String string) {
        if (string.equals("fileChooserDefaultFolder")) {
            File file = new File(System.getProperty("user.home"));
            try {
                return this.createShellFolder(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return file;
            }
        }
        if (string.equals("roots")) {
            return File.listRoots();
        }
        if (string.equals("fileChooserComboBoxFolders")) {
            return this.get("roots");
        }
        if (string.equals("fileChooserShortcutPanelFolders")) {
            return new File[]{(File)this.get("fileChooserDefaultFolder")};
        }
        return null;
    }

    public boolean isComputerNode(File file) {
        return false;
    }

    public boolean isFileSystemRoot(File file) {
        if (file instanceof ShellFolder && !((ShellFolder)file).isFileSystem()) {
            return false;
        }
        return file.getParentFile() == null;
    }

    protected ShellFolder.Invoker createInvoker() {
        return new DirectInvoker();
    }

    private static class DirectInvoker
    implements ShellFolder.Invoker {
        private DirectInvoker() {
        }

        @Override
        public <T> T invoke(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }
}

