/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jetCheck;

import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jetCheck.AbstractDataStructure;
import org.jetbrains.jetCheck.CannotRestoreValue;
import org.jetbrains.jetCheck.Generator;
import org.jetbrains.jetCheck.IntCustomizer;
import org.jetbrains.jetCheck.IntData;
import org.jetbrains.jetCheck.IntDistribution;
import org.jetbrains.jetCheck.NodeId;
import org.jetbrains.jetCheck.StructureElement;
import org.jetbrains.jetCheck.StructureKind;
import org.jetbrains.jetCheck.StructureNode;

class ReplayDataStructure
extends AbstractDataStructure {
    private final Iterator<StructureElement> iterator;
    private final IntCustomizer customizer;
    private final Set<NodeId> unneeded;

    ReplayDataStructure(StructureNode node, int sizeHint, IntCustomizer customizer, Set<NodeId> unneeded) {
        super(node, sizeHint);
        this.iterator = node.childrenIterator();
        this.customizer = customizer;
        this.unneeded = unneeded;
    }

    @Override
    int drawInt(@NotNull IntDistribution distribution) {
        return this.customizer.suggestInt(this.nextChild(IntData.class), distribution);
    }

    @NotNull
    private <E extends StructureElement> E nextChild(Class<E> required) {
        if (!this.iterator.hasNext()) {
            throw new CannotRestoreValue();
        }
        StructureElement next2 = this.iterator.next();
        if (!required.isInstance(next2)) {
            throw new CannotRestoreValue();
        }
        return (E)next2;
    }

    @Override
    public <T> T generate(@NotNull Generator<T> generator) {
        return this.generate(generator, this.childSizeHint());
    }

    private <T> T generate(@NotNull Generator<T> generator, int childSizeHint) {
        ReplayDataStructure child = new ReplayDataStructure(this.nextChild(StructureNode.class), childSizeHint, this.customizer, this.unneeded);
        T value = generator.getGeneratorFunction().apply(child);
        if (child.iterator.hasNext()) {
            this.unneeded.add(child.iterator.next().id);
        }
        return value;
    }

    @Override
    <T> T generateNonShrinkable(@NotNull Generator<T> generator) {
        return this.generate(generator, this.sizeHint);
    }

    @Override
    <T> T generateConditional(@NotNull Generator<T> generator, @NotNull Predicate<? super T> condition) {
        T value = this.generate(generator);
        if (!condition.test(value)) {
            throw new CannotRestoreValue();
        }
        return value;
    }

    @Override
    void changeKind(StructureKind kind) {
        if (this.node.kind != kind) {
            throw new CannotRestoreValue();
        }
    }

    public String toString() {
        return this.node.toString();
    }
}

