/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.diagnostic.telemetry.TelemetryManager;
import com.intellij.platform.vcs.impl.shared.telemetry.VcsScopeKt;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.IndexDataGetter;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.DataPackUtilKt;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitReference;
import git4idea.branch.DeepComparatorHolder;
import git4idea.branch.GitCompareUtilKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Scope;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0003=>?B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020#H\u0016J\u0018\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\u0015H\u0007J\b\u0010+\u001a\u00020%H\u0007J\b\u0010,\u001a\u00020#H\u0007J\u0010\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010-\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020%H\u0002J0\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00150\u00172\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002020\u00172\u0006\u0010*\u001a\u00020\u0015H\u0002J\u0012\u00103\u001a\u00020%2\b\u00104\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u00105\u001a\u00020%H\u0016J4\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\u0006\u00108\u001a\u0002012\b\b\u0001\u00109\u001a\u00020\u00152\f\u0010:\u001a\b\u0012\u0004\u0012\u0002H70;H\u0082\b\u00a2\u0006\u0002\u0010<R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lgit4idea/branch/DeepComparator;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "getStorage", "()Lcom/intellij/vcs/log/data/VcsLogStorage;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "comparedBranch", "", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "nonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "column", "isSelected", "", "update", "", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "refreshHappened", "startTask", "branchToCompare", "stopTaskAndUnhighlight", "hasHighlightingOrInProgress", "stopTask", "unhighlight", "getRepositories", "providers", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "notifyUnhighlight", "branch", "dispose", "recordSpan", "R", "root", "actionName", "block", "Lkotlin/Function0;", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "MyTask", "Factory", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nDeepComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n*L\n1#1,365:1\n1617#2,9:366\n1869#2:375\n1870#2:377\n1626#2:378\n774#2:379\n865#2,2:380\n1285#2,2:382\n1299#2,4:384\n1#3:376\n27#4:388\n87#4,2:389\n28#4,3:391\n98#4:394\n90#4,6:395\n*S KotlinDebug\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator\n*L\n159#1:366,9\n159#1:375\n159#1:377\n159#1:378\n159#1:379\n159#1:380,2\n161#1:382,2\n161#1:384,4\n159#1:376\n360#1:388\n360#1:389,2\n360#1:391,3\n360#1:394\n360#1:395,6\n*E\n"})
public final class DeepComparator
implements VcsLogHighlighter,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogData vcsLogData;
    @NotNull
    private final VcsLogUi ui;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private String comparedBranch;
    @Nullable
    private Map<GitRepository, String> repositoriesWithCurrentBranches;
    @Nullable
    private IntOpenHashSet nonPickedCommits;
    @NotNull
    private static final Logger LOG;

    public DeepComparator(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogData vcsLogData, @NotNull VcsLogUi ui2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.vcsLogData = vcsLogData;
        this.ui = ui2;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    private final VcsLogStorage getStorage() {
        return this.vcsLogData.getStorage();
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, int column, boolean isSelected) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)commitDetails, (String)"commitDetails");
                if (this.nonPickedCommits == null) break block2;
                IntOpenHashSet intOpenHashSet = this.nonPickedCommits;
                Intrinsics.checkNotNull((Object)intOpenHashSet);
                if (!intOpenHashSet.contains(commitId)) break block3;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"DEFAULT");
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"foreground(...)");
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        if (this.comparedBranch == null) {
            return;
        }
        VcsLogFilterCollection vcsLogFilterCollection = dataPack.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
        VcsLogRefs vcsLogRefs = dataPack.getRefs();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogRefs, (String)"getRefs(...)");
        String singleFilteredBranch = Companion.getComparedBranchFromFilters(vcsLogFilterCollection, vcsLogRefs);
        if (!Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch)) {
            String oldComparedBranch = this.comparedBranch;
            LOG.debug("Branch filter changed. Compared branch: " + oldComparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight(oldComparedBranch);
            return;
        }
        if (refreshHappened) {
            this.stopTask();
            Map map2 = dataPack.getLogProviders();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(...)");
            String string = this.comparedBranch;
            Intrinsics.checkNotNull((Object)string);
            Map<GitRepository, String> repositories = this.getRepositories(map2, string);
            if (Intrinsics.areEqual(repositories, this.repositoriesWithCurrentBranches)) {
                this.startTask(dataPack);
            } else {
                LOG.debug("Repositories with current branches changed. Actual:\n" + repositories + "\nExpected:\n" + this.repositoriesWithCurrentBranches);
                this.unhighlight();
            }
        }
    }

    @RequiresEdt
    public final void startTask(@NotNull VcsLogDataPack dataPack, @NotNull String branchToCompare) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)branchToCompare, (String)"branchToCompare");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        Map map2 = this.ui.getDataPack().getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(...)");
        Map<GitRepository, String> repositories = this.getRepositories(map2, branchToCompare);
        if (repositories.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithCurrentBranches = repositories;
        this.startTask(dataPack);
    }

    @RequiresEdt
    public final void stopTaskAndUnhighlight() {
        ThreadingAssertions.assertEventDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    @RequiresEdt
    public final boolean hasHighlightingOrInProgress() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask(VcsLogDataPack dataPack) {
        LOG.debug("Highlighting requested for " + this.repositoriesWithCurrentBranches);
        Map<GitRepository, String> map2 = this.repositoriesWithCurrentBranches;
        Intrinsics.checkNotNull(map2);
        String string = this.comparedBranch;
        Intrinsics.checkNotNull((Object)string);
        MyTask task = new MyTask(map2, dataPack, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task;
        ProgressIndicator progressIndicator = this.progressIndicator;
        Intrinsics.checkNotNull((Object)progressIndicator);
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithCurrentBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, String> getRepositories(Map<VirtualFile, ? extends VcsLogProvider> providers, String branchToCompare) {
        void $this$associateWithTo$iv$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = providers.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitRepository it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((GitRepository)this.repositoryManager.getRepositoryForRootQuick(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository repository2 = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(repository2.getBranches().findBranchByName(branchToCompare) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            GitRepository bl = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = destination$iv$iv2;
            boolean bl4 = false;
            Object object = it.getCurrentBranch();
            if (object == null || (object = ((GitReference)object).getName()) == null) {
                object = "HEAD";
            }
            Object object2 = object;
            map2.put(t, object2);
        }
        return destination$iv$iv2;
    }

    private final void notifyUnhighlight(String branch) {
        if (this.ui instanceof VcsLogUiEx) {
            Object[] objectArray = new Object[]{branch};
            String string = GitBundle.message("git.log.cherry.picked.highlighter.cancelled.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            Balloon balloon2 = balloon;
            JComponent jComponent = VcsLogUiUtil.getComponent((VcsLogUiEx)((VcsLogUiEx)this.ui));
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent component2 = jComponent;
            balloon2.show(new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon2));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R recordSpan(VirtualFile root, @NonNls String actionName, Function0<? extends R> block) {
        Object object;
        boolean $i$f$recordSpan = false;
        SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName);
        Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
        SpanBuilder $this$use$iv = spanBuilder;
        boolean $i$f$use = false;
        Span span = $this$use$iv.startSpan();
        Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
        Span $this$useWithoutActiveScope$iv$iv = span;
        boolean $i$f$useWithoutActiveScope = false;
        try {
            Object object2;
            Span span$iv = $this$useWithoutActiveScope$iv$iv;
            boolean bl = false;
            AutoCloseable autoCloseable = (AutoCloseable)span$iv.makeCurrent();
            Throwable throwable = null;
            try {
                Scope it$iv = (Scope)autoCloseable;
                boolean bl2 = false;
                Span span2 = span$iv;
                boolean bl3 = false;
                span2.setAttribute("rootName", root.getName());
                object2 = block.invoke();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                InlineMarker.finallyEnd((int)1);
            }
            object = object2;
        }
        catch (CancellationException e$iv$iv) {
            throw e$iv$iv;
        }
        catch (Throwable e$iv$iv) {
            $this$useWithoutActiveScope$iv$iv.setStatus(StatusCode.ERROR);
            throw e$iv$iv;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            $this$useWithoutActiveScope$iv$iv.end();
            InlineMarker.finallyEnd((int)1);
        }
        return (R)object;
    }

    @JvmStatic
    @NotNull
    public static final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
        return Companion.getInstance(project, dataProvider, logUi);
    }

    @JvmStatic
    @Nullable
    public static final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
        return Companion.getComparedBranchFromFilters(filters, refs);
    }

    static {
        Logger logger = Logger.getInstance(DeepComparator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgit4idea/branch/DeepComparator$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/branch/DeepComparator;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getComparedBranchFromFilters", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "refs", "Lcom/intellij/vcs/log/VcsLogRefs;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final DeepComparator getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
            DeepComparator deepComparator = ((DeepComparatorHolder)project.getService(DeepComparatorHolder.class)).getInstance(dataProvider, logUi);
            Intrinsics.checkNotNullExpressionValue((Object)deepComparator, (String)"getInstance(...)");
            return deepComparator;
        }

        @JvmStatic
        @Nullable
        public final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogRefs refs) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
            String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)filters, (VcsLogRefs)refs);
            if (singleFilteredBranch != null) {
                return singleFilteredBranch;
            }
            VcsLogRangeFilter vcsLogRangeFilter = (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER);
            if (vcsLogRangeFilter == null) {
                return null;
            }
            VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
            VcsLogRangeFilter.RefRange refRange = (VcsLogRangeFilter.RefRange)CollectionsKt.singleOrNull((List)rangeFilter.getRanges());
            return refRange != null ? refRange.getInclusiveRef() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/branch/DeepComparator$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "<init>", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
            return Companion.getInstance(logData.getProject(), logData, logUi);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            String string = GitBundle.message("action.Git.Log.DeepCompare.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J \u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\"\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J \u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0002J<\u0010!\u001a\u0004\u0018\u00010\u00182\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020\u00182\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020\u0005H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lgit4idea/branch/DeepComparator$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithCurrentBranches", "", "Lgit4idea/repo/GitRepository;", "", "vcsLogDataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "comparedBranch", "<init>", "(Lgit4idea/branch/DeepComparator;Ljava/util/Map;Lcom/intellij/vcs/log/VcsLogDataPack;Ljava/lang/String;)V", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "collectedNonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "exception", "Lcom/intellij/openapi/vcs/VcsException;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFinished", "onSuccess", "getCommitsByPatch", "Lit/unimi/dsi/fastutil/ints/IntSet;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "targetBranch", "sourceBranch", "getCommitsByIndexReliable", "getCommitsByIndexFast", "getCommitsFromGit", "currentBranch", "getCommitsFromIndex", "sourceBranchRef", "Lcom/intellij/vcs/log/VcsRef;", "targetBranchRef", "sourceBranchCommits", "reliable", "", "toString", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nDeepComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator$MyTask\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 DeepComparator.kt\ngit4idea/branch/DeepComparator\n+ 4 trace.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/TraceKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,365:1\n216#2,2:366\n360#3:368\n361#3,2:374\n360#3:384\n361#3,2:390\n360#3:400\n361#3,2:406\n27#4:369\n87#4,2:370\n28#4,2:372\n30#4:376\n98#4:377\n90#4,6:378\n27#4:385\n87#4,2:386\n28#4,2:388\n98#4:392\n30#4:393\n90#4,6:394\n27#4:401\n87#4,2:402\n28#4,2:404\n98#4:408\n30#4:409\n90#4,6:410\n106#5:416\n78#5,22:417\n*S KotlinDebug\n*F\n+ 1 DeepComparator.kt\ngit4idea/branch/DeepComparator$MyTask\n*L\n192#1:366,2\n232#1:368\n232#1:374,2\n242#1:384\n242#1:390,2\n254#1:400\n254#1:406,2\n232#1:369\n232#1:370,2\n232#1:372,2\n232#1:376\n232#1:377\n232#1:378,6\n242#1:385\n242#1:386,2\n242#1:388,2\n242#1:392\n242#1:393\n242#1:394,6\n254#1:401\n254#1:402,2\n254#1:404,2\n254#1:408\n254#1:409\n254#1:410,6\n276#1:416\n276#1:417,22\n*E\n"})
    private final class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Map<GitRepository, String> repositoriesWithCurrentBranches;
        @NotNull
        private final String comparedBranch;
        @Nullable
        private final DataPack dataPack;
        @NotNull
        private final IntOpenHashSet collectedNonPickedCommits;
        @Nullable
        private VcsException exception;

        public MyTask(@NotNull Map<GitRepository, String> repositoriesWithCurrentBranches, @NotNull VcsLogDataPack vcsLogDataPack, String comparedBranch) {
            Intrinsics.checkNotNullParameter(repositoriesWithCurrentBranches, (String)"repositoriesWithCurrentBranches");
            Intrinsics.checkNotNullParameter((Object)vcsLogDataPack, (String)"vcsLogDataPack");
            Intrinsics.checkNotNullParameter((Object)comparedBranch, (String)"comparedBranch");
            super(DeepComparator.this.project, GitBundle.message("git.log.cherry.picked.highlighter.process", new Object[0]));
            this.repositoriesWithCurrentBranches = repositoriesWithCurrentBranches;
            this.comparedBranch = comparedBranch;
            VisiblePack visiblePack = vcsLogDataPack instanceof VisiblePack ? (VisiblePack)vcsLogDataPack : null;
            DataPackBase dataPackBase = visiblePack != null ? visiblePack.getDataPack() : null;
            this.dataPack = dataPackBase instanceof DataPack ? (DataPack)dataPackBase : null;
            this.collectedNonPickedCommits = new IntOpenHashSet();
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            try {
                Map<GitRepository, String> $this$forEach$iv = this.repositoriesWithCurrentBranches;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<GitRepository, String>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    IntSet intSet;
                    Map.Entry<GitRepository, String> element$iv;
                    Map.Entry<GitRepository, String> entry = element$iv = iterator.next();
                    boolean bl = false;
                    GitRepository repo = entry.getKey();
                    String currentBranch = entry.getValue();
                    if (Registry.Companion.is("git.log.use.index.for.picked.commits.highlighting")) {
                        if (Registry.Companion.is("git.log.fast.picked.commits.highlighting")) {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                            intSet = this.getCommitsByIndexFast(virtualFile, this.comparedBranch, currentBranch);
                            if (intSet == null) {
                                VirtualFile virtualFile2 = repo.getRoot();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getRoot(...)");
                                intSet = this.getCommitsByIndexReliable(virtualFile2, this.comparedBranch, currentBranch);
                            }
                        } else {
                            VirtualFile virtualFile = repo.getRoot();
                            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                            intSet = this.getCommitsByIndexReliable(virtualFile, this.comparedBranch, currentBranch);
                        }
                    } else {
                        VirtualFile virtualFile = repo.getRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                        intSet = this.getCommitsByPatch(virtualFile, this.comparedBranch, currentBranch);
                    }
                    IntSet commits = intSet;
                    this.collectedNonPickedCommits.addAll((IntCollection)commits);
                }
            }
            catch (VcsException e) {
                LOG.warn((Throwable)e);
                this.exception = e;
            }
        }

        public void onFinished() {
            DeepComparator.this.progressIndicator = null;
        }

        public void onSuccess() {
            if (this.exception != null) {
                DeepComparator.this.nonPickedCommits = null;
                VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
                Object[] objectArray = new Object[]{this.comparedBranch};
                String string = GitBundle.message("git.log.cherry.picked.highlighter.error.message", objectArray);
                VcsException vcsException = this.exception;
                Intrinsics.checkNotNull((Object)((Object)vcsException));
                vcsNotifier.notifyError("git.could.not.compare.with.branch", string, vcsException.getMessage());
                return;
            }
            DeepComparator.this.nonPickedCommits = this.collectedNonPickedCommits;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final IntSet getCommitsByPatch(VirtualFile root, String targetBranch, String sourceBranch) throws VcsException {
            IntSet intSet;
            DeepComparator deepComparator = DeepComparator.this;
            VirtualFile virtualFile = root;
            String actionName$iv = "Getting non picked commits with git";
            boolean $i$f$recordSpan = false;
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder $this$use$iv$iv = spanBuilder;
            boolean $i$f$use = false;
            Span span = $this$use$iv$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            Span $this$useWithoutActiveScope$iv$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                IntSet intSet2;
                Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    void root$iv;
                    Scope it$iv$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span span$iv = span$iv$iv;
                    boolean bl3 = false;
                    span$iv.setAttribute("rootName", root$iv.getName());
                    boolean bl4 = false;
                    intSet2 = this.getCommitsFromGit(root, targetBranch, sourceBranch);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                intSet = intSet2;
            }
            catch (CancellationException e$iv$iv$iv) {
                throw e$iv$iv$iv;
            }
            catch (Throwable e$iv$iv$iv) {
                $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv$iv;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv$iv.end();
            }
            return intSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final IntSet getCommitsByIndexReliable(VirtualFile root, String sourceBranch, String targetBranch) throws VcsException {
            IntSet resultFromIndex;
            IntSet intSet;
            IntSet resultFromGit = this.getCommitsByPatch(root, targetBranch, sourceBranch);
            if (this.dataPack == null) return resultFromGit;
            if (!this.dataPack.isFull()) {
                return resultFromGit;
            }
            DeepComparator deepComparator = DeepComparator.this;
            VirtualFile virtualFile = root;
            String actionName$iv = "Getting non picked commits with index reliable";
            boolean $i$f$recordSpan = false;
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder(actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder $this$use$iv$iv = spanBuilder;
            boolean $i$f$use = false;
            Span span = $this$use$iv$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            Span $this$useWithoutActiveScope$iv$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                IntSet intSet2;
                Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    VcsRef vcsRef;
                    VcsRef vcsRef2;
                    void root$iv;
                    Scope it$iv$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span span$iv = span$iv$iv;
                    boolean bl3 = false;
                    span$iv.setAttribute("rootName", root$iv.getName());
                    boolean bl4 = false;
                    RefsModel refsModel = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root) == null) {
                        IntSet intSet3 = resultFromGit;
                        IntSet intSet4 = intSet3;
                        return intSet4;
                    }
                    VcsRef sourceBranchRef = vcsRef2;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"getRefsModel(...)");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)targetBranch, (VirtualFile)root) == null) {
                        IntSet intSet5 = resultFromGit;
                        IntSet intSet6 = intSet5;
                        return intSet6;
                    }
                    VcsRef targetBranchRef = vcsRef;
                    intSet2 = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, resultFromGit, true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                intSet = intSet2;
            }
            catch (CancellationException e$iv$iv$iv) {
                throw e$iv$iv$iv;
            }
            catch (Throwable e$iv$iv$iv) {
                $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv$iv;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv$iv.end();
            }
            IntSet intSet7 = resultFromIndex = intSet;
            IntSet intSet8 = intSet7;
            if (intSet7 != null) return intSet8;
            intSet8 = resultFromGit;
            return intSet8;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final IntSet getCommitsByIndexFast(VirtualFile root, String sourceBranch, String targetBranch) {
            void actionName$iv;
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) return null;
            if (this.dataPack == null) return null;
            if (!this.dataPack.isFull()) {
                return null;
            }
            DeepComparator deepComparator = DeepComparator.this;
            VirtualFile virtualFile = root;
            String string = "Getting non picked commits with index fast";
            DeepComparator deepComparator2 = DeepComparator.this;
            boolean $i$f$recordSpan = false;
            SpanBuilder spanBuilder = TelemetryManager.Companion.getInstance().getTracer(VcsScopeKt.VcsScope).spanBuilder((String)actionName$iv);
            Intrinsics.checkNotNullExpressionValue((Object)spanBuilder, (String)"spanBuilder(...)");
            SpanBuilder $this$use$iv$iv = spanBuilder;
            boolean $i$f$use = false;
            Span span = $this$use$iv$iv.startSpan();
            Intrinsics.checkNotNullExpressionValue((Object)span, (String)"startSpan(...)");
            Span $this$useWithoutActiveScope$iv$iv$iv = span;
            boolean $i$f$useWithoutActiveScope = false;
            try {
                IntSet intSet;
                Span span$iv$iv = $this$useWithoutActiveScope$iv$iv$iv;
                boolean bl = false;
                AutoCloseable autoCloseable = (AutoCloseable)span$iv$iv.makeCurrent();
                Throwable throwable = null;
                try {
                    IntSet intSet2;
                    VcsRef vcsRef;
                    VcsRef vcsRef2;
                    void root$iv;
                    Scope it$iv$iv = (Scope)autoCloseable;
                    boolean bl2 = false;
                    Span span$iv = span$iv$iv;
                    boolean bl3 = false;
                    span$iv.setAttribute("rootName", root$iv.getName());
                    boolean bl4 = false;
                    RefsModel refsModel = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel, (String)sourceBranch, (VirtualFile)root) == null) {
                        IntSet intSet3 = null;
                        IntSet intSet4 = intSet3;
                        return intSet4;
                    }
                    VcsRef sourceBranchRef = vcsRef2;
                    RefsModel refsModel2 = this.dataPack.getRefsModel();
                    Intrinsics.checkNotNullExpressionValue((Object)refsModel2, (String)"getRefsModel(...)");
                    if (DataPackUtilKt.findBranch((RefsModel)refsModel2, (String)targetBranch, (VirtualFile)root) == null) {
                        IntSet intSet5 = null;
                        IntSet intSet6 = intSet5;
                        return intSet6;
                    }
                    VcsRef targetBranchRef = vcsRef;
                    if (DataPackUtilKt.subgraphDifference((DataPack)this.dataPack, (VcsRef)sourceBranchRef, (VcsRef)targetBranchRef, (VcsLogStorage)deepComparator2.getStorage()) == null) {
                        IntSet intSet7 = null;
                        IntSet intSet8 = intSet7;
                        return intSet8;
                    }
                    IntSet sourceBranchCommits = intSet2;
                    intSet = this.getCommitsFromIndex(this.dataPack, root, sourceBranchRef, targetBranchRef, sourceBranchCommits, false);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                IntSet intSet9 = intSet;
                return intSet9;
            }
            catch (CancellationException e$iv$iv$iv) {
                throw e$iv$iv$iv;
            }
            catch (Throwable e$iv$iv$iv) {
                $this$useWithoutActiveScope$iv$iv$iv.setStatus(StatusCode.ERROR);
                throw e$iv$iv$iv;
            }
            finally {
                $this$useWithoutActiveScope$iv$iv$iv.end();
            }
        }

        private final IntSet getCommitsFromGit(VirtualFile root, String currentBranch, String comparedBranch) throws VcsException {
            GitLineHandler handler = new GitLineHandler(this.getProject(), root, GitCommand.CHERRY);
            String[] stringArray = new String[]{currentBranch, comparedBranch};
            handler.addParameters(stringArray);
            IntOpenHashSet pickedCommits = new IntOpenHashSet();
            handler.addLineListener((arg_0, arg_1) -> MyTask.getCommitsFromGit$lambda$0(pickedCommits, DeepComparator.this, root, arg_0, arg_1));
            Git.getInstance().runCommandWithoutCollectingOutput(handler).throwOnError(new int[0]);
            return (IntSet)pickedCommits;
        }

        private final IntSet getCommitsFromIndex(DataPack dataPack, VirtualFile root, VcsRef sourceBranchRef, VcsRef targetBranchRef, IntSet sourceBranchCommits, boolean reliable) {
            if (dataPack == null) {
                return null;
            }
            if (sourceBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            if (!DeepComparator.this.vcsLogData.getIndex().isIndexed(root)) {
                return null;
            }
            IndexDataGetter indexDataGetter = DeepComparator.this.vcsLogData.getIndex().getDataGetter();
            if (indexDataGetter == null) {
                return null;
            }
            IndexDataGetter dataGetter = indexDataGetter;
            IntSet intSet = DataPackUtilKt.subgraphDifference((DataPack)dataPack, (VcsRef)targetBranchRef, (VcsRef)sourceBranchRef, (VcsLogStorage)DeepComparator.this.getStorage());
            if (intSet == null) {
                return null;
            }
            IntSet targetBranchCommits = intSet;
            if (targetBranchCommits.isEmpty()) {
                return sourceBranchCommits;
            }
            IntSet match = GitCompareUtilKt.match(dataGetter, root, sourceBranchCommits, targetBranchCommits, reliable);
            sourceBranchCommits.removeAll((IntCollection)match);
            if (!match.isEmpty()) {
                LOG.debug("Using index, detected " + match.size() + " commits in " + sourceBranchRef.getName() + "#" + root.getName() + " that were picked to the current branch" + (reliable ? " with different patch id but matching cherry-picked suffix" : " with matching author, author time and message"));
            }
            return sourceBranchCommits;
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithCurrentBranches;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getCommitsFromGit$lambda$0(IntOpenHashSet $pickedCommits, DeepComparator this$0, VirtualFile $root, String l, Key key) {
            String line;
            String string = line = l;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.startsWith$default((String)string, (String)"+", (boolean)false, (int)2, null)) {
                try {
                    int firstSpace;
                    void $this$trim$iv;
                    string = line;
                    Intrinsics.checkNotNull((Object)string);
                    int n = 2;
                    String string2 = string.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    string = string2;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    if ((firstSpace = StringsKt.indexOf$default((CharSequence)(line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()), (char)' ', (int)0, (boolean)false, (int)6, null)) > 0) {
                        String string3 = line.substring(0, firstSpace);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        line = string3;
                    }
                    VcsLogStorage vcsLogStorage = this$0.getStorage();
                    Hash hash = HashImpl.build((String)line);
                    Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(...)");
                    $pickedCommits.add(vcsLogStorage.getCommitIndex(hash, $root));
                }
                catch (Exception e) {
                    LOG.error("Couldn't parse line [" + line + "]", (Throwable)e);
                }
            }
        }
    }
}

