/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.util.function.DoubleUnaryOperator;
import org.rrd4j.graph.ImageParameters;

class LogService {
    static DoubleUnaryOperator resolve(ImageParameters im) {
        boolean sameSign = Math.signum(im.minval) == Math.signum(im.maxval);
        double absMinVal = Math.min(Math.abs(im.minval), Math.abs(im.maxval));
        double absMaxVal = Math.max(Math.abs(im.minval), Math.abs(im.maxval));
        if (!sameSign) {
            return LogService::log10;
        }
        if (absMinVal == 0.0 && absMaxVal < 1.0) {
            double correction = 1.0 / absMaxVal;
            return v -> LogService.log10(v, correction, absMinVal);
        }
        if (absMinVal == 0.0) {
            return LogService::log10;
        }
        if (absMinVal < 1.0) {
            double correction = 1.0 / absMinVal;
            return v -> LogService.log10(v, correction, absMinVal);
        }
        return LogService::log10;
    }

    private LogService() {
    }

    private static double log10(double v, double correction, double minval) {
        if (v == minval) {
            return 0.0;
        }
        double lv = Math.log10(Math.abs(v) * correction);
        if (lv < 0.0 || Double.isNaN(lv)) {
            return 0.0;
        }
        return Math.copySign(lv, v);
    }

    private static double log10(double v) {
        double lv = Math.log10(Math.abs(v));
        if (lv < 0.0) {
            return 0.0;
        }
        return Math.copySign(lv, v);
    }
}

