/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.DOMHierarchyRequestException;
import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.DOMAttr;
import io.sf.carte.doc.dom.DOMDocument;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyElementList;
import io.sf.carte.doc.dom.HTMLElement;
import io.sf.carte.doc.dom.StyleDefinerElementHelper;
import io.sf.carte.doc.style.css.CSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.BaseCSSStyleSheetFactory;
import io.sf.carte.doc.style.css.property.AttributeToStyle;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;

public abstract class HTMLDocument
extends DOMDocument {
    private static final long serialVersionUID = 2L;
    public static final String HTML_NAMESPACE_URI = "http://www.w3.org/1999/xhtml";
    private URL baseURL = null;
    private static final Set<String> rawTextElementsExceptStyle = new HashSet<String>(6);

    public HTMLDocument(DocumentType documentType) {
        super(documentType);
    }

    @Override
    public HTMLElement getDocumentElement() {
        return (HTMLElement)super.getDocumentElement();
    }

    @Override
    public HTMLDocument getOwnerDocument() {
        return null;
    }

    @Override
    public HTMLDocument cloneNode(boolean deep) {
        return (HTMLDocument)super.cloneNode(deep);
    }

    @Override
    DOMDocument cloneDocument(DocumentType docType) {
        String nsUri = null;
        String qName = null;
        HTMLElement docElm = this.getDocumentElement();
        if (docElm != null) {
            nsUri = docElm.getNamespaceURI();
            qName = docElm.getTagName();
        }
        DOMDocument doc = this.getImplementation().createDocument(nsUri, qName, docType);
        if (docElm != null) {
            doc.removeChild(doc.getDocumentElement());
        }
        return doc;
    }

    @Override
    public DOMElement createElement(String tagName) throws DOMException {
        if (tagName == null) {
            throw new DOMException(5, "null tag name");
        }
        return this.createElementNS(HTML_NAMESPACE_URI, tagName);
    }

    @Override
    public DOMElement createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        String localName;
        String prefix;
        if (qualifiedName == null) {
            throw new DOMException(5, "null qualified name");
        }
        if (namespaceURI != null && !namespaceURI.equals(HTML_NAMESPACE_URI) && namespaceURI.length() != 0) {
            namespaceURI = namespaceURI.intern();
            int idx = qualifiedName.indexOf(58);
            if (idx == -1) {
                prefix = this.lookupPrefix(namespaceURI);
                localName = qualifiedName;
            } else {
                if (idx == qualifiedName.length() - 1) {
                    throw new DOMException(5, "Empty local name");
                }
                if (idx == 0) {
                    throw new DOMException(5, "Empty prefix");
                }
                prefix = qualifiedName.substring(0, idx).intern();
                localName = qualifiedName.substring(idx + 1);
            }
        } else {
            namespaceURI = HTML_NAMESPACE_URI;
            localName = qualifiedName.toLowerCase(Locale.ROOT);
            prefix = null;
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        DOMElement myelem = "link".equals(localName) ? new LinkElement(namespaceURI) : ("style".equals(localName) ? new StyleElement(namespaceURI) : (namespaceURI == HTML_NAMESPACE_URI ? ("meta".equals(localName) ? new MetaElement() : ("base".equals(localName) ? new BaseElement() : ("title".equals(localName) ? new MetacontentElement(localName) : ("html".equals(localName) ? new HtmlRootElement() : ("img".equals(localName) ? new ImgElement() : ("font".equals(localName) ? new FontElement() : ("table".equals(localName) ? new TableElement() : ("tr".equals(localName) ? new TableRowElement() : ("td".equals(localName) ? new TableCellElement(localName) : ("th".equals(localName) ? new TableCellElement(localName) : (rawTextElementsExceptStyle.contains(localName) ? new RawTextElement(localName, namespaceURI) : new MyHTMLElement(localName, namespaceURI)))))))))))) : new DOMDocument.MyXMLElement(localName, namespaceURI)));
        if (prefix != null) {
            myelem.setPrefix(prefix);
        }
        return myelem;
    }

    @Override
    public Attr createAttribute(String name) throws DOMException {
        if (name == null) {
            throw new DOMException(5, "null name");
        }
        return this.createAttributeNS(null, name.toLowerCase(Locale.ROOT));
    }

    @Override
    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        DOMDocument.MyAttr my;
        if (qualifiedName == null) {
            throw new DOMException(5, "null name");
        }
        String localName = qualifiedName;
        String prefix = null;
        if (namespaceURI != null) {
            if (namespaceURI.length() != 0) {
                namespaceURI = namespaceURI.intern();
                int idx = qualifiedName.indexOf(58);
                if (idx == -1) {
                    prefix = this.lookupPrefix(namespaceURI);
                } else {
                    if (idx == qualifiedName.length() - 1) {
                        throw new DOMException(5, "Empty local name");
                    }
                    if (idx == 0) {
                        throw new DOMException(5, "Empty prefix");
                    }
                    prefix = qualifiedName.substring(0, idx).intern();
                    localName = qualifiedName.substring(idx + 1);
                }
                if (HTML_NAMESPACE_URI == namespaceURI) {
                    localName = localName.toLowerCase(Locale.ROOT);
                }
            } else {
                namespaceURI = null;
            }
        } else if (qualifiedName.indexOf(58) != -1) {
            throw new DOMException(14, "Prefix with null namespace");
        }
        if (!DOMDocument.isValidName(localName)) {
            throw new DOMException(5, "Invalid name: " + localName);
        }
        if (namespaceURI == null || namespaceURI == HTML_NAMESPACE_URI) {
            my = "class".equals(localName) ? new DOMDocument.ClassAttr(namespaceURI) : ("href".equals(localName) ? new HrefEventAttr(namespaceURI) : ("style".equals(localName) ? new DOMDocument.MyStyleAttr(localName) : ("media".equals(localName) || "type".equals(localName) || "crossorigin".equals(localName) ? new DOMDocument.StyleEventAttr(localName, namespaceURI) : new DOMDocument.MyAttr(localName, namespaceURI))));
        } else if ("xmlns".equals(localName)) {
            if (!"http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                throw new DOMException(14, "xmlns local name but not xmlns namespace");
            }
            my = new DOMDocument.XmlnsAttr();
        } else {
            my = "style".equals(localName) && prefix == null ? new DOMDocument.MyStyleAttr(localName) : new DOMDocument.MyAttr(localName, namespaceURI);
        }
        if (prefix != null) {
            my.setPrefix(prefix);
        }
        return my;
    }

    @Override
    boolean isHTML() {
        return true;
    }

    private boolean setBaseURL(DOMElement baseElement, String base) {
        if (!base.isEmpty()) {
            String docUri = this.getDocumentURI();
            if (docUri != null) {
                URL url;
                URI uriBase;
                URI dUri;
                try {
                    dUri = new URI(docUri);
                }
                catch (URISyntaxException e) {
                    return this.setBaseForNullDocumentURI(base, baseElement);
                }
                try {
                    uriBase = new URI(base);
                    uriBase = dUri.resolve(uriBase);
                    if (!uriBase.isAbsolute()) {
                        this.getErrorHandler().nodeError(baseElement, "Cannot convert URI to absolute: " + base, null);
                        return false;
                    }
                    url = uriBase.toURL();
                }
                catch (MalformedURLException e) {
                    this.getErrorHandler().ioError(base, e);
                    return false;
                }
                catch (Exception e) {
                    this.getErrorHandler().nodeError(baseElement, "Cannot convert URI to absolute: " + base, e);
                    return false;
                }
                String docscheme = dUri.getScheme();
                String bscheme = uriBase.getScheme();
                if (!(docscheme.equals(bscheme) || bscheme.equals("https") || bscheme.equals("http") || docscheme.equals("file") || docscheme.equals("jar"))) {
                    this.getErrorHandler().policyError(baseElement, "Remote document wants to set a non-http base URL: " + uriBase.toASCIIString());
                    return false;
                }
                this.baseURL = url;
                return true;
            }
            return this.setBaseForNullDocumentURI(base, baseElement);
        }
        return false;
    }

    private boolean setBaseForNullDocumentURI(String base, DOMElement baseElement) {
        try {
            URI uriBase = new URI(base);
            String scheme = uriBase.getScheme();
            if ((scheme.equals("https") || scheme.equals("http")) && uriBase.isAbsolute()) {
                this.baseURL = uriBase.toURL();
                return true;
            }
            this.getErrorHandler().policyError(baseElement, "Untrusted document wants to set a non-http or relative base URL: " + base);
        }
        catch (Exception e) {
            this.getErrorHandler().nodeError(baseElement, "Cannot convert URI to absolute: " + base, e);
        }
        return false;
    }

    @Override
    public URL getBaseURL() {
        if (this.baseURL == null) {
            String s;
            DOMElement base;
            DOMElement head;
            Iterator<DOMElement> baseIt;
            HTMLElement root = this.getDocumentElement();
            Iterator<DOMElement> headIt = root.elementIterator("head");
            if (headIt.hasNext() && (baseIt = (head = headIt.next()).elementIterator("base")).hasNext() && this.setBaseURL(base = baseIt.next(), s = base.getAttribute("href"))) {
                return this.baseURL;
            }
            String docUri = this.getDocumentURI();
            if (docUri != null) {
                try {
                    this.baseURL = new URI(docUri).toURL();
                }
                catch (Exception e) {
                    this.getErrorHandler().nodeError(this, "Cannot convert URI to absolute: " + docUri, e);
                }
            }
        }
        return this.baseURL;
    }

    @Override
    public String getBaseURI() {
        URL url = this.getBaseURL();
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        super.setDocumentURI(documentURI);
        this.baseURL = null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return HTML_NAMESPACE_URI.equals(namespaceURI);
    }

    @Override
    DOMDocument.LinkStyleDefiner getEmbeddedStyleDefiner(DOMElement element) {
        if (element != null) {
            return element instanceof DOMDocument.LinkStyleDefiner ? (DOMDocument.LinkStyleDefiner)((Object)element) : null;
        }
        return null;
    }

    ElementList getLinkedStyleNodeList() {
        return this.getElementsByTagName("link");
    }

    ElementList getEmbeddedStyleNodeList() {
        HTMLElement docElm = this.getDocumentElement();
        ElementList list = docElm != null ? docElm.getElementsByTagNameNS("*", "style") : EmptyElementList.getInstance();
        return list;
    }

    static {
        String[] rawText = new String[]{"listing", "plaintext", "pre", "script", "textarea", "xmp"};
        Collections.addAll(rawTextElementsExceptStyle, rawText);
    }

    private class LinkElement
    extends MyHTMLElement
    implements DOMDocument.LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        LinkElement(String namespaceURI) {
            super("link", namespaceURI);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getLinkedSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new LinkElement(this.getNamespaceURI()), deep);
        }
    }

    private class StyleElement
    extends MyHTMLElement
    implements DOMDocument.LinkStyleDefiner {
        private static final long serialVersionUID = 2L;
        private final StyleDefinerElementHelper helper;

        StyleElement(String namespaceURI) {
            super("style", namespaceURI);
            this.helper = new StyleDefinerElementHelper(this);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public AbstractCSSStyleSheet getSheet() {
            return this.helper.getInlineSheet();
        }

        @Override
        public void resetSheet() {
            this.helper.resetSheet();
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            super.setParentNode(parentNode);
            HTMLDocument.this.onSheetModify();
        }

        @Override
        void postInsertChild(AbstractDOMNode newChild) {
            super.postInsertChild(newChild);
            this.helper.postAddChildInline(newChild);
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void setTextContent(String textContent) throws DOMException {
            super.setTextContent(textContent);
            this.resetSheet();
            this.getSheet();
        }

        @Override
        public void normalize() {
            if (!this.helper.containsCSS()) {
                super.normalize();
            } else {
                AbstractCSSStyleSheet sheet = this.getSheet();
                if (sheet != null) {
                    super.setTextContent(sheet.toString());
                } else {
                    super.normalize();
                }
            }
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new StyleElement(this.getNamespaceURI()), deep);
        }
    }

    private class MetaElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        MetaElement() {
            super("meta");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            if (parentNode == null) {
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaRemoved(name, this.getAttribute("content"));
                super.setParentNode(null);
            } else {
                short type = parentNode.getNodeType();
                if (HTMLDocument.this.getStrictErrorChecking() && type != 11 && (type != 1 || !this.isValidContext(parentNode))) {
                    String msg = "A <meta> tag without the proper attributes can occur only in the head or noscript element, not in " + parentNode.getNodeName() + ".\nDisable strict error checking to avoid this error.";
                    throw new DOMHierarchyRequestException(msg);
                }
                super.setParentNode(parentNode);
                String name = this.getAttribute("http-equiv");
                if (name.length() == 0) {
                    name = this.getAttribute("name");
                }
                this.getOwnerDocument().onMetaAdded(name, this.getAttribute("content"));
            }
        }

        private boolean isValidContext(Node parentNode) {
            String parentTag = parentNode.getNodeName();
            return "head".equals(parentTag) || "noscript".equals(parentTag) || this.hasAttribute("itemprop") || this.hasAttribute("name");
        }
    }

    private class BaseElement
    extends MetacontentElement {
        private static final long serialVersionUID = 2L;

        BaseElement() {
            super("base");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            if (parentNode != null) {
                super.setParentNode(parentNode);
                if (HTMLDocument.this.getStrictErrorChecking() && parentNode.getNodeType() == 1) {
                    for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                        if (node.getNodeType() != 1 || !"base".equals(node.getNodeName()) || node == this) continue;
                        throw new DOMHierarchyRequestException("A document can have only one base element.\nDisable strict error checking to avoid this error.");
                    }
                }
                this.getOwnerDocument().baseURL = null;
            } else {
                this.getOwnerDocument().baseURL = null;
                super.setParentNode(parentNode);
            }
        }
    }

    private class MetacontentElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        MetacontentElement(String tagName) {
            super(tagName);
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            if (parentNode != null) {
                short type = parentNode.getNodeType();
                if (HTMLDocument.this.getStrictErrorChecking() && type != 11 && (type != 1 || !"head".equals(parentNode.getNodeName()) && !"noscript".equals(parentNode.getNodeName()))) {
                    String msg = "A <" + this.getNodeName() + "> tag can occur only in a head or noscript element, not in " + parentNode.toString() + ".\nDisable strict error checking to avoid this error.";
                    throw new DOMHierarchyRequestException(msg);
                }
            }
            super.setParentNode(parentNode);
        }
    }

    private class HtmlRootElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        private HtmlRootElement() {
            super("html");
        }

        @Override
        void setParentNode(AbstractDOMNode parentNode) throws DOMException {
            short type;
            if (parentNode != null && (type = parentNode.getNodeType()) != 9 && type != 11) {
                throw new DOMHierarchyRequestException("A <html> tag cannot be added here.");
            }
            super.setParentNode(parentNode);
        }

        @Override
        void preInsertChild(Node newChild, Node refNode) {
            String nname;
            super.preInsertChild(newChild, refNode);
            if (newChild.getNodeType() == 1 && ("head".equals(nname = newChild.getNodeName()) || "body".equals(nname))) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals(nname)) continue;
                    throw new DOMHierarchyRequestException("<html> already has a " + nname + " child.");
                }
            }
        }

        @Override
        void preReplaceChild(AbstractDOMNode newChild, AbstractDOMNode replaced) {
            String rname;
            String nname;
            super.preInsertChild(newChild, replaced);
            if (newChild.getNodeType() == 1 && !(nname = newChild.getNodeName()).equalsIgnoreCase(rname = replaced.getNodeName()) && ("head".equals(nname) || "body".equals(nname))) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getNodeType() != 1 || !node.getNodeName().equals(nname)) continue;
                    throw new DOMHierarchyRequestException("<html> already has a " + nname + " child.");
                }
            }
        }
    }

    private class ImgElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        ImgElement() {
            super("img");
        }

        @Override
        boolean isNonHTMLOrVoid() {
            return true;
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("border") || this.hasAttribute("hspace") || this.hasAttribute("vspace");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.hspace(this.getAttribute("hspace"), style);
            AttributeToStyle.vspace(this.getAttribute("vspace"), style);
            if (AttributeToStyle.border(this.getAttribute("border"), style)) {
                style.setProperty("border-top-style", "solid", null);
                style.setProperty("border-right-style", "solid", null);
                style.setProperty("border-bottom-style", "solid", null);
                style.setProperty("border-left-style", "solid", null);
            }
        }
    }

    private class FontElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        FontElement() {
            super("font");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("face") || this.hasAttribute("size") || this.hasAttribute("color");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.face(this.getAttribute("face"), style);
            AttributeToStyle.size(this.getAttribute("size"), style);
            AttributeToStyle.color(this.getAttribute("color"), style);
        }
    }

    private class TableElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableElement() {
            super("table");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("cellspacing") || this.hasAttribute("border") || this.hasAttribute("bordercolor") || this.hasAttribute("bgcolor") || this.hasAttribute("background");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.cellSpacing(this.getAttribute("cellspacing"), style);
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.border(this.getAttribute("border"), style);
            AttributeToStyle.borderColor(this.getAttribute("bordercolor"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
        }
    }

    private class TableRowElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableRowElement() {
            super("tr");
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
            AttributeToStyle.align(this.getAttribute("align"), style);
        }
    }

    private class TableCellElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        TableCellElement(String localName) {
            super(localName);
        }

        TableCellElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public boolean hasPresentationalHints() {
            return this.hasAttribute("bgcolor") || this.hasAttribute("width") || this.hasAttribute("height") || this.hasAttribute("background") || this.hasAttribute("align");
        }

        @Override
        public void exportHintsToStyle(CSSStyleDeclaration style) {
            AttributeToStyle.bgcolor(this.getAttribute("bgcolor"), style);
            AttributeToStyle.width(this.getAttribute("width"), style);
            AttributeToStyle.height(this.getAttribute("height"), style);
            AttributeToStyle.background(this.getAttribute("background"), style);
            AttributeToStyle.align(this.getAttribute("align"), style);
        }
    }

    private class RawTextElement
    extends MyHTMLElement {
        private static final long serialVersionUID = 2L;

        RawTextElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        boolean isRawText() {
            return true;
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new RawTextElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }
    }

    private class MyHTMLElement
    extends HTMLElement {
        private static final long serialVersionUID = 2L;

        MyHTMLElement(String localName) {
            this(localName, HTMLDocument.HTML_NAMESPACE_URI);
        }

        MyHTMLElement(String localName, String namespaceURI) {
            super(localName, namespaceURI);
        }

        @Override
        public void setId(String id) {
            this.setAttribute("id", id);
        }

        @Override
        public boolean isDefaultNamespace(String namespaceURI) {
            return HTMLDocument.this.isDefaultNamespace(namespaceURI);
        }

        @Override
        public HTMLDocument getOwnerDocument() {
            return HTMLDocument.this;
        }

        @Override
        protected BaseCSSStyleSheetFactory getStyleSheetFactory() {
            return HTMLDocument.this.getStyleSheetFactory();
        }

        @Override
        public String getBaseURI() {
            return HTMLDocument.this.getBaseURI();
        }

        @Override
        public HTMLElement cloneNode(boolean deep) {
            return this.cloneElementNode(new MyHTMLElement(this.getLocalName(), this.getNamespaceURI()), deep);
        }

        HTMLElement cloneElementNode(MyHTMLElement my, boolean deep) {
            for (Attr attr : this.nodeMap.getNodeList()) {
                DOMAttr myattr = (DOMAttr)attr.cloneNode(deep);
                myattr.specified = attr.getSpecified();
                my.setAttributeNode(myattr);
            }
            if (deep) {
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    my.appendChild(node.cloneNode(true));
                }
            }
            MyHTMLElement.callUserHandlers((short)1, this, my);
            return my;
        }
    }

    private class HrefEventAttr
    extends DOMDocument.EventAttr {
        private static final long serialVersionUID = 2L;

        HrefEventAttr(String namespaceURI) {
            super("href", namespaceURI);
        }

        @Override
        void onAttributeRemoval() {
            DOMElement owner = this.getOwnerElement();
            String tagname = owner.getTagName();
            if ("base".equals(tagname)) {
                if (owner.isDocumentDescendant()) {
                    HTMLDocument doc = (HTMLDocument)this.getOwnerDocument();
                    doc.baseURL = null;
                    doc.onBaseModify();
                }
            } else if ("link".equals(tagname)) {
                ((LinkElement)owner).resetSheet();
            }
        }

        @Override
        void onDOMChange(DOMElement owner) {
            String tagname = owner.getTagName();
            if ("link".equals(tagname)) {
                ((LinkElement)owner).resetSheet();
            } else if ("base".equals(tagname)) {
                HTMLDocument doc = (HTMLDocument)this.getOwnerDocument();
                String value = this.getValue();
                if (owner.isDocumentDescendant()) {
                    if (!HTMLDocument.this.setBaseURL(owner, value)) {
                        doc.baseURL = null;
                    }
                    HTMLDocument.this.onBaseModify();
                }
            }
        }
    }
}

