/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportCompactColonyPanel
extends ReportPanel {
    private static final Predicate<Unit> notWorkingPred = u -> u.getState() != Unit.UnitState.FORTIFIED && u.getState() != Unit.UnitState.SENTRY;
    private static final Predicate<GoodsType> reportGoodsPred = gt -> gt.isStorable() && !gt.isTradeGoods() || gt.isLibertyType();
    private static final String BUILDQUEUE = "buildQueue.";
    private static final String cAlarmKey = "color.report.colony.alarm";
    private static final String cWarnKey = "color.report.colony.warning";
    private static final String cPlainKey = "color.report.colony.plain";
    private static final String cExportKey = "color.report.colony.export";
    private static final String cGoodKey = "color.report.colony.good";
    private static Color cAlarm = null;
    private static Color cWarn;
    private static Color cPlain;
    private static Color cExport;
    private static Color cGood;
    private final Specification spec;
    private final ImageLibrary lib;
    private final List<List<Colony>> colonies = new ArrayList<List<Colony>>();
    private final Market market;
    private final List<GoodsType> goodsTypes = new ArrayList<GoodsType>();

    public ReportCompactColonyPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportColonyAction");
        this.spec = this.getSpecification();
        this.lib = this.getImageLibrary();
        Player player = this.getMyPlayer();
        this.market = player.getMarket();
        HashMap continents = new HashMap();
        for (Colony c : player.getColonyList()) {
            if (c.getUnitCount() <= 0) continue;
            CollectionUtils.appendToMapList(continents, c.getTile().getContiguity(), c);
        }
        Comparator<Colony> colonyComparator = freeColClient.getClientOptions().getColonyComparator();
        Comparator<List> firstColonyComparator = Comparator.comparing(l -> (Colony)CollectionUtils.first(l), colonyComparator);
        this.colonies.addAll(CollectionUtils.sort(continents.values(), firstColonyComparator));
        this.goodsTypes.addAll(CollectionUtils.transform(this.spec.getGoodsTypeList(), reportGoodsPred, Function.identity(), GoodsType.goodsTypeComparator));
        this.loadResources();
        this.update();
    }

    private synchronized void loadResources() {
        if (cAlarm != null) {
            return;
        }
        cAlarm = ImageLibrary.getColor(cAlarmKey, Color.RED);
        cWarn = ImageLibrary.getColor(cWarnKey, Color.MAGENTA);
        cPlain = ImageLibrary.getColor(cPlainKey, Color.DARK_GRAY);
        cExport = ImageLibrary.getColor(cExportKey, Color.GREEN);
        cGood = ImageLibrary.getColor(cGoodKey, Color.BLUE);
    }

    private static StringTemplate stpl(String messageId) {
        return Messages.containsKey(messageId) ? StringTemplate.template(messageId) : null;
    }

    private static StringTemplate stpld(String messageId) {
        messageId = Messages.descriptionKey(messageId);
        return ReportCompactColonyPanel.stpl(messageId);
    }

    private JLabel newLabel(String h, ImageIcon i, Color c) {
        JLabel l = new JLabel(h, i, 0);
        l.setForeground(c == null ? Color.BLACK : c);
        return l;
    }

    private JLabel newLabel(String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null && Messages.containsKey(h)) {
            h = Messages.message(h);
        }
        JLabel l = this.newLabel(h, i, c);
        if (t != null) {
            Utility.localizeToolTip((JComponent)l, t);
        }
        return l;
    }

    private JButton newButton(String action, String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null && Messages.containsKey(h)) {
            h = Messages.message(h);
        }
        JButton b = Utility.getLinkButton(h, i, action);
        b.setForeground(c == null ? Color.BLACK : c);
        if (t != null) {
            Utility.localizeToolTip((JComponent)b, t);
        }
        b.addActionListener(this);
        return b;
    }

    private void addTogether(List<? extends JComponent> components) {
        if (components.isEmpty()) {
            this.reportPanel.add(new JLabel());
            return;
        }
        String layout = components.size() > 1 ? "split " + components.size() : null;
        for (JComponent jComponent : components) {
            this.reportPanel.add((Component)jComponent, layout);
            layout = null;
        }
    }

    private void updateColony(ColonySummary s) {
        Object key;
        String cac = s.colony.getId();
        UnitType defaultUnitType = this.spec.getDefaultUnitType(s.colony.getOwner());
        ArrayList<JComponent> buttons = new ArrayList<JComponent>(16);
        Color c = s.bonus <= -2 ? cAlarm : (s.bonus == -1 ? cWarn : (s.bonus == 0 ? cPlain : (s.bonus == 1 ? cExport : cGood)));
        Object annotations = "";
        StringTemplate t = StringTemplate.label(",");
        Building building = s.colony.getStockade();
        if (building == null) {
            key = "annotation.unfortified";
            t.add(Messages.message("report.colony.annotation.unfortified"));
        } else {
            key = "annotation." + building.getType().getSuffix();
            t.add(Messages.message(building.getLabel()));
        }
        if (ResourceManager.getStringResource((String)key, false) != null) {
            annotations = (String)annotations + ResourceManager.getString((String)key);
        }
        if (!s.colony.getTile().isCoastland()) {
            key = "annotation.inland";
            t.add(Messages.message("report.colony.annotation.inland"));
        } else {
            building = s.colony.getWorkLocationWithAbility("model.ability.produceInWater", Building.class);
            if (building == null) {
                key = "annotation.coastal";
                t.add(Messages.message("report.colony.annotation.coastal"));
            } else {
                key = "annotation." + building.getType().getSuffix();
                t.add(Messages.message(building.getLabel()));
            }
        }
        if (ResourceManager.getStringResource((String)key, false) != null) {
            annotations = (String)annotations + ResourceManager.getString((String)key);
        }
        if ((building = s.colony.getWorkLocationWithAbility("model.ability.export", Building.class)) != null) {
            annotations = (String)annotations + "*";
            t.add(Messages.message(building.getLabel()));
        }
        JButton b = this.newButton(cac, s.colony.getName() + (String)annotations, null, c, (StringTemplate)((StringTemplate)StringTemplate.label(": ").add(s.colony.getName())).add(Messages.message(t)));
        if (s.famine) {
            b.setFont(b.getFont().deriveFont(1));
        }
        this.reportPanel.add((Component)b, "newline");
        c = cGood;
        t = ReportCompactColonyPanel.stpld("report.colony.size");
        this.reportPanel.add(this.newButton(cac, Integer.toString(s.unitCount), null, c, t));
        if (s.unitsToAdd > 0) {
            c = cGood;
            t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.growing").addName("%colony%", s.colony.getName())).addAmount("%amount%", s.unitsToAdd);
            b = this.newButton(cac, Integer.toString(s.unitsToAdd), null, c, t);
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        if (s.unitsToRemove > 0) {
            c = s.bonus < 0 ? cAlarm : cGood;
            t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.shrinking").addName("%colony%", s.colony.getName())).addAmount("%amount%", s.unitsToRemove);
            b = this.newButton(cac, Integer.toString(s.unitsToRemove), null, c, t);
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        int n = CollectionUtils.count(s.tileSuggestions, Colony.TileImprovementSuggestion::isExploration);
        if (n > 0) {
            t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.exploring").addName("%colony%", s.colony.getName())).addAmount("%amount%", n);
            b = this.newButton(cac, Integer.toString(n), null, cAlarm, t);
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            n = 0;
            boolean center = false;
            for (Colony.TileImprovementSuggestion tileImprovementSuggestion : s.tileSuggestions) {
                if (tileImprovementSuggestion.tileImprovementType != ti) continue;
                ++n;
                if (tileImprovementSuggestion.tile != s.colony.getTile()) continue;
                center = true;
            }
            if (n > 0) {
                c = cAlarm;
                if (n == 1) {
                    Colony.TileImprovementSuggestion tis = CollectionUtils.first(s.tileSuggestions);
                    if (CollectionUtils.any(tis.tile.getUnits(), u -> u.getState() == Unit.UnitState.IMPROVING && u.getWorkImprovement() != null && u.getWorkImprovement().getType() == tis.tileImprovementType)) {
                        c = cWarn;
                    }
                    t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix() + ".specific").addName("%colony%", s.colony.getName())).addStringTemplate("%location%", tis.tile.getColonyTileLocationLabel(s.colony));
                } else {
                    t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix()).addName("%colony%", s.colony.getName())).addAmount("%amount%", n);
                }
                b = this.newButton(cac, Integer.toString(n), null, c, t);
                if (center) {
                    b.setFont(b.getFont().deriveFont(1));
                }
            } else {
                b = null;
            }
            this.reportPanel.add(b == null ? new JLabel() : b);
        }
        for (GoodsType gt : this.goodsTypes) {
            ColonySummary.GoodsProduction gp = s.production.get(gt);
            switch (gp.status) {
                case FAIL: {
                    c = cAlarm;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.low").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", -gp.amount)).addAmount("%turns%", gp.extra);
                    break;
                }
                case BAD: {
                    c = cWarn;
                    t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount);
                    break;
                }
                case NONE: {
                    c = null;
                    t = null;
                    break;
                }
                case ZERO: {
                    c = cPlain;
                    t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount);
                    break;
                }
                case GOOD: {
                    c = cGood;
                    t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount);
                    break;
                }
                case EXPORT: {
                    c = cExport;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.export").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount)).addAmount("%export%", gp.extra);
                    break;
                }
                case EXCESS: {
                    c = cWarn;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.high").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount)).addAmount("%turns%", gp.extra);
                    break;
                }
                case OVERFLOW: {
                    c = cAlarm;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.waste").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount)).addAmount("%waste%", gp.extra);
                    break;
                }
                case PRODUCTION: {
                    c = cWarn;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.maxProduction").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount)).addAmount("%more%", gp.extra);
                    break;
                }
                case CONSUMPTION: {
                    c = cWarn;
                    t = ((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.maxConsumption").addName("%colony%", s.colony.getName())).addNamed("%goods%", gt)).addAmount("%amount%", gp.amount)).addAmount("%more%", gp.extra);
                    break;
                }
                default: {
                    throw new IllegalStateException("Bogus status: " + gp.status);
                }
            }
            this.reportPanel.add(c == null ? new JLabel() : this.newButton(cac, Integer.toString(gp.amount), null, c, t));
        }
        if (s.newColonist > 0) {
            t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.arriving").addName("%colony%", s.colony.getName())).addNamed("%unit%", defaultUnitType)).addAmount("%turns%", s.newColonist);
            b = this.newButton(cac, Integer.toString(s.newColonist), null, cGood, t);
        } else if (s.newColonist < 0) {
            c = s.famine ? cAlarm : cWarn;
            t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.starving").addName("%colony%", s.colony.getName())).addAmount("%turns%", -s.newColonist);
            b = this.newButton(cac, Integer.toString(-s.newColonist), null, c, t);
            if (s.famine) {
                b.setFont(b.getFont().deriveFont(1));
            }
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        String qac = BUILDQUEUE + cac;
        if (s.build != null) {
            int turns = s.completeTurns;
            String bname = Messages.getName(s.build);
            if (turns == Integer.MIN_VALUE) {
                t = ReportCompactColonyPanel.stpld("report.colony.making.noconstruction").addName("%colony%", s.colony.getName());
                b = this.newButton(qac, bname, null, cWarn, t);
            } else if (turns >= 0) {
                t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.constructing").addName("%colony%", s.colony.getName())).addNamed("%buildable%", s.build)).addAmount("%turns%", turns);
                b = this.newButton(qac, bname + " " + Integer.toString(turns), null, cGood, t);
            } else {
                turns = -(turns + 1);
                t = ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.blocking").addName("%colony%", s.colony.getName())).addAmount("%amount%", s.needed.getAmount())).addNamed("%goods%", s.needed.getType())).addNamed("%buildable%", s.build)).addAmount("%turns%", turns);
                b = this.newButton(qac, bname + " " + Integer.toString(turns), null, cAlarm, t);
                if (turns == 0) {
                    b.setFont(b.getFont().deriveFont(1));
                }
            }
            buttons.add(b);
        }
        int empty = 0;
        Building school = s.colony.getWorkLocationWithAbility("model.ability.teach", Building.class);
        if (school != null) {
            empty = school.getType().getWorkPlaces();
        }
        for (Map.Entry entry : CollectionUtils.mapEntriesByValue(s.teachers, CollectionUtils.descendingIntegerComparator)) {
            Unit u2 = (Unit)entry.getKey();
            ImageIcon ii = new ImageIcon(this.lib.getTinyUnitImage(u2));
            if ((Integer)entry.getValue() <= 0) {
                t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.noteach").addName("%colony%", s.colony.getName())).addStringTemplate("%teacher%", u2.getLabel(Unit.UnitLabelType.NATIONAL));
                b = this.newButton(cac, Integer.toString(0), ii, cAlarm, t);
            } else {
                t = ((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.educating").addName("%colony%", s.colony.getName())).addStringTemplate("%teacher%", u2.getLabel(Unit.UnitLabelType.NATIONAL))).addAmount("%turns%", (Number)entry.getValue());
                b = this.newButton(cac, Integer.toString((Integer)entry.getValue()), ii, cPlain, t);
            }
            buttons.add(b);
            --empty;
        }
        if (empty > 0) {
            ImageIcon emptyIcon = new ImageIcon(this.lib.getTinyUnitTypeImage(defaultUnitType, true));
            t = ((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.educationVacancy").addName("%colony%", s.colony.getName())).addAmount("%number%", empty);
            while (empty > 0) {
                buttons.add(this.newButton(cac, "", emptyIcon, cPlain, t));
                --empty;
            }
        }
        this.addTogether(buttons);
        if (s.improve.isEmpty() && s.want.isEmpty()) {
            this.reportPanel.add(new JLabel());
        } else {
            buttons.clear();
            buttons.addAll(this.unitButtons(s.improve, s.couldWork, s.colony));
            buttons.add(new JLabel("/"));
            for (UnitType unitType : s.improve.keySet()) {
                s.want.remove(unitType);
            }
            buttons.addAll(this.unitButtons(s.want, s.couldWork, s.colony));
            this.addTogether(buttons);
        }
    }

    private List<JButton> unitButtons(Map<UnitType, WorkLocation.Suggestion> suggestions, List<UnitType> have, Colony colony) {
        String cac = colony.getId();
        ArrayList<JButton> result = new ArrayList<JButton>(suggestions.size());
        Comparator<UnitType> buttonComparator = Comparator.comparing(ut -> (WorkLocation.Suggestion)suggestions.get(ut), WorkLocation.Suggestion.descendingAmountComparator);
        for (UnitType type : CollectionUtils.sort(suggestions.keySet(), buttonComparator)) {
            boolean present = have.contains(type);
            WorkLocation.Suggestion suggestion = suggestions.get(type);
            String label = Integer.toString(suggestion.amount);
            ImageIcon icon = new ImageIcon(this.lib.getTinyUnitTypeImage(type, false));
            Object tip = suggestion.oldType == null ? ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.wanting").addName("%colony%", colony.getName())).addNamed("%unit%", type)).addStringTemplate("%location%", suggestion.workLocation.getLabel())).addNamed("%goods%", suggestion.goodsType)).addAmount("%amount%", suggestion.amount) : ((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)((StringTemplate)ReportCompactColonyPanel.stpld("report.colony.improving").addName("%colony%", colony.getName())).addNamed("%oldUnit%", suggestion.oldType)).addNamed("%unit%", type)).addStringTemplate("%location%", suggestion.workLocation.getLabel())).addNamed("%goods%", suggestion.goodsType)).addAmount("%amount%", suggestion.amount);
            JButton b = this.newButton(cac, label, icon, present ? cGood : cPlain, (StringTemplate)tip);
            if (present) {
                b.setFont(b.getFont().deriveFont(1));
            }
            result.add(b);
        }
        return result;
    }

    private void updateCombinedColonies(List<ColonySummary> summaries) {
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
        HashMap rRegionMap = new HashMap();
        ArrayList<Colony.TileImprovementSuggestion> rTileSuggestions = new ArrayList<Colony.TileImprovementSuggestion>();
        int rUnitCount = 0;
        int rUnitsToAdd = 0;
        int rUnitsToRemove = 0;
        int teacherLen = 0;
        int improveLen = 0;
        double rNewColonist = 0.0;
        HashMap rProduction = new HashMap();
        HashMap<UnitType, Integer> rTeachers = new HashMap<UnitType, Integer>();
        HashMap<UnitType, Integer> rImprove = new HashMap<UnitType, Integer>();
        HashMap rNeeded = new HashMap();
        for (ColonySummary colonySummary : summaries) {
            CollectionUtils.accumulateToMap(rRegionMap, colonySummary.colony.getTile().getRegion(), 1, CollectionUtils.integerAccumulator);
            rTileSuggestions.addAll(colonySummary.tileSuggestions);
            if (colonySummary.newColonist > 0) {
                rNewColonist += (double)colonySummary.newColonist;
            }
            rUnitCount += colonySummary.unitCount;
            rUnitsToAdd += colonySummary.unitsToAdd;
            if (colonySummary.bonus < 0) {
                rUnitsToRemove += colonySummary.unitsToRemove;
            }
            CollectionUtils.accumulateMap(rProduction, colonySummary.production, ColonySummary.GoodsProduction.goodsProductionAccumulator);
            teacherLen = Math.max(teacherLen, colonySummary.teachers.size());
            for (Unit u : colonySummary.teachers.keySet()) {
                CollectionUtils.accumulateToMap(rTeachers, u.getType(), 1, CollectionUtils.integerAccumulator);
            }
            improveLen = Math.max(improveLen, colonySummary.improve.size() + colonySummary.want.size());
            for (UnitType ut : colonySummary.improve.keySet()) {
                CollectionUtils.accumulateToMap(rImprove, ut, 1, CollectionUtils.integerAccumulator);
            }
            for (UnitType ut : colonySummary.want.keySet()) {
                CollectionUtils.accumulateToMap(rImprove, ut, 1, CollectionUtils.integerAccumulator);
            }
            if (colonySummary.needed == null || !colonySummary.needed.getType().isStorable()) continue;
            CollectionUtils.accumulateToMap(rNeeded, colonySummary.needed.getType(), (double)colonySummary.needed.getAmount() / (double)colonySummary.completeTurns, CollectionUtils.doubleAccumulator);
        }
        rNewColonist = Math.round(rNewColonist / (double)summaries.size());
        StringTemplate t = ((Region)CollectionUtils.mapEntriesByValue(rRegionMap, CollectionUtils.descendingIntegerComparator).get(0).getKey()).getLabel();
        this.reportPanel.add((Component)this.newLabel(Messages.message(t), null, cPlain, ReportCompactColonyPanel.stpld("report.colony.name.summary")), "newline");
        this.reportPanel.add(this.newLabel(Integer.toString(rUnitCount), null, cGood, ReportCompactColonyPanel.stpld("report.colony.size.summary")));
        this.reportPanel.add(this.newLabel(Integer.toString(rUnitsToAdd), null, cGood, ReportCompactColonyPanel.stpld("report.colony.growing.summary")));
        this.reportPanel.add(this.newLabel(Integer.toString(rUnitsToRemove), null, rUnitsToRemove > 0 ? cAlarm : cGood, ReportCompactColonyPanel.stpld("report.colony.shrinking.summary")));
        Set tiles = CollectionUtils.transform(rTileSuggestions, Colony.TileImprovementSuggestion::isExploration, ts -> ts.tile, Collectors.toSet());
        this.reportPanel.add(tiles.isEmpty() ? new JLabel() : this.newLabel(Integer.toString(tiles.size()), null, cAlarm, ReportCompactColonyPanel.stpld("report.colony.exploring.summary")));
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            tiles.clear();
            tiles.addAll(CollectionUtils.transform(rTileSuggestions, CollectionUtils.matchKey(ti, ts -> ts.tileImprovementType), ts -> ts.tile, Collectors.toSet()));
            this.reportPanel.add(tiles.isEmpty() ? new JLabel() : this.newLabel(Integer.toString(tiles.size()), null, cAlarm, ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix() + ".summary")));
        }
        for (GoodsType gt : this.goodsTypes) {
            Color c;
            ColonySummary.GoodsProduction gp = (ColonySummary.GoodsProduction)rProduction.get(gt);
            switch (gp.status) {
                case BAD: {
                    c = cWarn;
                    break;
                }
                case NONE: {
                    c = null;
                    break;
                }
                case ZERO: {
                    c = cPlain;
                    break;
                }
                case GOOD: {
                    c = cGood;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bogus status: " + gp.status);
                }
            }
            this.reportPanel.add(c == null ? new JLabel() : this.newLabel(Integer.toString(gp.amount), null, c, (StringTemplate)ReportCompactColonyPanel.stpld("report.colony.production.summary").addNamed("%goods%", gt)));
        }
        this.reportPanel.add(this.newLabel(Integer.toString((int)rNewColonist), null, rNewColonist < 0.0 ? cWarn : cGood, ReportCompactColonyPanel.stpld("report.colony.arriving.summary")));
        List<JLabel> list = CollectionUtils.transform(CollectionUtils.mapEntriesByValue(rNeeded, CollectionUtils.descendingDoubleComparator), CollectionUtils.alwaysTrue(), e -> this.newLabel(String.format("%4.1f %s", e.getValue(), Messages.getName((Named)e.getKey())), null, cPlain, (StringTemplate)ReportCompactColonyPanel.stpld("report.colony.making.summary").addNamed("%goods%", (Named)e.getKey())));
        teacherLen = Math.max(3, teacherLen);
        list.addAll(this.unitTypeLabels(rTeachers, teacherLen, ReportCompactColonyPanel.stpld("report.colony.making.educating.summary")));
        this.addTogether(list);
        this.addTogether(this.unitTypeLabels(rImprove, improveLen, ReportCompactColonyPanel.stpld("report.colony.improving.summary")));
    }

    private List<JLabel> unitTypeLabels(Map<UnitType, Integer> unitTypeMap, int maxSize, StringTemplate t) {
        ArrayList<JLabel> result = new ArrayList<JLabel>(maxSize);
        int n = 0;
        for (Map.Entry<UnitType, Integer> e : CollectionUtils.mapEntriesByValue(unitTypeMap, CollectionUtils.descendingIntegerComparator)) {
            ImageIcon icon = new ImageIcon(this.lib.getTinyUnitTypeImage(e.getKey(), false));
            result.add(this.newLabel(Integer.toString(e.getValue()), icon, cPlain, t));
            if (++n < maxSize) continue;
            break;
        }
        return result;
    }

    private void conciseHeaders(Market market) {
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
        this.reportPanel.add((Component)this.newLabel("report.colony.name.header", null, null, ReportCompactColonyPanel.stpld("report.colony.name")), "newline");
        this.reportPanel.add(this.newLabel("report.colony.size.header", null, null, ReportCompactColonyPanel.stpld("report.colony.size")));
        this.reportPanel.add(this.newLabel("report.colony.grow.header", null, null, ReportCompactColonyPanel.stpld("report.colony.grow")));
        this.reportPanel.add(this.newLabel("report.colony.shrink.header", null, null, ReportCompactColonyPanel.stpld("report.colony.shrink")));
        this.reportPanel.add(this.newLabel("report.colony.explore.header", null, null, ReportCompactColonyPanel.stpld("report.colony.explore")));
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            String key = "report.colony.tile." + ti.getSuffix() + ".header";
            this.reportPanel.add(this.newLabel(key, null, null, ReportCompactColonyPanel.stpld(key)));
        }
        for (GoodsType gt : this.goodsTypes) {
            ImageIcon icon = new ImageIcon(this.lib.getSmallGoodsTypeImage(gt));
            JLabel l = this.newLabel(null, icon, null, (StringTemplate)ReportCompactColonyPanel.stpl("report.colony.production.header").addNamed("%goods%", gt));
            l.setEnabled(market == null || market.getArrears(gt) <= 0);
            this.reportPanel.add(l);
        }
        UnitType type = this.spec.getDefaultUnitType(this.getMyPlayer());
        ImageIcon colonistIcon = new ImageIcon(this.lib.getTinyUnitTypeImage(type));
        this.reportPanel.add(this.newLabel(null, colonistIcon, null, ReportCompactColonyPanel.stpld("report.colony.birth")));
        this.reportPanel.add(this.newLabel("report.colony.making.header", null, null, ReportCompactColonyPanel.stpld("report.colony.making")));
        this.reportPanel.add(this.newLabel("report.colony.improve.header", null, null, ReportCompactColonyPanel.stpld("report.colony.improve")));
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
    }

    private void update() {
        this.reportPanel.removeAll();
        StringBuilder sb = new StringBuilder(64);
        sb.append("[l][c][c][c]");
        for (int i = 0; i < this.goodsTypes.size(); ++i) {
            sb.append("[c]");
        }
        sb.append("[c][c][l][l][l]");
        this.reportPanel.setLayout(new MigLayout("fillx, insets 0, gap 0 0", sb.toString(), ""));
        this.conciseHeaders(this.market);
        ArrayList<ColonySummary> summaries = new ArrayList<ColonySummary>();
        for (List<Colony> cs : this.colonies) {
            summaries.clear();
            for (Colony c : cs) {
                ColonySummary s = new ColonySummary(c, this.goodsTypes);
                summaries.add(s);
                this.updateColony(s);
            }
            if (cs.size() > 1) {
                this.updateCombinedColonies(summaries);
            }
            this.conciseHeaders(this.market);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Game game = this.getGame();
        String command = ae.getActionCommand();
        if (command.startsWith(BUILDQUEUE)) {
            Colony colony = game.getFreeColGameObject(command = command.substring(BUILDQUEUE.length()), Colony.class);
            if (colony != null) {
                this.getGUI().showBuildQueuePanel(colony).addClosingCallback(() -> this.update());
                return;
            }
        } else {
            Colony colony = game.getFreeColGameObject(command, Colony.class);
            if (colony != null) {
                this.getGUI().showColonyPanel(colony, null).addClosingCallback(() -> this.update());
                return;
            }
        }
        super.actionPerformed(ae);
    }

    private static class ColonySummary {
        public final Colony colony;
        public final List<Colony.TileImprovementSuggestion> tileSuggestions = new ArrayList<Colony.TileImprovementSuggestion>();
        public final boolean famine;
        public final int newColonist;
        public final int bonus;
        public final int unitCount;
        public final int unitsToAdd;
        public final int unitsToRemove;
        public final Map<GoodsType, GoodsProduction> production = new HashMap<GoodsType, GoodsProduction>();
        public final Map<Unit, Integer> teachers = new HashMap<Unit, Integer>();
        public final List<Unit> notWorking = new ArrayList<Unit>();
        public final List<UnitType> couldWork = new ArrayList<UnitType>();
        public final Map<UnitType, WorkLocation.Suggestion> improve = new HashMap<UnitType, WorkLocation.Suggestion>();
        public final Map<UnitType, WorkLocation.Suggestion> want = new HashMap<UnitType, WorkLocation.Suggestion>();
        public final BuildableType build;
        public final int completeTurns;
        public final AbstractGoods needed;

        public ColonySummary(Colony colony, List<GoodsType> goodsTypes) {
            this.colony = colony;
            Specification spec = colony.getSpecification();
            this.tileSuggestions.clear();
            this.tileSuggestions.addAll(colony.getTileImprovementSuggestions());
            int starve = colony.getStarvationTurns();
            if (starve < 0) {
                this.famine = false;
                this.newColonist = colony.getNewColonistTurns();
            } else {
                this.famine = starve <= 3;
                this.newColonist = -starve - 1;
            }
            this.bonus = colony.getProductionBonus();
            this.unitCount = colony.getUnitCount();
            this.unitsToAdd = colony.getUnitsToAdd();
            this.unitsToRemove = colony.getUnitsToRemove();
            for (GoodsType gt : goodsTypes) {
                this.produce(gt);
            }
            this.notWorking.addAll(CollectionUtils.transform(colony.getTile().getUnits(), notWorkingPred));
            for (WorkLocation wl : CollectionUtils.transform(colony.getAvailableWorkLocations(), WorkLocation::canBeWorked)) {
                if (wl.canTeach()) {
                    for (Unit u2 : wl.getUnitList()) {
                        this.teachers.put(u2, u2.getNeededTurnsOfTraining() - u2.getTurnsOfTraining());
                    }
                    continue;
                }
                this.notWorking.addAll(CollectionUtils.transform(wl.getUnits(), u -> u.getTeacher() == null && u.getWorkType() == null));
                CollectionUtils.forEachMapEntry(wl.getSuggestions(), e -> this.addSuggestion(e.getKey() == null ? this.want : this.improve, spec.getExpertForProducing(((WorkLocation.Suggestion)e.getValue()).goodsType), (WorkLocation.Suggestion)e.getValue()));
            }
            Predicate<Unit> couldWorkPred = u -> {
                WorkLocation wl = u.getWorkLocation();
                return wl != null && (wl.getWorkFor((Unit)u) == null || wl.getWorkFor((Unit)u) != u.getWorkType());
            };
            this.couldWork.addAll(CollectionUtils.transform(this.notWorking, couldWorkPred, Unit::getType));
            this.build = colony.getCurrentlyBuilding();
            if (this.build == null) {
                this.completeTurns = -1;
                this.needed = null;
            } else {
                AbstractGoods needed = new AbstractGoods();
                this.completeTurns = colony.getTurnsToComplete(this.build, needed);
                this.needed = this.completeTurns < 0 ? needed : null;
            }
        }

        private void produce(GoodsType goodsType) {
            ProductionStatus status;
            ExportData exportData = this.colony.getExportData(goodsType);
            int adjustment = this.colony.getWarehouseCapacity() / 100;
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = this.colony.getGoodsCount(goodsType);
            int p = this.colony.getAdjustedNetProductionOf(goodsType);
            int extra = 0;
            if (p < 0) {
                status = amount < low ? ProductionStatus.FAIL : ProductionStatus.BAD;
                extra = -amount / p + 1;
            } else if (p == 0 && !this.colony.isProducing(goodsType)) {
                status = this.colony.isConsuming(goodsType) ? ProductionStatus.FAIL : ProductionStatus.NONE;
            } else if (p == 0) {
                status = ProductionStatus.ZERO;
                extra = 0;
                AbstractGoods deficit = null;
                for (WorkLocation wl : this.colony.getWorkLocationsForProducing(goodsType)) {
                    ProductionInfo pi = this.colony.getProductionInfo(wl);
                    if (pi == null || (deficit = CollectionUtils.find(pi.getConsumptionDeficit(), AbstractGoods.matches(goodsType))) == null) continue;
                    status = ProductionStatus.CONSUMPTION;
                    extra = deficit.getAmount();
                    break;
                }
            } else if (exportData.getExported()) {
                status = ProductionStatus.EXPORT;
                extra = exportData.getExportLevel();
            } else if (goodsType.limitIgnored()) {
                status = ProductionStatus.GOOD;
            } else if (amount + p > this.colony.getWarehouseCapacity()) {
                status = ProductionStatus.OVERFLOW;
                extra = amount + p - this.colony.getWarehouseCapacity();
            } else if (amount >= high) {
                status = ProductionStatus.EXCESS;
                extra = (this.colony.getWarehouseCapacity() - amount) / p;
            } else {
                status = ProductionStatus.GOOD;
                extra = 0;
                AbstractGoods deficit = null;
                for (WorkLocation wl : this.colony.getWorkLocationsForProducing(goodsType)) {
                    ProductionInfo pi = this.colony.getProductionInfo(wl);
                    if (pi == null || (deficit = CollectionUtils.find(pi.getProductionDeficit(), AbstractGoods.matches(goodsType))) == null) continue;
                    status = ProductionStatus.PRODUCTION;
                    extra = deficit.getAmount();
                    break;
                }
            }
            this.production.put(goodsType, new GoodsProduction(p, status, extra));
        }

        private void addSuggestion(Map<UnitType, WorkLocation.Suggestion> suggestions, UnitType expert, WorkLocation.Suggestion suggestion) {
            if (suggestion == null || expert == null) {
                return;
            }
            WorkLocation.Suggestion now = suggestions.get(expert);
            if (now == null || now.amount < suggestion.amount) {
                suggestions.put(expert, suggestion);
            }
        }

        public static class GoodsProduction {
            public static final BinaryOperator<GoodsProduction> goodsProductionAccumulator = (g1, g2) -> g1.accumulate((GoodsProduction)g2);
            public int amount;
            public ProductionStatus status;
            public int extra;

            public GoodsProduction(int amount, ProductionStatus status, int extra) {
                this.amount = amount;
                this.status = status;
                this.extra = extra;
            }

            public GoodsProduction accumulate(GoodsProduction other) {
                this.amount += other.amount;
                this.status = this.status == ProductionStatus.NONE && other.status == ProductionStatus.NONE ? ProductionStatus.NONE : (this.amount < 0 ? ProductionStatus.BAD : (this.amount > 0 ? ProductionStatus.GOOD : ProductionStatus.ZERO));
                this.extra = 0;
                return this;
            }
        }

        public static enum ProductionStatus {
            FAIL,
            BAD,
            NONE,
            ZERO,
            GOOD,
            EXPORT,
            EXCESS,
            OVERFLOW,
            PRODUCTION,
            CONSUMPTION;

        }
    }
}

