/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.RouteTable;
import com.amazonaws.services.ec2.model.transform.PropagatingVgwStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.RouteStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.RouteTableAssociationStaxUnmarshaller;
import com.amazonaws.services.ec2.model.transform.TagStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class RouteTableStaxUnmarshaller
implements Unmarshaller<RouteTable, StaxUnmarshallerContext> {
    private static RouteTableStaxUnmarshaller instance;

    public RouteTable unmarshall(StaxUnmarshallerContext context) throws Exception {
        RouteTable routeTable = new RouteTable();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return routeTable;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("routeTableId", targetDepth)) {
                    routeTable.setRouteTableId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcId", targetDepth)) {
                    routeTable.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeSet/item", targetDepth)) {
                    routeTable.getRoutes().add(RouteStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("associationSet/item", targetDepth)) {
                    routeTable.getAssociations().add(RouteTableAssociationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("tagSet/item", targetDepth)) {
                    routeTable.getTags().add(TagStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("propagatingVgwSet/item", targetDepth)) continue;
                routeTable.getPropagatingVgws().add(PropagatingVgwStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return routeTable;
    }

    public static RouteTableStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RouteTableStaxUnmarshaller();
        }
        return instance;
    }
}

