/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.events;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.events.ExecutionEvent;
import org.openhab.core.automation.events.TimerEvent;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={EventFactory.class}, immediate=true)
public class AutomationEventFactory
extends AbstractEventFactory {
    private static final String MODULE_IDENTIFIER = "{moduleId}";
    private static final String TIMER_EVENT_TOPIC = "openhab/timer/{moduleId}/triggered";
    private static final String EXECUTION_EVENT_TOPIC = "openhab/execution/{moduleId}/triggered";
    private final Logger logger = LoggerFactory.getLogger(AutomationEventFactory.class);
    private static final Set<String> SUPPORTED_TYPES = Set.of(TimerEvent.TYPE, ExecutionEvent.TYPE);

    public AutomationEventFactory() {
        super(SUPPORTED_TYPES);
    }

    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        this.logger.trace("creating ruleEvent of type: {}", (Object)eventType);
        if (TimerEvent.TYPE.equals(eventType)) {
            return this.createTimerEvent(topic, payload, Objects.requireNonNullElse(source, "<unknown>"));
        }
        if (ExecutionEvent.TYPE.equals(eventType)) {
            if (source == null) {
                throw new IllegalArgumentException("'source' must not be null for execution events");
            }
            return this.createExecutionEvent(topic, payload, source);
        }
        throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
    }

    private Event createTimerEvent(String topic, String payload, String source) {
        return new TimerEvent(topic, payload, source);
    }

    private Event createExecutionEvent(String topic, String payload, String source) {
        return new ExecutionEvent(topic, payload, source);
    }

    public static TimerEvent createTimerEvent(String moduleId, @Nullable String label, Map<String, Object> configuration) {
        String topic = TIMER_EVENT_TOPIC.replace(MODULE_IDENTIFIER, moduleId);
        String payload = AutomationEventFactory.serializePayload(configuration);
        return new TimerEvent(topic, payload, label);
    }

    public static ExecutionEvent createExecutionEvent(String moduleId, @Nullable Map<String, Object> payload, String source) {
        String topic = EXECUTION_EVENT_TOPIC.replace(MODULE_IDENTIFIER, moduleId);
        String serializedPayload = AutomationEventFactory.serializePayload(Objects.requireNonNullElse(payload, Map.of()));
        return new ExecutionEvent(topic, serializedPayload, source);
    }
}

