/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script;

import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptDependencyTracker;
import org.openhab.core.automation.module.script.ScriptEngineContainer;
import org.openhab.core.automation.module.script.ScriptEngineManager;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionBuilder;
import org.openhab.core.config.core.ConfigDescriptionProvider;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigOptionProvider;
import org.openhab.core.config.core.ConfigParser;
import org.openhab.core.config.core.ParameterOption;
import org.openhab.core.transform.Transformation;
import org.openhab.core.transform.TransformationException;
import org.openhab.core.transform.TransformationRegistry;
import org.openhab.core.transform.TransformationService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(factory="org.openhab.core.automation.module.script.transformation.factory", service={TransformationService.class, ScriptTransformationService.class, ScriptDependencyTracker.Listener.class, ConfigOptionProvider.class, ConfigDescriptionProvider.class})
public class ScriptTransformationService
implements TransformationService,
ScriptDependencyTracker.Listener,
ConfigOptionProvider,
ConfigDescriptionProvider,
RegistryChangeListener<Transformation> {
    public static final String SCRIPT_TYPE_PROPERTY_NAME = "openhab.transform.script.scriptType";
    public static final String OPENHAB_TRANSFORMATION_SCRIPT = "openhab-transformation-script-";
    private static final URI CONFIG_DESCRIPTION_TEMPLATE_URI = URI.create("profile:transform:SCRIPT");
    private static final Pattern INLINE_SCRIPT_CONFIG_PATTERN = Pattern.compile("\\|(?<inlineScript>.+)");
    private static final Pattern SCRIPT_CONFIG_PATTERN = Pattern.compile("(?<scriptUid>.+?)(\\?(?<params>.*?))?");
    private final Logger logger = LoggerFactory.getLogger(ScriptTransformationService.class);
    private final String scriptType;
    private final URI profileConfigUri;
    private final Map<String, ScriptRecord> scriptCache = new ConcurrentHashMap<String, ScriptRecord>();
    private final TransformationRegistry transformationRegistry;
    private final ScriptEngineManager scriptEngineManager;
    private final ConfigDescriptionRegistry configDescRegistry;

    @Activate
    public ScriptTransformationService(@Reference TransformationRegistry transformationRegistry, @Reference ConfigDescriptionRegistry configDescRegistry, @Reference ScriptEngineManager scriptEngineManager, Map<String, Object> config) {
        String scriptType = (String)ConfigParser.valueAs((Object)config.get(SCRIPT_TYPE_PROPERTY_NAME), String.class);
        if (scriptType == null) {
            throw new IllegalStateException("'openhab.transform.script.scriptType' must not be null in service configuration");
        }
        this.transformationRegistry = transformationRegistry;
        this.configDescRegistry = configDescRegistry;
        this.scriptEngineManager = scriptEngineManager;
        this.scriptType = scriptType;
        this.profileConfigUri = URI.create("profile:transform:" + scriptType.toUpperCase());
        transformationRegistry.addRegistryChangeListener((RegistryChangeListener)this);
    }

    @Deactivate
    public void deactivate() {
        this.transformationRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.scriptCache.values().forEach(this::disposeScriptRecord);
    }

    public @Nullable String transform(String function, String source) throws TransformationException {
        Object scriptUid;
        String inlineScript = null;
        String params = null;
        Matcher configMatcher = INLINE_SCRIPT_CONFIG_PATTERN.matcher(function);
        if (configMatcher.matches()) {
            inlineScript = configMatcher.group("inlineScript");
            scriptUid = "|" + Integer.toString(inlineScript.hashCode());
        } else {
            configMatcher = SCRIPT_CONFIG_PATTERN.matcher(function);
            if (!configMatcher.matches()) {
                throw new TransformationException("Invalid syntax for the script transformation: '" + function + "'");
            }
            scriptUid = configMatcher.group("scriptUid");
            params = configMatcher.group("params");
        }
        ScriptRecord scriptRecord = Objects.requireNonNull(this.scriptCache.computeIfAbsent((String)scriptUid, k -> new ScriptRecord()));
        scriptRecord.lock.lock();
        try {
            ScriptEngine scriptEngine;
            ScriptEngineContainer scriptEngineContainer;
            if (scriptRecord.script.isBlank()) {
                if (inlineScript != null) {
                    scriptRecord.script = inlineScript;
                } else {
                    Transformation transformation = (Transformation)this.transformationRegistry.get(scriptUid);
                    if (transformation != null) {
                        scriptRecord.script = transformation.getConfiguration().getOrDefault("function", "");
                    }
                }
                if (scriptRecord.script.isBlank()) {
                    throw new TransformationException("Could not get script for UID '" + (String)scriptUid + "'.");
                }
                this.scriptCache.put((String)scriptUid, scriptRecord);
            }
            if (!this.scriptEngineManager.isSupported(this.scriptType)) {
                this.clearCache((String)scriptUid);
                throw new TransformationException("Script type '" + this.scriptType + "' is not supported by any available script engine.");
            }
            if (scriptRecord.scriptEngineContainer == null) {
                scriptRecord.scriptEngineContainer = this.scriptEngineManager.createScriptEngine(this.scriptType, OPENHAB_TRANSFORMATION_SCRIPT + (String)scriptUid);
            }
            if ((scriptEngineContainer = scriptRecord.scriptEngineContainer) == null) {
                throw new TransformationException("Failed to create script engine container for '" + function + "'.");
            }
            CompiledScript compiledScript = scriptRecord.compiledScript;
            ScriptEngine engine = compiledScript != null ? compiledScript.getEngine() : scriptEngineContainer.getScriptEngine();
            ScriptContext executionContext = engine.getContext();
            executionContext.setAttribute("input", source, 100);
            ArrayList<String> injectedParams = null;
            if (params != null) {
                injectedParams = new ArrayList<String>();
                String[] stringArray = params.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String param2 = stringArray[n2];
                    String[] splitString = param2.split("=");
                    if (splitString.length != 2) {
                        this.logger.warn("Parameter '{}' does not consist of two parts for configuration UID {}, skipping.", (Object)param2, scriptUid);
                    } else {
                        param2 = URLDecoder.decode(splitString[0], StandardCharsets.UTF_8);
                        String value = URLDecoder.decode(splitString[1], StandardCharsets.UTF_8);
                        executionContext.setAttribute(param2, value, 100);
                        injectedParams.add(param2);
                    }
                    ++n2;
                }
            }
            if (compiledScript == null && (scriptEngine = scriptEngineContainer.getScriptEngine()) instanceof Compilable) {
                Compilable scriptEngine2 = (Compilable)((Object)scriptEngine);
                scriptRecord.compiledScript = compiledScript = scriptEngine2.compile(scriptRecord.script);
            }
            try {
                String string;
                Object result = compiledScript != null ? compiledScript.eval() : engine.eval(scriptRecord.script);
                String string2 = string = result == null ? null : result.toString();
                if (injectedParams != null) {
                    injectedParams.forEach(param -> {
                        Object object = executionContext.removeAttribute((String)param, 100);
                    });
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (injectedParams != null) {
                        injectedParams.forEach(param -> {
                            Object object = executionContext.removeAttribute((String)param, 100);
                        });
                    }
                    throw throwable;
                }
                catch (ScriptException e) {
                    throw new TransformationException("Failed to execute script.", (Throwable)e);
                }
                catch (IllegalStateException e) {
                    if ("The Context is already closed.".equals(e.getMessage())) {
                        this.logger.warn("Script engine context {} is already closed, this should not happen. Recreating script engine.", scriptUid);
                        this.scriptCache.remove(scriptUid);
                        String string = this.transform(function, source);
                        scriptRecord.lock.unlock();
                        return string;
                    }
                    throw e;
                }
            }
        }
        finally {
            scriptRecord.lock.unlock();
        }
    }

    public void added(Transformation element) {
        this.clearCache(element.getUID());
    }

    public void removed(Transformation element) {
        this.clearCache(element.getUID());
    }

    public void updated(Transformation oldElement, Transformation element) {
        this.clearCache(element.getUID());
    }

    public @Nullable Collection<ParameterOption> getParameterOptions(URI uri, String param, @Nullable String context, @Nullable Locale locale) {
        if (!uri.equals(this.profileConfigUri)) {
            return null;
        }
        if ("toHandlerScript".equals(param) || "toItemScript".equals(param) || "commandFromItemScript".equals(param) || "stateFromItemScript".equals(param)) {
            return this.transformationRegistry.getTransformations(List.of(this.scriptType.toLowerCase())).stream().map(c -> new ParameterOption(c.getUID(), c.getLabel())).toList();
        }
        return null;
    }

    public Collection<ConfigDescription> getConfigDescriptions(@Nullable Locale locale) {
        ConfigDescription configDescription = this.getConfigDescription(this.profileConfigUri, locale);
        if (configDescription != null) {
            return List.of(configDescription);
        }
        return List.of();
    }

    public @Nullable ConfigDescription getConfigDescription(URI uri, @Nullable Locale locale) {
        if (!uri.equals(this.profileConfigUri)) {
            return null;
        }
        ConfigDescription template = this.configDescRegistry.getConfigDescription(CONFIG_DESCRIPTION_TEMPLATE_URI, locale);
        if (template == null) {
            return null;
        }
        return ConfigDescriptionBuilder.create((URI)uri).withParameters(template.getParameters()).withParameterGroups(template.getParameterGroups()).build();
    }

    @Override
    public void onDependencyChange(String scriptId) {
        String scriptUid = scriptId.substring(OPENHAB_TRANSFORMATION_SCRIPT.length());
        ScriptRecord scriptRecord = this.scriptCache.get(scriptUid);
        if (scriptRecord != null) {
            this.logger.debug("Clearing script cache for script {}", (Object)scriptUid);
            this.clearCache(scriptUid);
        }
    }

    private void clearCache(String uid) {
        ScriptRecord scriptRecord = this.scriptCache.remove(uid);
        if (scriptRecord != null) {
            this.disposeScriptRecord(scriptRecord);
        }
    }

    private void disposeScriptRecord(ScriptRecord scriptRecord) {
        ScriptEngineContainer scriptEngineContainer = scriptRecord.scriptEngineContainer;
        if (scriptEngineContainer != null) {
            this.scriptEngineManager.removeEngine(scriptEngineContainer.getIdentifier());
        }
        scriptRecord.compiledScript = null;
    }

    private static class ScriptRecord {
        public String script = "";
        public @Nullable ScriptEngineContainer scriptEngineContainer;
        public @Nullable CompiledScript compiledScript;
        public final Lock lock = new ReentrantLock();

        private ScriptRecord() {
        }
    }
}

