/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.ui.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardServletErrorPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={Servlet.class})
@HttpWhiteboardServletErrorPage(errorPage={"404"})
@NonNullByDefault
public class UIErrorPageServlet
extends HttpServlet {
    private static final long serialVersionUID = 6472170444750947727L;
    private static final String INDEX_FILE = "/app/index.html";
    private static final Set<String> VALID_ROUTE_SEGMENTS = Set.of("about", "addons", "analyzer", "developer", "equipment", "home", "locations", "overview", "page", "profile", "properties", "res", "settings", "setup-wizard");
    private final Logger logger = LoggerFactory.getLogger(UIErrorPageServlet.class);

    protected void doGet(@NonNullByDefault(value={}) HttpServletRequest req, @NonNullByDefault(value={}) HttpServletResponse resp) throws ServletException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = UIErrorPageServlet.class.getResourceAsStream(INDEX_FILE);){
            if (is == null) {
                this.logger.warn("The index file ({}) does not exist", (Object)INDEX_FILE);
                return;
            }
            String requestURI = (String)req.getAttribute("javax.servlet.error.request_uri");
            int status = this.isValidRoute(requestURI) ? 200 : 404;
            this.logger.debug("Returning index file as response with status {} for request URI: {}", (Object)status, (Object)requestURI);
            resp.setContentType("text/html");
            resp.setStatus(status);
            is.transferTo((OutputStream)resp.getOutputStream());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private boolean isValidRoute(@Nullable String path) {
        if (path == null) {
            return false;
        }
        String[] segments = path.split("/");
        return segments.length > 1 && segments[0].isEmpty() && VALID_ROUTE_SEGMENTS.contains(segments[1]);
    }
}

