/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.model.table;

import org.jfree.layouting.input.style.keys.line.VerticalAlign;
import org.jfree.layouting.input.style.keys.table.TableStyleKeys;
import org.jfree.layouting.input.style.values.CSSValue;
import org.jfree.layouting.layouter.context.LayoutContext;
import org.jfree.layouting.layouter.style.CSSValueResolverUtility;
import org.jfree.layouting.output.OutputProcessorMetaData;
import org.jfree.layouting.renderer.border.Border;
import org.jfree.layouting.renderer.model.BlockRenderBox;
import org.jfree.layouting.renderer.model.BoxDefinition;
import org.jfree.layouting.renderer.model.RenderBox;
import org.jfree.layouting.renderer.model.RenderNode;
import org.jfree.layouting.renderer.model.table.TableRenderBox;
import org.jfree.layouting.renderer.model.table.TableRowRenderBox;

public class TableCellRenderBox
extends BlockRenderBox {
    private int colSpan;
    private int rowSpan;
    private boolean autoGenerated;
    private Border effectiveBorder;
    private int columnIndex;

    public TableCellRenderBox(BoxDefinition boxDefinition, boolean bl) {
        super(boxDefinition);
        this.autoGenerated = bl;
        this.colSpan = 1;
        this.rowSpan = 1;
        this.columnIndex = -1;
    }

    public TableCellRenderBox(BoxDefinition boxDefinition) {
        this(boxDefinition, false);
    }

    @Override
    public void appyStyle(LayoutContext layoutContext, OutputProcessorMetaData outputProcessorMetaData) {
        super.appyStyle(layoutContext, outputProcessorMetaData);
        CSSValue cSSValue = layoutContext.getValue(TableStyleKeys.COL_SPAN);
        this.colSpan = (int)CSSValueResolverUtility.getNumericValue(cSSValue, 1.0);
        CSSValue cSSValue2 = layoutContext.getValue(TableStyleKeys.ROW_SPAN);
        this.rowSpan = (int)CSSValueResolverUtility.getNumericValue(cSSValue2, 1.0);
    }

    @Override
    protected CSSValue normalizeAlignment(CSSValue cSSValue) {
        if (VerticalAlign.BOTTOM.equals(cSSValue)) {
            return cSSValue;
        }
        if (VerticalAlign.TOP.equals(cSSValue)) {
            return cSSValue;
        }
        if (VerticalAlign.MIDDLE.equals(cSSValue)) {
            return cSSValue;
        }
        return VerticalAlign.BASELINE;
    }

    public boolean isAutoGenerated() {
        return this.autoGenerated;
    }

    public RenderNode getCellNode() {
        return this;
    }

    public TableRenderBox getTable() {
        RenderBox renderBox = this.getParent();
        if (renderBox instanceof TableRowRenderBox) {
            TableRowRenderBox tableRowRenderBox = (TableRowRenderBox)renderBox;
            return tableRowRenderBox.getTable();
        }
        return null;
    }

    public int getColSpan() {
        return this.colSpan;
    }

    public int getRowSpan() {
        return this.rowSpan;
    }

    @Override
    public boolean isIgnorableForRendering() {
        return false;
    }

    public Border getEffectiveBorder() {
        return this.effectiveBorder;
    }

    public void setEffectiveBorder(Border border) {
        this.effectiveBorder = border;
    }

    public Border getOriginalBorder() {
        return this.getBoxDefinition().getBorder();
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int n) {
        this.columnIndex = n;
    }
}

