/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import twitter4j.APIResourceBase;
import twitter4j.Authorization;
import twitter4j.HttpClient;
import twitter4j.HttpParameter;
import twitter4j.ObjectFactory;
import twitter4j.RateLimitStatusEvent;
import twitter4j.TwitterException;
import twitter4j.v1.Paging;
import twitter4j.v1.ResponseList;
import twitter4j.v1.Status;
import twitter4j.v1.TimelinesResources;

class TimelinesResourcesImpl
extends APIResourceBase
implements TimelinesResources {
    static final Paging empty = Paging.ofMaxId(Long.MAX_VALUE);
    static final char[] S = new char[]{'s'};
    static final char[] SMCP = new char[]{'s', 'm', 'c', 'p'};
    static final String COUNT = "count";
    static final String PER_PAGE = "per_page";
    private static final HttpParameter[] NULL_PARAMETER_ARRAY = new HttpParameter[0];
    private static final List<HttpParameter> NULL_PARAMETER_LIST = new ArrayList<HttpParameter>(0);

    TimelinesResourcesImpl(HttpClient http, ObjectFactory factory, String restBaseURL, Authorization auth, boolean mbeanEnabled, HttpParameter[] IMPLICIT_PARAMS, String IMPLICIT_PARAMS_STR, List<Consumer<RateLimitStatusEvent>> rateLimitStatusListeners, List<Consumer<RateLimitStatusEvent>> rateLimitReachedListeners) {
        super(http, factory, restBaseURL, auth, mbeanEnabled, IMPLICIT_PARAMS, IMPLICIT_PARAMS_STR, rateLimitStatusListeners, rateLimitReachedListeners);
    }

    @Override
    public ResponseList<Status> getMentionsTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/mentions_timeline.json"));
    }

    @Override
    public ResponseList<Status> getMentionsTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/mentions_timeline.json", TimelinesResourcesImpl.asPostParameterArray(paging)));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/home_timeline.json", includeMyRetweet));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/home_timeline.json", this.mergeParameters(TimelinesResourcesImpl.asPostParameterArray(paging), includeMyRetweet)));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/retweets_of_me.json"));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/retweets_of_me.json", TimelinesResourcesImpl.asPostParameterArray(paging)));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName), new HttpParameter("include_my_retweet", true)}, TimelinesResourcesImpl.asPostParameterArray(paging))));
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId), includeMyRetweet}, TimelinesResourcesImpl.asPostParameterArray(paging))));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, empty);
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId) throws TwitterException {
        return this.getUserTimeline(userId, empty);
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(empty);
    }

    @Override
    public ResponseList<Status> getUserTimeline(@NotNull Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.restBaseURL + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{includeMyRetweet}, TimelinesResourcesImpl.asPostParameterArray(paging))));
    }

    static List<HttpParameter> asPostParameterList(Paging paging) {
        return TimelinesResourcesImpl.asPostParameterList(SMCP, COUNT, paging);
    }

    static HttpParameter[] asPostParameterArray(Paging paging) {
        List<HttpParameter> list = TimelinesResourcesImpl.asPostParameterList(SMCP, COUNT, paging);
        if (list.size() == 0) {
            return NULL_PARAMETER_ARRAY;
        }
        return list.toArray(new HttpParameter[0]);
    }

    static List<HttpParameter> asPostParameterList(char[] supportedParams, Paging paging) {
        return TimelinesResourcesImpl.asPostParameterList(supportedParams, COUNT, paging);
    }

    static List<HttpParameter> asPostParameterList(char[] supportedParams, String perPageParamName, Paging paging) {
        ArrayList<HttpParameter> pagingParams = new ArrayList<HttpParameter>(supportedParams.length);
        if (paging != empty) {
            TimelinesResourcesImpl.addPostParameter(supportedParams, 's', pagingParams, "since_id", paging.sinceId);
            TimelinesResourcesImpl.addPostParameter(supportedParams, 'm', pagingParams, "max_id", paging.maxId);
            TimelinesResourcesImpl.addPostParameter(supportedParams, 'c', pagingParams, perPageParamName, paging.count);
            TimelinesResourcesImpl.addPostParameter(supportedParams, 'p', pagingParams, "page", paging.page);
        }
        return pagingParams;
    }

    static HttpParameter[] asPostParameterArray(char[] supportedParams, String perPageParamName, Paging paging) {
        return TimelinesResourcesImpl.asPostParameterList(supportedParams, perPageParamName, paging).toArray(new HttpParameter[0]);
    }

    private static void addPostParameter(char[] supportedParams, char paramKey, List<HttpParameter> pagingParams, String paramName, long paramValue) {
        boolean supported = false;
        for (char supportedParam : supportedParams) {
            if (supportedParam != paramKey) continue;
            supported = true;
            break;
        }
        if (!supported && -1L != paramValue) {
            throw new IllegalStateException("Paging parameter [" + paramName + "] is not supported with this operation.");
        }
        if (-1L != paramValue) {
            pagingParams.add(new HttpParameter(paramName, String.valueOf(paramValue)));
        }
    }
}

