/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.rendering.internal;

import java.io.IOException;
import org.hibernate.models.rendering.RenderingException;
import org.hibernate.models.rendering.spi.AbstractRenderingTarget;

public class RenderingTargetStreamImpl
extends AbstractRenderingTarget {
    private final Appendable outputStream;

    public RenderingTargetStreamImpl() {
        this(System.out);
    }

    public RenderingTargetStreamImpl(int indentationDepth) {
        this(System.out, indentationDepth);
    }

    public RenderingTargetStreamImpl(Appendable outputStream) {
        this(outputStream, 2);
    }

    public RenderingTargetStreamImpl(Appendable outputStream, int indentationDepth) {
        super(indentationDepth);
        this.outputStream = outputStream;
    }

    @Override
    protected void write(String chars) {
        try {
            this.outputStream.append(chars);
        }
        catch (IOException e) {
            throw new RenderingException("Error adding characters to stream (Appendable): " + chars, e);
        }
    }
}

