/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action.internal;

import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.entry.CacheEntry;
import org.hibernate.engine.internal.Versioning;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionEventListenerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.monitor.spi.EventMonitor;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.spi.EventSource;
import org.hibernate.event.spi.PostCommitInsertEventListener;
import org.hibernate.event.spi.PostInsertEvent;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PreInsertEvent;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.generator.values.GeneratedValues;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.stat.internal.StatsHelper;
import org.hibernate.stat.spi.StatisticsImplementor;

public class EntityInsertAction
extends AbstractEntityInsertAction {
    private Object version;
    private Object cacheEntry;

    public EntityInsertAction(Object id, Object[] state, Object instance, Object version, EntityPersister persister, boolean isVersionIncrementDisabled, EventSource session) {
        super(id, state, instance, isVersionIncrementDisabled, persister, session);
        this.version = version;
    }

    public Object getVersion() {
        return this.version;
    }

    public void setVersion(Object version) {
        this.version = version;
    }

    protected Object getCacheEntry() {
        return this.cacheEntry;
    }

    protected void setCacheEntry(Object cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    @Override
    public boolean isEarlyInsert() {
        return false;
    }

    @Override
    protected Object getRowId() {
        return null;
    }

    @Override
    protected EntityKey getEntityKey() {
        return this.getSession().generateEntityKey(this.getId(), this.getPersister());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws HibernateException {
        this.nullifyTransientReferencesIfNotAlready();
        EventSource session = this.getSession();
        Object id = this.getId();
        boolean veto = this.preInsert();
        if (!veto) {
            GeneratedValues generatedValues;
            EntityPersister persister = this.getPersister();
            Object instance = this.getInstance();
            EventMonitor eventMonitor = session.getEventMonitor();
            DiagnosticEvent event = eventMonitor.beginEntityInsertEvent();
            boolean success = false;
            try {
                generatedValues = persister.getInsertCoordinator().insert(instance, id, this.getState(), session);
                success = true;
            }
            finally {
                eventMonitor.completeEntityInsertEvent(event, id, persister.getEntityName(), success, session);
            }
            PersistenceContext persistenceContext = session.getPersistenceContextInternal();
            EntityEntry entry = persistenceContext.getEntry(instance);
            if (entry == null) {
                throw new AssertionFailure("possible non-threadsafe access to session");
            }
            entry.postInsert(this.getState());
            this.handleGeneratedProperties(entry, generatedValues, persistenceContext);
            persistenceContext.registerInsertedKey(persister, this.getId());
            this.addCollectionsByKeyToPersistenceContext(persistenceContext, this.getState());
        }
        this.putCacheIfNecessary();
        this.handleNaturalIdPostSaveNotifications(id);
        this.postInsert();
        StatisticsImplementor statistics = session.getFactory().getStatistics();
        if (statistics.isStatisticsEnabled() && !veto) {
            statistics.insertEntity(this.getPersister().getEntityName());
        }
        this.markExecuted();
    }

    private void handleGeneratedProperties(EntityEntry entry, GeneratedValues generatedValues, PersistenceContext persistenceContext) {
        Object rowId;
        EntityPersister persister = this.getPersister();
        if (persister.hasInsertGeneratedProperties()) {
            Object instance = this.getInstance();
            persister.processInsertGeneratedProperties(this.getId(), instance, this.getState(), generatedValues, this.getSession());
            if (persister.isVersionPropertyGenerated()) {
                this.version = Versioning.getVersion(this.getState(), persister);
            }
            entry.postUpdate(instance, this.getState(), this.version);
        } else if (persister.isVersionPropertyGenerated()) {
            this.version = Versioning.getVersion(this.getState(), persister);
            entry.postInsert(this.version);
        }
        if (generatedValues != null && persister.getRowIdMapping() != null && (rowId = generatedValues.getGeneratedValue(persister.getRowIdMapping())) != null) {
            persistenceContext.replaceEntityEntryRowId(this.getInstance(), rowId);
        }
    }

    protected void putCacheIfNecessary() {
        EventSource session;
        EntityPersister persister = this.getPersister();
        if (this.isCachePutEnabled(persister, session = this.getSession())) {
            SessionFactoryImplementor factory = session.getFactory();
            CacheEntry ce = persister.buildCacheEntry(this.getInstance(), this.getState(), this.version, session);
            this.cacheEntry = persister.getCacheEntryStructure().structure(ce);
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            Object ck = cache.generateCacheKey(this.getId(), persister, factory, session.getTenantIdentifier());
            boolean put = this.cacheInsert(persister, ck);
            StatisticsImplementor statistics = factory.getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(StatsHelper.getRootEntityRole(persister), cache.getRegion().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheInsert(EntityPersister persister, Object ck) {
        EventSource session = this.getSession();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        EntityDataAccess cacheAccessStrategy = persister.getCacheAccessStrategy();
        boolean insert = false;
        try {
            session.getEventListenerManager().cachePutStart();
            boolean bl = insert = cacheAccessStrategy.insert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, (SharedSessionContractImplementor)session, (CachedDomainDataAccess)cacheAccessStrategy, this.getPersister(), insert, EventMonitor.CacheActionDescription.ENTITY_INSERT);
            session.getEventListenerManager().cachePutEnd();
        }
    }

    protected void postInsert() {
        this.getEventListenerGroups().eventListenerGroup_POST_INSERT.fireLazyEventOnEachListener(this::newPostInsertEvent, PostInsertEventListener::onPostInsert);
    }

    private PostInsertEvent newPostInsertEvent() {
        return new PostInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
    }

    protected void postCommitInsert(boolean success) {
        this.getEventListenerGroups().eventListenerGroup_POST_COMMIT_INSERT.fireLazyEventOnEachListener(this::newPostInsertEvent, success ? PostInsertEventListener::onPostInsert : this::postCommitOnFailure);
    }

    private void postCommitOnFailure(PostInsertEventListener listener, PostInsertEvent event) {
        if (listener instanceof PostCommitInsertEventListener) {
            PostCommitInsertEventListener postCommitInsertEventListener = (PostCommitInsertEventListener)listener;
            postCommitInsertEventListener.onPostInsertCommitFailed(event);
        } else {
            listener.onPostInsert(event);
        }
    }

    protected boolean preInsert() {
        EventListenerGroup<PreInsertEventListener> listenerGroup = this.getEventListenerGroups().eventListenerGroup_PRE_INSERT;
        if (listenerGroup.isEmpty()) {
            return false;
        }
        boolean veto = false;
        PreInsertEvent event = new PreInsertEvent(this.getInstance(), this.getId(), this.getState(), this.getPersister(), this.eventSource());
        for (PreInsertEventListener listener : listenerGroup.listeners()) {
            veto |= listener.onPreInsert(event);
        }
        return veto;
    }

    @Override
    public void doAfterTransactionCompletion(boolean success, SharedSessionContractImplementor session) throws HibernateException {
        EntityPersister persister = this.getPersister();
        if (success && this.isCachePutEnabled(persister, this.getSession())) {
            EntityDataAccess cache = persister.getCacheAccessStrategy();
            SessionFactoryImplementor factory = session.getFactory();
            Object ck = cache.generateCacheKey(this.getId(), persister, factory, session.getTenantIdentifier());
            boolean put = this.cacheAfterInsert(cache, ck);
            StatisticsImplementor statistics = factory.getStatistics();
            if (put && statistics.isStatisticsEnabled()) {
                statistics.entityCachePut(StatsHelper.getRootEntityRole(persister), cache.getRegion().getName());
            }
        }
        this.postCommitInsert(success);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean cacheAfterInsert(EntityDataAccess cache, Object ck) {
        EventSource session = this.getSession();
        SessionEventListenerManager eventListenerManager = session.getEventListenerManager();
        EventMonitor eventMonitor = session.getEventMonitor();
        DiagnosticEvent cachePutEvent = eventMonitor.beginCachePutEvent();
        boolean afterInsert = false;
        try {
            eventListenerManager.cachePutStart();
            boolean bl = afterInsert = cache.afterInsert(session, ck, this.cacheEntry, this.version);
            return bl;
        }
        finally {
            eventMonitor.completeCachePutEvent(cachePutEvent, (SharedSessionContractImplementor)session, (CachedDomainDataAccess)cache, this.getPersister(), afterInsert, EventMonitor.CacheActionDescription.ENTITY_AFTER_INSERT);
            eventListenerManager.cachePutEnd();
        }
    }

    @Override
    protected boolean hasPostCommitEventListeners() {
        EventListenerGroup<PostInsertEventListener> group = this.getEventListenerGroups().eventListenerGroup_POST_COMMIT_INSERT;
        for (PostInsertEventListener listener : group.listeners()) {
            if (!listener.requiresPostCommitHandling(this.getPersister())) continue;
            return true;
        }
        return false;
    }

    protected boolean isCachePutEnabled(EntityPersister persister, SharedSessionContractImplementor session) {
        return persister.canWriteToCache() && !persister.isCacheInvalidationRequired() && session.getCacheMode().isPutEnabled();
    }
}

