/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.JWTAuthorizationGrantValidationContext;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.TokenManager;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.JWTAuthorizationGrantContext;
import org.keycloak.services.clientpolicy.context.TokenExchangeRequestContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;

public class DownscopeAssertionGrantEnforcerExecutor
implements ClientPolicyExecutorProvider {
    private final KeycloakSession session;

    public DownscopeAssertionGrantEnforcerExecutor(KeycloakSession session) {
        this.session = session;
    }

    public String getProviderId() {
        return "downscope-assertion-grant-enforcer";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case TOKEN_EXCHANGE_REQUEST: {
                TokenExchangeContext tokenExchangeContext = ((TokenExchangeRequestContext)context).getTokenExchangeContext();
                Set<String> restrictedScopes = this.checkDownscope(tokenExchangeContext.getClient(), this.getAccessTokenFromSubjectToken(tokenExchangeContext), tokenExchangeContext.getParams().getScope());
                tokenExchangeContext.setRestrictedScopes(restrictedScopes);
                break;
            }
            case JWT_AUTHORIZATION_GRANT: {
                JWTAuthorizationGrantContext jwtAuthnGrantContext = (JWTAuthorizationGrantContext)context;
                JWTAuthorizationGrantValidationContext jwtContext = jwtAuthnGrantContext.getAuthorizationGrantContext();
                Set<String> restrictedScopes = this.checkDownscope(this.session.getContext().getClient(), this.getAccessTokenFromAssertion(jwtContext.getAssertion()), jwtContext.getScopeParam());
                jwtContext.setRestrictedScopes(restrictedScopes);
            }
        }
    }

    private AccessToken getAccessTokenFromAssertion(String assertion) throws ClientPolicyException {
        try {
            return (AccessToken)new JWSInput(assertion).readJsonContent(AccessToken.class);
        }
        catch (JWSInputException e) {
            throw new ClientPolicyException("invalid_request", "Assertion contains an invalid access token");
        }
    }

    private AccessToken getAccessTokenFromSubjectToken(TokenExchangeContext context) throws ClientPolicyException {
        if (!"urn:ietf:params:oauth:token-type:access_token".equals(context.getParams().getSubjectTokenType())) {
            throw new ClientPolicyException("invalid_request", "Parameter 'subject_token' should be access_token for the executor");
        }
        return this.getAccessTokenFromAssertion(context.getParams().getSubjectToken());
    }

    private Set<String> checkDownscope(ClientModel client, AccessToken token, String scopeParam) throws ClientPolicyException {
        Set tokenScopes;
        Set set = tokenScopes = token.getScope() != null ? TokenManager.parseScopeParameter(token.getScope()).collect(Collectors.toSet()) : Collections.emptySet();
        if (scopeParam != null) {
            Set requestedScopes = TokenManager.parseScopeParameter(scopeParam).collect(Collectors.toSet());
            requestedScopes.removeAll(tokenScopes);
            if (!requestedScopes.isEmpty()) {
                throw new ClientPolicyException("invalid_scope", String.format("Scopes %s not present in the initial access token %s", requestedScopes, tokenScopes));
            }
        }
        Set<String> restrictedScopes = client.getClientScopes(true).values().stream().filter(Predicate.not(ClientScopeModel::isIncludeInTokenScope)).map(ClientScopeModel::getName).collect(Collectors.toSet());
        restrictedScopes.addAll(tokenScopes);
        return restrictedScopes;
    }
}

