/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import java.util.HashSet;
import java.util.Map;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ResourceStore;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.authorization.store.StoreFactory;
import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.RealmMigration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;

public class MigrateTo26_4_3
extends RealmMigration {
    public static final ModelVersion VERSION = new ModelVersion("26.4.3");

    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrateRealm(KeycloakSession session, RealmModel realm) {
        ClientModel client = realm.getAdminPermissionsClient();
        if (client == null) {
            return;
        }
        AuthorizationProvider authorizationProvider = (AuthorizationProvider)session.getProvider(AuthorizationProvider.class);
        StoreFactory storeFactory = authorizationProvider.getStoreFactory();
        ResourceServer resourceServer = storeFactory.getResourceServerStore().findByClient(client);
        if (resourceServer == null) {
            return;
        }
        ScopeStore scopeStore = storeFactory.getScopeStore();
        Scope resetPassword = scopeStore.findByName(resourceServer, "reset-password");
        if (resetPassword == null) {
            resetPassword = scopeStore.create(resourceServer, "reset-password");
        }
        ResourceStore resourceStore = storeFactory.getResourceStore();
        String userResourceType = AdminPermissionsSchema.USERS.getType();
        Resource resourceTypeResource = resourceStore.findByName(resourceServer, userResourceType);
        HashSet<Scope> newScopes = new HashSet<Scope>(resourceTypeResource.getScopes());
        newScopes.add(resetPassword);
        resourceTypeResource.updateScopes(newScopes);
        for (Policy policy : storeFactory.getPolicyStore().find(resourceServer, Map.of(Policy.FilterOption.CONFIG, new String[]{"defaultResourceType", userResourceType}), Integer.valueOf(-1), Integer.valueOf(-1))) {
            for (Resource resource : policy.getResources()) {
                resource.updateScopes(newScopes);
            }
        }
    }
}

