/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.smallrye.health.runtime.dev.ui;

import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.smallrye.health.SmallRyeHealth;
import io.smallrye.health.SmallRyeHealthReporter;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.subscription.BackPressureStrategy;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.MultiEmitter;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class HealthJsonRPCService {
    @Inject
    SmallRyeHealthReporter smallRyeHealthReporter;
    private final Set<MultiEmitter<? super SmallRyeHealth>> healthEmitters = ConcurrentHashMap.newKeySet();
    private final Set<MultiEmitter<? super String>> statusEmitters = ConcurrentHashMap.newKeySet();
    private final AtomicInteger activeSubscribers = new AtomicInteger(0);
    private final AtomicReference<SmallRyeHealth> latest = new AtomicReference();
    private volatile Cancellable pollingCancellable;
    private static final String UP_ICON = "<vaadin-icon style='color:var(--lumo-success-text-color);' icon='font-awesome-solid:thumbs-up'></vaadin-icon>";
    private static final String DOWN_ICON = "<vaadin-icon style='color:var(--lumo-error-text-color);' icon='font-awesome-solid:thumbs-down'></vaadin-icon>";

    private synchronized void startPollingIfNeeded(int interval) {
        if (this.pollingCancellable == null) {
            this.pollingCancellable = Multi.createFrom().ticks().every(Duration.ofSeconds(interval)).onItem().transformToUniAndMerge(tick -> this.smallRyeHealthReporter.getHealthAsync()).subscribe().with(smallRyeHealth -> {
                this.latest.set((SmallRyeHealth)smallRyeHealth);
                for (MultiEmitter<? super SmallRyeHealth> multiEmitter : this.healthEmitters) {
                    multiEmitter.emit(smallRyeHealth);
                }
                for (MultiEmitter multiEmitter : this.statusEmitters) {
                    multiEmitter.emit((Object)this.getStatusIcon((SmallRyeHealth)smallRyeHealth));
                }
            }, failure -> {
                JsonObject errorPayload = Json.createObjectBuilder().add("status", "DOWN").add("checks", Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Smallrye Health stream").add("status", "DOWN").add("data", Json.createObjectBuilder().add("reason", failure.getMessage())))).build();
                SmallRyeHealth errorHealth = new SmallRyeHealth(errorPayload);
                this.latest.set(errorHealth);
                for (MultiEmitter<? super SmallRyeHealth> multiEmitter : this.healthEmitters) {
                    multiEmitter.emit((Object)errorHealth);
                }
                for (MultiEmitter multiEmitter : this.statusEmitters) {
                    multiEmitter.emit((Object)this.getStatusIcon(errorHealth));
                }
            });
        }
    }

    private synchronized void stopPolling() {
        if (this.pollingCancellable != null) {
            this.pollingCancellable.cancel();
            this.pollingCancellable = null;
            this.latest.set(null);
        }
    }

    private synchronized void restartPolling(int interval) {
        this.stopPolling();
        if (interval > 0) {
            this.startPollingIfNeeded(interval);
        }
    }

    @JsonRpcDescription(value="Get the current Health of the running Quarkus application")
    public Uni<SmallRyeHealth> getHealth() {
        return this.smallRyeHealthReporter.getHealthAsync();
    }

    public Multi<SmallRyeHealth> streamHealth(String interval) {
        int iv = this.getIntervalValue(interval);
        return Multi.createFrom().emitter(emitter -> {
            this.activeSubscribers.incrementAndGet();
            this.healthEmitters.add((MultiEmitter<? super SmallRyeHealth>)emitter);
            SmallRyeHealth current = this.latest.get();
            if (current != null) {
                emitter.emit((Object)current);
            }
            this.restartPolling(iv);
            emitter.onTermination(() -> {
                this.healthEmitters.remove(emitter);
                if (this.activeSubscribers.decrementAndGet() == 0) {
                    this.stopPolling();
                }
            });
        }, BackPressureStrategy.LATEST);
    }

    public String getStatus() {
        return this.getStatusIcon(this.smallRyeHealthReporter.getHealth());
    }

    public Multi<String> streamStatus(String interval) {
        int iv = this.getIntervalValue(interval);
        return Multi.createFrom().emitter(emitter -> {
            this.activeSubscribers.incrementAndGet();
            this.statusEmitters.add((MultiEmitter<? super String>)emitter);
            SmallRyeHealth current = this.latest.get();
            if (current != null) {
                emitter.emit((Object)this.getStatusIcon(current));
            }
            this.restartPolling(iv);
            emitter.onTermination(() -> {
                this.statusEmitters.remove(emitter);
                if (this.activeSubscribers.decrementAndGet() == 0) {
                    this.stopPolling();
                }
            });
        }, BackPressureStrategy.LATEST);
    }

    private String getStatusIcon(SmallRyeHealth smallRyeHealth) {
        String status;
        if (smallRyeHealth.getPayload() != null && smallRyeHealth.getPayload().containsKey((Object)"status") && (status = smallRyeHealth.getPayload().getString("status")).equalsIgnoreCase("UP")) {
            return UP_ICON;
        }
        return DOWN_ICON;
    }

    private int getIntervalValue(String interval) {
        if (interval == null || interval.isBlank()) {
            interval = "10s";
        }
        if (interval.equalsIgnoreCase("Off")) {
            return -1;
        }
        return Integer.parseInt(interval.substring(0, interval.length() - 1));
    }
}

