/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.hibernate.AssertionFailure;
import org.hibernate.boot.model.NamedEntityGraphDefinition;
import org.hibernate.boot.query.NamedQueryDefinition;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.spi.JpaMetamodelImplementor;

public class InjectionHelper {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(MetadataContext.class);

    public static void injectEntityGraph(NamedEntityGraphDefinition definition, Class<?> metamodelClass, JpaMetamodelImplementor jpaMetamodel) {
        if (metamodelClass != null) {
            String name = definition.name();
            String fieldName = "_" + InjectionHelper.javaIdentifier(name);
            RootGraphImplementor<?> graph = jpaMetamodel.findEntityGraphByName(name);
            try {
                InjectionHelper.injectField(metamodelClass, fieldName, graph, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public static void injectTypedQueryReference(NamedQueryDefinition<?> definition, Class<?> metamodelClass) {
        if (metamodelClass != null) {
            String fieldName = "_" + InjectionHelper.javaIdentifier(definition.getRegistrationName()) + "_";
            try {
                InjectionHelper.injectField(metamodelClass, fieldName, definition, false);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
    }

    public static String javaIdentifier(String name) {
        int codePoint;
        StringBuilder result = new StringBuilder();
        for (int position = 0; position < name.length(); position += Character.charCount(codePoint)) {
            codePoint = name.codePointAt(position);
            result.appendCodePoint(Character.isJavaIdentifierPart(codePoint) ? codePoint : 95);
        }
        return result.toString();
    }

    public static void injectField(Class<?> metamodelClass, String name, Object model, boolean allowNonDeclaredFieldReference) throws NoSuchFieldException {
        Field field = allowNonDeclaredFieldReference ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
        try {
            if (!Modifier.isPublic(metamodelClass.getModifiers())) {
                ReflectHelper.ensureAccessibility(field);
            }
            field.set(null, model);
        }
        catch (IllegalAccessException e) {
            throw new AssertionFailure("Unable to inject attribute '" + name + "' of static metamodel class '" + metamodelClass.getName() + "'", e);
        }
        catch (IllegalArgumentException e) {
            log.illegalArgumentOnStaticMetamodelFieldInjection(metamodelClass.getName(), name, model.getClass().getName(), field.getType().getName());
        }
    }
}

