/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util.internal;

import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class IntSet {
    private static final int MAX_OID_TO_STORE_IN_BITSET = 65536;
    private @Nullable Set<Integer> set;
    private final BitSet bitSet = new BitSet();

    public void clear() {
        this.set = null;
        this.bitSet.clear();
    }

    public void addAll(Collection<? extends Integer> values) {
        for (Integer n : values) {
            this.add(n);
        }
    }

    public boolean add(int value) {
        if (value >= 0 && value <= 65536) {
            boolean contains = this.bitSet.get(value);
            if (!contains) {
                this.bitSet.set(value);
                return true;
            }
            return false;
        }
        Set<Integer> set = this.set;
        if (set == null) {
            this.set = set = new HashSet<Integer>();
        }
        return set.add(value);
    }

    public boolean remove(int value) {
        if (value >= 0 && value <= 65536) {
            boolean contains = this.bitSet.get(value);
            if (contains) {
                this.bitSet.clear(value);
                return true;
            }
            return false;
        }
        Set<Integer> set = this.set;
        return set != null && set.remove(value);
    }

    public boolean contains(int value) {
        if (value >= 0 && value <= 65536) {
            return this.bitSet.get(value);
        }
        Set<Integer> set = this.set;
        return set != null && set.contains(value);
    }

    public Set<Integer> toMutableSet() {
        Set<Integer> set = this.set;
        HashSet<Integer> result = new HashSet<Integer>((int)((float)(this.bitSet.cardinality() + (set != null ? set.size() : 0)) / 0.75f));
        if (set != null) {
            result.addAll(set);
        }
        this.bitSet.stream().forEach(result::add);
        return result;
    }
}

