/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.core.KotlinIndicesHelper;
import org.jetbrains.kotlin.idea.core.TypesWithOperatorDetector;
import org.jetbrains.kotlin.idea.util.FuzzyType;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/core/TypesWithGetValueDetector;", "Lorg/jetbrains/kotlin/idea/core/TypesWithOperatorDetector;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "indicesHelper", "Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;", "propertyOwnerType", "Lorg/jetbrains/kotlin/idea/util/FuzzyType;", "propertyType", "<init>", "(Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;Lorg/jetbrains/kotlin/idea/core/KotlinIndicesHelper;Lorg/jetbrains/kotlin/idea/util/FuzzyType;Lorg/jetbrains/kotlin/idea/util/FuzzyType;)V", "checkIsSuitableByType", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "operator", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "freeTypeParams", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.base.fe10.analysis"})
public final class TypesWithGetValueDetector
extends TypesWithOperatorDetector {
    @NotNull
    private final FuzzyType propertyOwnerType;
    @Nullable
    private final FuzzyType propertyType;

    public TypesWithGetValueDetector(@NotNull LexicalScope scope, @Nullable KotlinIndicesHelper indicesHelper2, @NotNull FuzzyType propertyOwnerType, @Nullable FuzzyType propertyType) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)propertyOwnerType, (String)"propertyOwnerType");
        super(OperatorNameConventions.GET_VALUE, scope, indicesHelper2);
        this.propertyOwnerType = propertyOwnerType;
        this.propertyType = propertyType;
    }

    @Override
    @Nullable
    protected TypeSubstitutor checkIsSuitableByType(@NotNull FunctionDescriptor operator, @NotNull Collection<? extends TypeParameterDescriptor> freeTypeParams) {
        Intrinsics.checkNotNullParameter((Object)operator, (String)"operator");
        Intrinsics.checkNotNullParameter(freeTypeParams, (String)"freeTypeParams");
        List list2 = operator.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getValueParameters(...)");
        KotlinType kotlinType = ((ValueParameterDescriptor)CollectionsKt.first((List)list2)).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        FuzzyType paramType = FuzzyTypeUtils.toFuzzyType(kotlinType, freeTypeParams);
        TypeSubstitutor typeSubstitutor = paramType.checkIsSuperTypeOf(this.propertyOwnerType);
        if (typeSubstitutor == null) {
            return null;
        }
        TypeSubstitutor substitutor2 = typeSubstitutor;
        if (this.propertyType == null) {
            return substitutor2;
        }
        Object object = operator.getReturnType();
        if (object == null || (object = FuzzyTypeUtils.toFuzzyType((KotlinType)object, freeTypeParams)) == null) {
            return null;
        }
        Object fuzzyReturnType = object;
        TypeSubstitutor typeSubstitutor2 = ((FuzzyType)fuzzyReturnType).checkIsSubtypeOf(this.propertyType);
        if (typeSubstitutor2 == null) {
            return null;
        }
        TypeSubstitutor substitutorFromPropertyType = typeSubstitutor2;
        return FuzzyTypeUtils.combineIfNoConflicts(substitutor2, substitutorFromPropertyType, freeTypeParams);
    }
}

