/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.quickFix;

import com.intellij.codeInsight.daemon.LightDaemonAnalyzerTestCase;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.quickFix.ActionHint;
import com.intellij.codeInsight.daemon.quickFix.QuickFixTestCase;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewPopupUpdateProcessor;
import com.intellij.modcommand.ActionContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.NonBlockingReadActionImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import junit.framework.TestCase;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public abstract class LightQuickFixTestCase
extends LightDaemonAnalyzerTestCase {
    @NonNls
    protected static final String BEFORE_PREFIX = "before";
    @NonNls
    protected static final String AFTER_PREFIX = "after";
    @NonNls
    protected static final String PREVIEW_PREFIX = "preview";
    private static QuickFixTestCase myWrapper;

    @Override
    protected void tearDown() throws Exception {
        myWrapper = null;
        super.tearDown();
    }

    protected boolean shouldBeAvailableAfterExecution() {
        return false;
    }

    private static void doTestFor(@NotNull String testName, @NotNull QuickFixTestCase quickFixTestCase) {
        if (testName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(0);
        }
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(1);
        }
        String relativePath = (String)ObjectUtils.notNull((Object)quickFixTestCase.getBasePath(), (Object)"") + "/before" + testName;
        String testFullPath = quickFixTestCase.getTestDataPath().replace(File.separatorChar, '/') + relativePath;
        File testFile = new File(testFullPath);
        CommandProcessor.getInstance().executeCommand(quickFixTestCase.getProject(), () -> {
            try {
                String contents = StringUtil.convertLineSeparators((String)FileUtil.loadFile((File)testFile, (Charset)StandardCharsets.UTF_8));
                quickFixTestCase.configureFromFileText(testFile.getName(), contents);
                quickFixTestCase.bringRealEditorBack();
                ActionHint actionHint = quickFixTestCase.parseActionHintImpl(quickFixTestCase.getFile(), contents);
                quickFixTestCase.beforeActionStarted(testName, contents);
                try {
                    myWrapper = quickFixTestCase;
                    quickFixTestCase.doAction(actionHint, testFullPath, testName);
                }
                finally {
                    myWrapper = null;
                    quickFixTestCase.afterActionCompleted(testName, contents);
                }
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new AssertionError(testName + " failed", e);
            }
        }, "", (Object)"");
    }

    protected void afterActionCompleted(String testName, String contents) {
    }

    protected void beforeActionStarted(String testName, String contents) {
    }

    public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName, @NotNull QuickFixTestCase quickFix) throws Exception {
        IntentionAction action;
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(2);
        }
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(3);
        }
        if (testName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(4);
        }
        if (quickFix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(5);
        }
        if ((action = actionHint.findAndCheck(quickFix.getAvailableActions(), ActionContext.from((Editor)this.getEditor(), (PsiFile)this.getFile()), () -> this.getTestInfo(testFullPath, quickFix))) != null) {
            IntentionAction afterAction;
            String text = action.getText();
            PsiElement element = PsiUtilBase.getElementAtCaret((Editor)this.getEditor());
            if (actionHint.shouldCheckPreview()) {
                String previewFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/preview" + testName;
                quickFix.checkPreviewAndInvoke(action, previewFilePath);
            } else {
                quickFix.invoke(action);
            }
            UIUtil.dispatchAllInvocationEvents();
            UIUtil.dispatchAllInvocationEvents();
            if (!quickFix.shouldBeAvailableAfterExecution() && (afterAction = quickFix.findActionWithText(text)) != null && Comparing.equal((Object)element, (Object)PsiUtilBase.getElementAtCaret((Editor)this.getEditor()))) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' is still available after its invocation in test " + testFullPath));
            }
            NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
            String expectedFilePath = (String)ObjectUtils.notNull((Object)quickFix.getBasePath(), (Object)"") + "/after" + testName;
            quickFix.checkResultByFile("In file :" + expectedFilePath, expectedFilePath, false);
            String familyName = action.getFamilyName();
            if (StringUtil.isEmptyOrSpaces((String)familyName)) {
                LightQuickFixTestCase.fail((String)("Action '" + text + "' provides empty family name which means that user would see action with empty presentable text in Inspection Results"));
            }
        }
    }

    private String getTestInfo(@NotNull String testFullPath, @NotNull QuickFixTestCase quickFix) {
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(6);
        }
        if (quickFix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(7);
        }
        String infos = LightQuickFixTestCase.getCurrentHighlightingInfo(quickFix.doHighlighting());
        return "Test: " + testFullPath + "\nLanguage level: " + String.valueOf(PsiUtil.getLanguageLevel((Project)quickFix.getProject())) + "\n" + (String)(quickFix.getProject().equals((Object)this.getProject()) ? "SDK: " + String.valueOf(ModuleRootManager.getInstance((Module)this.getModule()).getSdk()) + "\n" : "") + "Infos: " + infos;
    }

    static String getCurrentHighlightingInfo(@NotNull List<? extends HighlightInfo> infos) {
        if (infos == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(8);
        }
        return ((StreamEx)StreamEx.of(infos).filter(info -> info.getSeverity() != HighlightInfoType.SYMBOL_TYPE_SEVERITY)).map(info -> {
            ArrayList s = new ArrayList();
            info.findRegisteredQuickFix((descriptor, range) -> {
                s.add(String.valueOf(range) + " " + String.valueOf(descriptor));
                return null;
            });
            String fixes = StreamEx.of(s).mapLastOrElse("|- "::concat, "\\- "::concat).map(str -> "        " + str + "\n").joining();
            return String.valueOf(info.getSeverity()) + ": (" + info.getStartOffset() + "," + info.getEndOffset() + ") '" + info.getText() + "': " + info.getDescription() + "\n" + fixes;
        }).joining((CharSequence)"       ");
    }

    protected void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName) throws Exception {
        if (actionHint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(9);
        }
        if (testFullPath == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(10);
        }
        if (testName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(11);
        }
        this.doAction(actionHint, testFullPath, testName, myWrapper);
    }

    protected void doAction(@NotNull String actionName) {
        if (actionName == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(12);
        }
        List<IntentionAction> available = this.getAvailableActions();
        IntentionAction action = LightQuickFixTestCase.findActionWithText(available, actionName);
        LightQuickFixTestCase.assertNotNull((String)("Action '" + actionName + "' not found among " + String.valueOf(available)), (Object)action);
        this.invoke(action);
    }

    protected void invoke(@NotNull IntentionAction action) throws IncorrectOperationException {
        if (action == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(13);
        }
        CodeInsightTestFixtureImpl.invokeIntention(action, this.getFile(), this.getEditor());
    }

    protected IntentionAction findActionAndCheck(@NotNull ActionHint hint, String testFullPath) {
        if (hint == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(14);
        }
        return hint.findAndCheck(this.getAvailableActions(), () -> "Test: " + testFullPath);
    }

    protected IntentionAction findActionWithText(@NotNull String text) {
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(15);
        }
        return LightQuickFixTestCase.findActionWithText(this.getAvailableActions(), text);
    }

    public static IntentionAction findActionWithText(@NotNull List<? extends IntentionAction> actions, @NotNull String text) {
        if (actions == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(16);
        }
        if (text == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(17);
        }
        for (IntentionAction intentionAction : actions) {
            if (!text.equals(intentionAction.getText())) continue;
            return intentionAction;
        }
        return null;
    }

    public static void doAllTests(QuickFixTestCase testCase2) {
        File[] files;
        for (File file : files = LightQuickFixTestCase.getBeforeTestFiles(testCase2)) {
            String testName = file.getName().substring(BEFORE_PREFIX.length());
            LightQuickFixTestCase.doTestFor(testName, testCase2);
        }
    }

    public static File @NotNull [] getBeforeTestFiles(@NotNull QuickFixTestCase testCase2) {
        if (testCase2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(18);
        }
        LightQuickFixTestCase.assertNotNull((String)"getBasePath() should not return null!", (Object)testCase2.getBasePath());
        String testDirPath = testCase2.getTestDataPath().replace(File.separatorChar, '/') + testCase2.getBasePath();
        File testDir = new File(testDirPath);
        File[] files = testDir.listFiles((dir, name) -> name.startsWith(BEFORE_PREFIX));
        if (files == null || files.length == 0) {
            LightQuickFixTestCase.fail((String)("Test files not found in " + testDirPath));
        }
        if (files == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(19);
        }
        return files;
    }

    protected void doSingleTest(@NotNull String fileSuffix) {
        if (fileSuffix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(20);
        }
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper());
    }

    protected void doSingleTest(@NotNull String fileSuffix, String testDataPath) {
        if (fileSuffix == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(21);
        }
        LightQuickFixTestCase.doTestFor(fileSuffix, this.createWrapper(testDataPath));
    }

    protected ActionHint parseActionHintImpl(@NotNull PsiFile psiFile, @NotNull String contents) {
        if (psiFile == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(22);
        }
        if (contents == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(23);
        }
        return ActionHint.parse(psiFile, contents);
    }

    @NotNull
    protected QuickFixTestCase createWrapper() {
        QuickFixTestCase quickFixTestCase = this.createWrapper(null);
        if (quickFixTestCase == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(24);
        }
        return quickFixTestCase;
    }

    @NotNull
    protected QuickFixTestCase createWrapper(final String testDataPath) {
        return new QuickFixTestCase(){
            String myTestDataPath;
            {
                this.myTestDataPath = testDataPath;
            }

            @Override
            public String getBasePath() {
                return LightQuickFixTestCase.this.getBasePath();
            }

            @Override
            @NotNull
            public String getTestDataPath() {
                if (this.myTestDataPath == null) {
                    this.myTestDataPath = LightQuickFixTestCase.this.getTestDataPath();
                }
                String string = this.myTestDataPath;
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public ActionHint parseActionHintImpl(@NotNull PsiFile file, @NotNull String contents) {
                if (file == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(2);
                }
                ActionHint actionHint = LightQuickFixTestCase.this.parseActionHintImpl(file, contents);
                if (actionHint == null) {
                    1.$$$reportNull$$$0(3);
                }
                return actionHint;
            }

            @Override
            public void beforeActionStarted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(5);
                }
                LightQuickFixTestCase.this.beforeActionStarted(testName, contents);
            }

            @Override
            public void afterActionCompleted(@NotNull String testName, @NotNull String contents) {
                if (testName == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(7);
                }
                LightQuickFixTestCase.this.afterActionCompleted(testName, contents);
            }

            @Override
            public void doAction(@NotNull ActionHint actionHint, @NotNull String testFullPath, @NotNull String testName) throws Exception {
                if (actionHint == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (testFullPath == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (testName == null) {
                    1.$$$reportNull$$$0(10);
                }
                LightQuickFixTestCase.this.doAction(actionHint, testFullPath, testName);
            }

            @Override
            public void checkResultByFile(@NotNull String message, @NotNull String expectedFilePath, boolean ignoreTrailingSpaces) {
                if (message == null) {
                    1.$$$reportNull$$$0(11);
                }
                if (expectedFilePath == null) {
                    1.$$$reportNull$$$0(12);
                }
                LightQuickFixTestCase.this.checkResultByFile(message, expectedFilePath, ignoreTrailingSpaces);
            }

            @Override
            public IntentionAction findActionWithText(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(13);
                }
                return LightQuickFixTestCase.this.findActionWithText(text);
            }

            @Override
            public boolean shouldBeAvailableAfterExecution() {
                return LightQuickFixTestCase.this.shouldBeAvailableAfterExecution();
            }

            @Override
            public void invoke(@NotNull IntentionAction action) {
                if (action == null) {
                    1.$$$reportNull$$$0(14);
                }
                LightQuickFixTestCase.this.invoke(action);
            }

            @Override
            public void checkPreviewAndInvoke(@NotNull IntentionAction action, @NotNull String previewFilePath) {
                String previewContent;
                if (action == null) {
                    1.$$$reportNull$$$0(15);
                }
                if (previewFilePath == null) {
                    1.$$$reportNull$$$0(16);
                }
                try {
                    previewContent = (String)ReadAction.nonBlocking(() -> IntentionPreviewPopupUpdateProcessor.getPreviewContent((Project)this.getProject(), (IntentionAction)action, (PsiFile)this.getFile(), (Editor)LightQuickFixTestCase.this.getEditor())).submit((Executor)AppExecutorUtil.getAppExecutorService()).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
                LightQuickFixTestCase.this.invoke(action);
                NonBlockingReadActionImpl.waitForAsyncTaskCompletion();
                Path path = Path.of(this.getTestDataPath(), previewFilePath);
                if (Files.exists(path, new LinkOption[0])) {
                    UsefulTestCase.assertSameLinesWithFile(path.toString(), previewContent);
                } else {
                    if (previewContent.isEmpty()) {
                        TestCase.fail((String)("No preview was generated for '" + action.getText() + "'"));
                    }
                    TestCase.assertEquals((String)this.getFile().getText(), (String)previewContent);
                }
            }

            @Override
            @NotNull
            public @Unmodifiable List<HighlightInfo> doHighlighting() {
                List list = LightQuickFixTestCase.this.doHighlighting();
                if (list == null) {
                    1.$$$reportNull$$$0(17);
                }
                return list;
            }

            @Override
            @NotNull
            public @Unmodifiable List<IntentionAction> getAvailableActions() {
                List<IntentionAction> list = LightQuickFixTestCase.this.getAvailableActions();
                if (list == null) {
                    1.$$$reportNull$$$0(18);
                }
                return list;
            }

            @Override
            public void configureFromFileText(@NotNull String name, @NotNull String contents) {
                if (name == null) {
                    1.$$$reportNull$$$0(19);
                }
                if (contents == null) {
                    1.$$$reportNull$$$0(20);
                }
                LightQuickFixTestCase.this.configureFromFileText(name, contents, true);
            }

            @Override
            public PsiFile getFile() {
                return LightQuickFixTestCase.this.getFile();
            }

            @Override
            public Project getProject() {
                return LightQuickFixTestCase.this.getProject();
            }

            @Override
            public void bringRealEditorBack() {
                LightQuickFixTestCase.this.bringRealEditorBack();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 7: 
                    case 20: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contents";
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testName";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "actionHint";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "testFullPath";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 12: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expectedFilePath";
                        break;
                    }
                    case 13: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 14: 
                    case 15: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "action";
                        break;
                    }
                    case 16: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "previewFilePath";
                        break;
                    }
                    case 19: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestDataPath";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 19: 
                    case 20: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "parseActionHintImpl";
                        break;
                    }
                    case 17: {
                        objectArray = objectArray2;
                        objectArray2[1] = "doHighlighting";
                        break;
                    }
                    case 18: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAvailableActions";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "parseActionHintImpl";
                        break;
                    }
                    case 4: 
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "beforeActionStarted";
                        break;
                    }
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "afterActionCompleted";
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: {
                        objectArray = objectArray;
                        objectArray[2] = "doAction";
                        break;
                    }
                    case 11: 
                    case 12: {
                        objectArray = objectArray;
                        objectArray[2] = "checkResultByFile";
                        break;
                    }
                    case 13: {
                        objectArray = objectArray;
                        objectArray[2] = "findActionWithText";
                        break;
                    }
                    case 14: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                    case 15: 
                    case 16: {
                        objectArray = objectArray;
                        objectArray[2] = "checkPreviewAndInvoke";
                        break;
                    }
                    case 19: 
                    case 20: {
                        objectArray = objectArray;
                        objectArray[2] = "configureFromFileText";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 19, 20 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    protected @Unmodifiable List<IntentionAction> getAvailableActions() {
        this.doHighlighting();
        return LightQuickFixTestCase.getAvailableActions(this.getEditor(), this.getFile());
    }

    @NotNull
    public static @Unmodifiable List<IntentionAction> getAvailableActions(@NotNull Editor editor2, @NotNull PsiFile file) {
        if (editor2 == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(25);
        }
        if (file == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(26);
        }
        List<IntentionAction> list = CodeInsightTestFixtureImpl.getAvailableIntentions(editor2, file);
        if (list == null) {
            LightQuickFixTestCase.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NonNls
    protected String getBasePath() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 19, 24, 27 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFixTestCase";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHint";
                break;
            }
            case 3: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFullPath";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quickFix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testCase";
                break;
            }
            case 19: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSuffix";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contents";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/quickFix/LightQuickFixTestCase";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeforeTestFiles";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createWrapper";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTestFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHighlightingInfo";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findActionAndCheck";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findActionWithText";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBeforeTestFiles";
                break;
            }
            case 19: 
            case 24: 
            case 27: {
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "doSingleTest";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parseActionHintImpl";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAvailableActions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 19, 24, 27 -> new IllegalStateException(string);
        };
    }
}

