"""Generated client library for geminicloudassist version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.geminicloudassist.v1alpha import geminicloudassist_v1alpha_messages as messages


class GeminicloudassistV1alpha(base_api.BaseApiClient):
  """Generated client library for service geminicloudassist version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://geminicloudassist.googleapis.com/'
  MTLS_BASE_URL = 'https://geminicloudassist.mtls.googleapis.com/'

  _PACKAGE = 'geminicloudassist'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'GeminicloudassistV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new geminicloudassist handle."""
    url = url or self.BASE_URL
    super(GeminicloudassistV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_investigations_revisions = self.ProjectsLocationsInvestigationsRevisionsService(self)
    self.projects_locations_investigations = self.ProjectsLocationsInvestigationsService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsInvestigationsRevisionsService(base_api.BaseApiService):
    """Service class for the projects_locations_investigations_revisions resource."""

    _NAME = 'projects_locations_investigations_revisions'

    def __init__(self, client):
      super(GeminicloudassistV1alpha.ProjectsLocationsInvestigationsRevisionsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new revision of a given Investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InvestigationRevision) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.revisions.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['investigationRevisionId', 'requestId'],
        relative_path='v1alpha/{+parent}/revisions',
        request_field='investigationRevision',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsCreateRequest',
        response_type_name='InvestigationRevision',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single revision of an Investigation. Fails if the revision is the investigation's most recent revision.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions/{revisionsId}',
        http_method='DELETE',
        method_id='geminicloudassist.projects.locations.investigations.revisions.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single revision of an Investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InvestigationRevision) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions/{revisionsId}',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.investigations.revisions.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsGetRequest',
        response_type_name='InvestigationRevision',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Investigations in a given project.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInvestigationRevisionsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.investigations.revisions.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/revisions',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsListRequest',
        response_type_name='ListInvestigationRevisionsResponse',
        supports_download=False,
    )

    def Modify(self, request, global_params=None):
      r"""Modifies an existing investigation revision in place. This is intended for use by callers that are modifying as part of an investigation session, and do not want to create a new revision. Other callers should use UpdateInvestigation, which will create a new revision if the investigation is RUNNING.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsModifyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (InvestigationRevision) The response message.
      """
      config = self.GetMethodConfig('Modify')
      return self._RunMethod(
          config, request, global_params=global_params)

    Modify.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions/{revisionsId}:modify',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.revisions.modify',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:modify',
        request_field='modifyInvestigationRevisionRequest',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsModifyRequest',
        response_type_name='InvestigationRevision',
        supports_download=False,
    )

    def Run(self, request, global_params=None):
      r"""Run an existing revision of an investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsRevisionsRunRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Run')
      return self._RunMethod(
          config, request, global_params=global_params)

    Run.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}/revisions/{revisionsId}:run',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.revisions.run',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:run',
        request_field='runInvestigationRevisionRequest',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsRevisionsRunRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsInvestigationsService(base_api.BaseApiService):
    """Service class for the projects_locations_investigations resource."""

    _NAME = 'projects_locations_investigations'

    def __init__(self, client):
      super(GeminicloudassistV1alpha.ProjectsLocationsInvestigationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Investigation in a given project.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Investigation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['investigationId', 'requestId'],
        relative_path='v1alpha/{+parent}/investigations',
        request_field='investigation',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsCreateRequest',
        response_type_name='Investigation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}',
        http_method='DELETE',
        method_id='geminicloudassist.projects.locations.investigations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Investigation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.investigations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsGetRequest',
        response_type_name='Investigation',
        supports_download=False,
    )

    def GetIamPolicy(self, request, global_params=None):
      r"""Gets the access control policy for a resource. Returns an empty policy if the resource exists and does not have a policy set.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsGetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('GetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    GetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}:getIamPolicy',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.investigations.getIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=['options_requestedPolicyVersion'],
        relative_path='v1alpha/{+resource}:getIamPolicy',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsGetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Investigations in a given project and location.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListInvestigationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.investigations.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/investigations',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsListRequest',
        response_type_name='ListInvestigationsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Investigation.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Investigation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}',
        http_method='PATCH',
        method_id='geminicloudassist.projects.locations.investigations.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='investigation',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsPatchRequest',
        response_type_name='Investigation',
        supports_download=False,
    )

    def SetIamPolicy(self, request, global_params=None):
      r"""Sets the access control policy on the specified resource. Replaces any existing policy. Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED` errors.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsSetIamPolicyRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Policy) The response message.
      """
      config = self.GetMethodConfig('SetIamPolicy')
      return self._RunMethod(
          config, request, global_params=global_params)

    SetIamPolicy.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}:setIamPolicy',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.setIamPolicy',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:setIamPolicy',
        request_field='setIamPolicyRequest',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsSetIamPolicyRequest',
        response_type_name='Policy',
        supports_download=False,
    )

    def TestIamPermissions(self, request, global_params=None):
      r"""Returns permissions that a caller has on the specified resource. If the resource does not exist, this will return an empty set of permissions, not a `NOT_FOUND` error. Note: This operation is designed to be used for building permission-aware UIs and command-line tools, not for authorization checking. This operation may "fail open" without warning.

      Args:
        request: (GeminicloudassistProjectsLocationsInvestigationsTestIamPermissionsRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (TestIamPermissionsResponse) The response message.
      """
      config = self.GetMethodConfig('TestIamPermissions')
      return self._RunMethod(
          config, request, global_params=global_params)

    TestIamPermissions.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/investigations/{investigationsId}:testIamPermissions',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.investigations.testIamPermissions',
        ordered_params=['resource'],
        path_params=['resource'],
        query_params=[],
        relative_path='v1alpha/{+resource}:testIamPermissions',
        request_field='testIamPermissionsRequest',
        request_type_name='GeminicloudassistProjectsLocationsInvestigationsTestIamPermissionsRequest',
        response_type_name='TestIamPermissionsResponse',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(GeminicloudassistV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (GeminicloudassistProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='geminicloudassist.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='GeminicloudassistProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (GeminicloudassistProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='geminicloudassist.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (GeminicloudassistProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (GeminicloudassistProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(GeminicloudassistV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (GeminicloudassistProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (GeminicloudassistProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='geminicloudassist.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='GeminicloudassistProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(GeminicloudassistV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
