/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public abstract class AbstractConstantPoolReferenceInfo
extends AbstractConstantPoolInfoJava {
    private short classIndex;
    private short nameAndTypeIndex;

    protected AbstractConstantPoolReferenceInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.classIndex = reader.readNextShort();
        this.nameAndTypeIndex = reader.readNextShort();
    }

    public int getClassIndex() {
        return this.classIndex & 0xFFFF;
    }

    public int getNameAndTypeIndex() {
        return this.nameAndTypeIndex & 0xFFFF;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "unnamed";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(WORD, "class_index", null);
        structure.add(WORD, "name_and_type_index", null);
        return structure;
    }
}

