/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.description;

import generic.hash.SimpleCRC32;
import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.CategoryRecord;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.RowKey;
import ghidra.framework.protocol.ghidra.GhidraURL;
import ghidra.util.Msg;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class ExecutableRecord
implements Comparable<ExecutableRecord> {
    public static final Date EMPTY_DATE = new Date(0L);
    public static final int ALREADY_STORED = 1;
    public static final int LIBRARY = 2;
    public static final int CATEGORIES_SET = 4;
    public static final int METADATA_NAME = 1;
    public static final int METADATA_ARCH = 2;
    public static final int METADATA_COMP = 4;
    public static final int METADATA_DATE = 8;
    public static final int METADATA_REPO = 16;
    public static final int METADATA_PATH = 32;
    public static final int METADATA_LIBR = 64;
    private final String md5sum;
    private final String executableName;
    private final String architecture;
    private final String compilerName;
    private Date date;
    private String repository;
    private String path;
    private RowKey rowid;
    private int flags;
    private List<CategoryRecord> usercat;
    private int xrefIndex;

    private static void wordToAscii(int val, StringBuilder buf) {
        for (int i = 28; i >= 0; i -= 4) {
            int nibble = val >> i & 0xF;
            if (nibble < 10) {
                buf.append((char)(nibble + 48));
                continue;
            }
            buf.append((char)(nibble - 10 + 97));
        }
    }

    public static String calcLibraryMd5Placeholder(String enm, String arc) {
        int feed;
        int i;
        int hi = 0xB1B110;
        int lo = -88409414;
        for (i = 0; i < enm.length(); ++i) {
            feed = lo >>> 24;
            lo = SimpleCRC32.hashOneByte((int)lo, (int)(enm.charAt(i) & 0xFF));
            hi = SimpleCRC32.hashOneByte((int)hi, (int)feed);
        }
        lo ^= 0xF1B1F1B1;
        for (i = 0; i < arc.length(); ++i) {
            feed = lo >>> 24;
            lo = SimpleCRC32.hashOneByte((int)lo, (int)(arc.charAt(i) & 0xFF));
            hi = SimpleCRC32.hashOneByte((int)hi, (int)feed);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("bbbbbbbbaaaaaaaa");
        ExecutableRecord.wordToAscii(hi, buf);
        ExecutableRecord.wordToAscii(lo, buf);
        return buf.toString();
    }

    protected ExecutableRecord(String md5) {
        this.md5sum = md5;
        this.executableName = "";
        this.architecture = "";
        this.compilerName = "";
        this.rowid = null;
        this.flags = 0;
        this.usercat = null;
        this.xrefIndex = 0;
        this.repository = null;
        this.path = null;
        this.date = EMPTY_DATE;
    }

    public ExecutableRecord(String md5, String execName, String compilerName, String architecture, Date date, RowKey id, String repo, String path) {
        this.md5sum = md5;
        this.executableName = execName;
        this.architecture = architecture;
        this.compilerName = compilerName;
        this.rowid = id;
        this.flags = 0;
        this.usercat = null;
        this.xrefIndex = 0;
        this.setRepository(repo, path);
        this.setDate(date);
    }

    public ExecutableRecord(String md5, String enm, String cnm, String arc, Date dt, List<CategoryRecord> uc, RowKey id, String repo, String pth) {
        this.md5sum = md5;
        this.executableName = enm;
        this.architecture = arc;
        this.compilerName = cnm;
        this.rowid = id;
        this.flags = 0;
        this.xrefIndex = 0;
        this.setRepository(repo, pth);
        this.setDate(dt);
        this.setCategory(uc);
    }

    public ExecutableRecord(String enm, String arc, RowKey id) {
        this.executableName = enm;
        this.architecture = arc;
        this.compilerName = "";
        this.date = EMPTY_DATE;
        this.repository = null;
        this.path = null;
        this.rowid = id;
        this.flags = 2;
        this.md5sum = ExecutableRecord.calcLibraryMd5Placeholder(enm, arc);
        this.usercat = null;
        this.xrefIndex = 0;
    }

    protected void setRepository(String repo, String newpath) {
        this.repository = null;
        if (repo != null) {
            URL ghidraURL;
            try {
                ghidraURL = new URL(repo);
                if (!GhidraURL.isGhidraURL((String)repo) || !GhidraURL.isServerRepositoryURL((URL)ghidraURL) && !GhidraURL.isLocalProjectURL((URL)ghidraURL)) {
                    throw new IllegalArgumentException("Unsupported repository URL: " + repo);
                }
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unsupported repository URL: " + repo, e);
            }
            URL projectURL = GhidraURL.getProjectURL((URL)ghidraURL);
            this.repository = projectURL.toExternalForm();
        }
        this.path = newpath;
        if (this.path != null && this.path.charAt(this.path.length() - 1) == '/') {
            this.path = this.path.length() == 1 ? null : this.path.substring(0, this.path.length() - 1);
        }
        if (this.path != null && this.path.charAt(0) == '/') {
            this.path = this.path.length() == 1 ? null : this.path.substring(1);
        }
    }

    private void setDate(Date dt) {
        this.date = dt == null ? EMPTY_DATE : dt;
    }

    protected void setRowId(RowKey i) {
        this.rowid = i;
    }

    protected void setAlreadyStored() {
        this.flags |= 1;
    }

    protected void setXrefIndex(int val) {
        this.xrefIndex = val;
    }

    protected void setCategory(List<CategoryRecord> cats) {
        this.flags |= 4;
        if (cats == null || cats.size() == 0) {
            this.usercat = null;
            return;
        }
        this.usercat = cats;
        Collections.sort(this.usercat);
    }

    protected void cloneCategories(ExecutableRecord op2) {
        this.flags &= 0xFFFFFFFB;
        if (op2.categoriesAreSet()) {
            this.flags |= 4;
        }
        if (op2.usercat == null) {
            return;
        }
        this.usercat = new ArrayList<CategoryRecord>();
        for (int i = 0; i < op2.usercat.size(); ++i) {
            CategoryRecord curRec = op2.usercat.get(i);
            CategoryRecord cloneRec = new CategoryRecord(curRec.getType(), curRec.getCategory());
            this.usercat.add(cloneRec);
        }
    }

    public List<CategoryRecord> getAllCategories() {
        return this.usercat;
    }

    public List<String> getCategory(String type) {
        CategoryRecord currec;
        if (this.usercat == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        int min = 0;
        int max = this.usercat.size() - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            String curtype = this.usercat.get(mid).getType();
            int cmp = type.compareTo(curtype);
            if (cmp <= 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        while (min < this.usercat.size() && type.equals((currec = this.usercat.get(min)).getType())) {
            ++min;
            res.add(currec.getCategory());
        }
        return res;
    }

    public boolean hasCategory(String type, String value) {
        if (this.usercat == null) {
            return false;
        }
        int min = 0;
        int max = this.usercat.size() - 1;
        while (min <= max) {
            int mid = (min + max) / 2;
            CategoryRecord catrec = this.usercat.get(mid);
            if (catrec == null) {
                Msg.error((Object)this, (Object)("No entry in category list found for index: " + mid + " (list size = " + this.usercat.size() + ")"));
                return false;
            }
            String curtype = catrec.getType();
            int cmp = type.compareTo(curtype);
            if (cmp == 0) {
                int subcmp = value.compareTo(catrec.getCategory());
                if (subcmp < 0) {
                    max = mid - 1;
                    continue;
                }
                if (subcmp > 0) {
                    min = mid + 1;
                    continue;
                }
                return true;
            }
            if (cmp < 0) {
                max = mid - 1;
                continue;
            }
            min = mid + 1;
        }
        return false;
    }

    public String getMd5() {
        return this.md5sum;
    }

    public String getNameExec() {
        return this.executableName;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public String getNameCompiler() {
        return this.compilerName;
    }

    public Date getDate() {
        return this.date;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isLibrary() {
        return (this.flags & 2) != 0;
    }

    public boolean isAlreadyStored() {
        return (this.flags & 1) != 0;
    }

    public boolean categoriesAreSet() {
        return (this.flags & 4) != 0;
    }

    public String getURLString() {
        if (this.repository == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(this.repository);
        if (GhidraURL.isLocalGhidraURL((String)this.repository) && !this.repository.endsWith("?")) {
            buf.append("?");
        }
        if (this.path != null) {
            buf.append('/').append(this.path);
        }
        buf.append('/').append(this.executableName);
        return buf.toString();
    }

    public String getExeCategoryAlphabetic(String type) {
        List<String> catrecs = this.getCategory(type);
        if (catrecs == null || catrecs.size() == 0) {
            return "";
        }
        if (catrecs.size() == 1) {
            return catrecs.get(0);
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            buf.append(catrecs.get(i));
            if (i + 1 >= catrecs.size()) break;
            if (i >= 3) continue;
            buf.append(',');
        }
        return buf.toString();
    }

    public RowKey getRowId() {
        return this.rowid;
    }

    public int getXrefIndex() {
        return this.xrefIndex;
    }

    public void saveXml(Writer fwrite) throws IOException {
        fwrite.append("<exe");
        if (this.isLibrary()) {
            fwrite.append(" library=\"true\"");
        }
        fwrite.append(">\n");
        fwrite.append("  <md5>").append(this.md5sum).append("</md5>\n");
        fwrite.append("  <name>");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.executableName);
        fwrite.append("</name>\n");
        fwrite.append("  <arch>");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.architecture);
        fwrite.append("</arch>\n");
        fwrite.append("  <compiler>");
        SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.compilerName);
        fwrite.append("</compiler>\n");
        long seconds = this.date.getTime();
        long millis = seconds % 1000L;
        fwrite.append("  <date millis=\"").append(SpecXmlUtils.encodeUnsignedInteger((long)millis)).append("\">");
        fwrite.append(SpecXmlUtils.encodeUnsignedInteger((long)(seconds /= 1000L)));
        fwrite.append("</date>\n");
        if (this.repository != null) {
            fwrite.append("  <repository>");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.repository);
            fwrite.append("</repository>\n");
        }
        if (this.path != null) {
            fwrite.append("  <path>");
            SpecXmlUtils.xmlEscapeWriter((Writer)fwrite, (String)this.path);
            fwrite.append("</path>\n");
        }
        if (this.usercat != null) {
            for (CategoryRecord element : this.usercat) {
                element.saveXml(fwrite);
            }
        }
        fwrite.append("</exe>\n");
    }

    public static boolean isLibraryHash(String md5) {
        if (md5.length() != 32) {
            return false;
        }
        return md5.startsWith("bbbbbbbbaaaaaaaa");
    }

    public static ExecutableRecord restoreXml(XmlPullParser parser, DescriptionManager man) throws LSHException {
        ExecutableRecord res;
        XmlElement el = parser.start(new String[]{"exe"});
        boolean islib = SpecXmlUtils.decodeBoolean((String)el.getAttribute("library"));
        parser.start(new String[]{"md5"});
        String md5sum = parser.end().getText();
        parser.start(new String[]{"name"});
        String name_exec = parser.end().getText();
        String name_compiler = "";
        String architecture = "";
        long seconds = 0L;
        long millis = 0L;
        RowKey id = null;
        String repo = null;
        String path = null;
        ArrayList<CategoryRecord> cats = null;
        while (parser.peek().isStart()) {
            if (parser.peek().getName().equals("category")) {
                if (cats == null) {
                    cats = new ArrayList<CategoryRecord>();
                }
                CategoryRecord newrec = CategoryRecord.restoreXml(parser);
                cats.add(newrec);
                continue;
            }
            XmlElement subel = parser.start(new String[0]);
            String nm = subel.getName();
            if (nm.equals("arch")) {
                architecture = parser.end().getText();
                continue;
            }
            if (nm.equals("compiler")) {
                name_compiler = parser.end().getText();
                continue;
            }
            if (nm.equals("date")) {
                millis = SpecXmlUtils.decodeLong((String)subel.getAttribute("millis"));
                if (millis < 0L || millis > 1000L) {
                    millis = 0L;
                }
                seconds = SpecXmlUtils.decodeLong((String)parser.end().getText());
                continue;
            }
            if (nm.equals("repository")) {
                repo = parser.end().getText();
                continue;
            }
            if (nm.equals("path")) {
                path = parser.end().getText();
                continue;
            }
            parser.end();
        }
        parser.end(el);
        if (islib) {
            res = man.newExecutableLibrary(name_exec, architecture, id);
            if (!res.getMd5().equals(md5sum)) {
                throw new LSHException("Read bad library placeholder md5 for ExecutableRecord");
            }
        } else {
            long date_milli = seconds * 1000L + millis;
            res = man.newExecutableRecord(md5sum, name_exec, name_compiler, architecture, new Date(date_milli), repo, path, id);
        }
        res.setCategory(cats);
        return res;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        ExecutableRecord o = (ExecutableRecord)obj;
        return this.md5sum.equals(o.md5sum);
    }

    public int hashCode() {
        return this.md5sum.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "\n\tExecutable Name: " + this.executableName + "\n\tArchitecture: " + this.architecture + "\n\tCompiler Name: " + this.compilerName + "\n\tPath: " + this.path;
    }

    @Override
    public int compareTo(ExecutableRecord o) {
        if (this == o) {
            return 0;
        }
        int comp = this.md5sum.compareTo(o.md5sum);
        return comp;
    }

    public int compareMetadata(ExecutableRecord o) {
        int res = 0;
        if (!this.executableName.equals(o.executableName)) {
            res |= 1;
        }
        if (!this.architecture.equals(o.architecture)) {
            res |= 2;
        }
        if ((this.flags & 2) != (o.flags & 2)) {
            res |= 0x40;
        }
        if ((this.flags & 2) != 0) {
            return res;
        }
        if (!this.compilerName.equals(o.compilerName)) {
            res |= 4;
        }
        if (!this.date.equals(o.date)) {
            res |= 8;
        }
        if (this.repository == null) {
            if (o.repository != null) {
                res |= 0x10;
            }
        } else if (o.repository == null) {
            res |= 0x10;
        } else if (!this.repository.equals(o.repository)) {
            res |= 0x10;
        }
        if (this.path == null) {
            if (o.path != null) {
                res |= 0x20;
            }
        } else if (o.path == null) {
            res |= 0x20;
        } else if (!this.path.equals(o.path)) {
            res |= 0x20;
        }
        return res;
    }

    public boolean compareCategory(ExecutableRecord op2) {
        if (this.usercat == null) {
            return op2.usercat == null;
        }
        if (op2.usercat == null) {
            return false;
        }
        if (this.usercat.size() != op2.usercat.size()) {
            return false;
        }
        for (int i = 0; i < this.usercat.size(); ++i) {
            if (this.usercat.get(i).equals(op2.usercat.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<CategoryRecord> findInsertions(List<CategoryRecord> oldlist, List<CategoryRecord> newlist) {
        if (newlist == null && oldlist != null) {
            return null;
        }
        if (newlist != null && oldlist == null) {
            return newlist;
        }
        ArrayList<CategoryRecord> insert = new ArrayList<CategoryRecord>();
        int i = 0;
        int j = 0;
        while (i < oldlist.size() || j < newlist.size()) {
            if (j == newlist.size()) {
                return null;
            }
            if (i == oldlist.size()) {
                insert.add(newlist.get(j));
                ++j;
                continue;
            }
            CategoryRecord oldcat = oldlist.get(i);
            CategoryRecord newcat = newlist.get(j);
            int cmp = newcat.compareTo(oldcat);
            if (cmp < 0) {
                insert.add(newcat);
                ++j;
                continue;
            }
            if (cmp == 0) {
                ++i;
                ++j;
                continue;
            }
            return null;
        }
        return insert;
    }

    public boolean diffForUpdate(Update res, ExecutableRecord fromDB) {
        res.name_exec = !this.executableName.equals(fromDB.executableName);
        res.architecture = !this.architecture.equals(fromDB.architecture);
        boolean bl = res.name_compiler = !this.compilerName.equals(fromDB.compilerName);
        res.repository = this.repository == null && fromDB.repository == null ? false : (this.repository != null && fromDB.repository != null ? !this.repository.equals(fromDB.repository) : this.repository != null);
        res.path = this.path == null && fromDB.path == null ? false : (this.path != null && fromDB.path != null ? !this.path.equals(fromDB.path) : this.path != null);
        boolean bl2 = res.date = !this.date.equals(fromDB.date);
        if (this.usercat == null && fromDB.usercat == null) {
            res.categories = false;
            res.catinsert = null;
        } else {
            res.catinsert = ExecutableRecord.findInsertions(fromDB.usercat, this.usercat);
            if (res.catinsert == null) {
                res.categories = true;
            } else if (res.catinsert.size() == 0) {
                res.categories = false;
                res.catinsert = null;
            } else {
                res.categories = true;
            }
        }
        this.rowid = fromDB.rowid;
        res.update = this;
        return res.name_exec || res.architecture || res.name_compiler || res.repository || res.path || res.date || res.categories;
    }

    public String printRaw() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.md5sum);
        buf.append(' ');
        buf.append(this.executableName);
        buf.append(' ');
        buf.append(this.architecture);
        buf.append(' ');
        buf.append(this.compilerName);
        return buf.toString();
    }

    public static class Update {
        public ExecutableRecord update;
        public boolean name_exec;
        public boolean architecture;
        public boolean name_compiler;
        public boolean repository;
        public boolean path;
        public boolean date;
        public boolean categories;
        public List<CategoryRecord> catinsert;
    }
}

