/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

import docking.DockingWindowManager;
import docking.widgets.OptionDialog;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.label.GIconLabel;
import docking.widgets.label.GLabel;
import generic.util.WindowUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import ghidra.util.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LaunchErrorDialog
extends JDialog {
    private boolean isCancelled;
    private final URL url;
    private final URL fileURL;

    public LaunchErrorDialog(URL url, URL fileURL) {
        super((Frame)DockingWindowManager.getActiveInstance().getRootFrame(), true);
        this.url = url;
        this.fileURL = fileURL;
        this.setTitle("Unable to Launch Manual Viewer");
        JComponent workPanel = this.createWorkPanel();
        this.getContentPane().add(workPanel);
        this.pack();
        Window activeWindow = DockingWindowManager.getActiveInstance().getActiveWindow();
        Point centerPoint = WindowUtilities.centerOnComponent((Component)activeWindow, (Component)this);
        this.setLocation(centerPoint);
        DockingWindowManager.setHelpLocation((JComponent)workPanel, (HelpLocation)new HelpLocation("ShowInstructionInfoPlugin", "Show_Processor_Manual"));
    }

    private JComponent createWorkPanel() {
        JPanel rootPanel = new JPanel(new BorderLayout());
        JPanel workPanel = new JPanel();
        workPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        workPanel.setLayout(new BoxLayout(workPanel, 1));
        JPanel innerPanel = this.createInnerWidgetPanel();
        workPanel.add(Box.createVerticalGlue());
        workPanel.add(innerPanel);
        workPanel.add(Box.createVerticalGlue());
        rootPanel.add(workPanel);
        rootPanel.add((Component)this.createButtonPanel(), "South");
        return rootPanel;
    }

    private JPanel createInnerWidgetPanel() {
        JPanel innerPanel = new JPanel(new BorderLayout());
        GIconLabel iconLabel = new GIconLabel(OptionDialog.getIconForMessageType((int)2));
        iconLabel.setVerticalAlignment(1);
        JPanel widgetPanel = new JPanel((LayoutManager)new VerticalLayout(5));
        widgetPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JTextField urlField = new JTextField(40);
        urlField.setText(this.url.toString());
        Color backgroundColor = urlField.getBackground();
        urlField.setEditable(false);
        urlField.setBackground(backgroundColor);
        JTextField fileField = new JTextField(40);
        fileField.setText(this.fileURL == null ? "" : this.fileURL.toString());
        fileField.setEditable(false);
        fileField.setBackground(backgroundColor);
        JPanel textFieldPanel = new JPanel((LayoutManager)new PairLayout(2, 0));
        textFieldPanel.add((Component)new GLabel("URL: "));
        textFieldPanel.add(urlField);
        textFieldPanel.add((Component)new GLabel("File: "));
        textFieldPanel.add(fileField);
        widgetPanel.add((Component)new GHtmlLabel("<html>Unable to launch a viewer for the manual below.<br><br>Click <b>Edit Settings</b> to change the manual viewer launch settings, or <br>click <b>Cancel</b> to abort launching a manual viewer (<font size=\"2\">See the help (F1) for more information).</font>"));
        widgetPanel.add(Box.createHorizontalStrut(5));
        widgetPanel.add(textFieldPanel);
        GHtmlLabel copyLabel = new GHtmlLabel("<html><font size=\"2\"><i>Ctrl-C to copy</i></font>");
        copyLabel.setHorizontalAlignment(0);
        widgetPanel.add((Component)copyLabel);
        widgetPanel.setMaximumSize(widgetPanel.getPreferredSize());
        innerPanel.add(widgetPanel);
        innerPanel.add((Component)iconLabel, "West");
        return innerPanel;
    }

    private JPanel createButtonPanel() {
        JPanel buttonPanel = new JPanel();
        JButton editButton = new JButton("Edit Settings");
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchErrorDialog.this.editCallback();
            }
        });
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LaunchErrorDialog.this.cancelCallback();
            }
        });
        buttonPanel.add(editButton);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    protected void editCallback() {
        this.isCancelled = false;
        this.setVisible(false);
    }

    protected void cancelCallback() {
        this.isCancelled = true;
        this.setVisible(false);
    }

    boolean isCancelled() {
        return this.isCancelled;
    }
}

