/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexHasConstant;
import ghidra.app.util.bin.format.pe.cli.tables.indexes.CliIndexImplementation;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.InvalidInputException;
import java.io.IOException;

public class CliTableExportedType
extends CliAbstractTable {
    public CliTableExportedType(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        for (int i = 0; i < this.numRows; ++i) {
            CliExportedTypeRow row = new CliExportedTypeRow(reader.readNextInt(), reader.readNextInt(), this.readStringIndex(reader), this.readStringIndex(reader), CliIndexImplementation.readCodedIndex(reader, stream));
            this.rows.add(row);
            this.strings.add(row.typeNameIndex);
            this.strings.add(row.typeNamespaceIndex);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "ExportedType Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumTypeAttributes.dataType, "Flags", "Bitmask of type TypeAttributes");
        rowDt.add(DWORD, "TypeDefId", "4B index into TypeDef table of another module in this Assembly. Hint only. Must match other fields in this row.");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeName", "index into String heap");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "TypeNamespace", "index into String heap");
        rowDt.add(CliIndexImplementation.toDataType(this.metadataStream), "Implementation", "index into File or ExportedType table.");
        return rowDt;
    }

    public class CliExportedTypeRow
    extends CliAbstractTableRow {
        public int flags;
        public int typeDefIdIndex;
        public int typeNameIndex;
        public int typeNamespaceIndex;
        public int implementationIndex;

        public CliExportedTypeRow(int flags, int typeDefIdIndex, int typeNameIndex, int typeNamespaceIndex, int implementationIndex) {
            this.flags = flags;
            this.typeDefIdIndex = typeDefIdIndex;
            this.typeNameIndex = typeNameIndex;
            this.typeNamespaceIndex = typeNamespaceIndex;
            this.implementationIndex = implementationIndex;
        }

        @Override
        public String getRepresentation() {
            String implRep;
            try {
                implRep = CliTableExportedType.this.getRowRepresentationSafe(CliIndexImplementation.getTableName(this.implementationIndex), CliIndexHasConstant.getRowIndex(this.implementationIndex));
            }
            catch (InvalidInputException e) {
                implRep = Integer.toHexString(this.implementationIndex);
            }
            return String.format("%s Namespace %s Flags %s TypeDef %s Implementation %s", CliTableExportedType.this.metadataStream.getStringsStream().getString(this.typeNameIndex), CliTableExportedType.this.metadataStream.getStringsStream().getString(this.typeNamespaceIndex), CliFlags.CliEnumTypeAttributes.dataType.getName(this.flags & 0xFFFFFFFF), "", implRep);
        }
    }
}

